package ipsk.db.speech.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioFormat.Encoding;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotator.AnnotationRequest;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.Link;
import ips.annot.model.emu.EmuBundleAnnotationPersistor;
import ips.annot.model.emu.EmuDB;

import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationManager;
import ipsk.apps.speechrecorder.annotation.auto.impl.PromptAutoAnnotator;
import ipsk.apps.speechrecorder.annotation.auto.impl.TemplateAutoAnnotator;
import ipsk.apps.speechrecorder.storage.SessionStorageManager;
import ipsk.audio.AudioPluginException;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.Selection;
import ipsk.audio.export.RecordingFileExportConfiguration;
import ipsk.audio.plugins.ChannelSelectorPlugin;
import ipsk.audio.plugins.EditPlugin;
import ipsk.db.speech.LocalizedText;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Session;
import ipsk.db.speech.script.Recording;
import ipsk.io.StreamCopy;
import ipsk.persistence.EntityManagerWorker;
import ipsk.webapps.audio.RecordingFileHelper.RecordingFileEdit;

public class EmuBundleExporter extends EntityManagerWorker{
	
	private RecordingFileExportConfiguration configuration;
	private int recordingFileId;
	private Path outputDir;
	private AudioFileFormat.Type pcmAudioFileFormatType;
	private DecimalFormat channelNumberFormatter;
	private ipsk.audio.capture.session.info.RecordingFile recordingFileInfo=null;
	protected SessionStorageManager sessionStorageManager=new SessionStorageManager();
	private EmuDB dbConfig;
	public EmuDB getDbConfig() {
		return dbConfig;
	}
	public void setDbConfig(EmuDB dbConfig) {
		this.dbConfig = dbConfig;
	}
	boolean link=true;
	
	private String pcmDotExtension;
	
	public EmuBundleExporter(EntityManagerFactory entityManagerFactory,RecordingFileExportConfiguration configuration) {
		super(entityManagerFactory);
		setConfiguration(configuration);
	}
	
	public EmuBundleExporter(EntityManager entityManager,RecordingFileExportConfiguration configuration) {
		super(entityManager);
		setConfiguration(configuration);
	}
	
	

	public void decodeAndEditAudiostream(URL recFileUrl,RecordingFileEdit rfe, File outFile)
			throws IOException, UnsupportedAudioFileException, AudioPluginException {
		AudioInputStream encodedInputStream = null;
		try {
//			encodedInputStream = AudioSystemWrapper
//					.getAudioInputStream(recFileUrl);
			encodedInputStream=ThreadSafeAudioSystem.getAudioInputStream(recFileUrl);
		} catch (UnsupportedAudioFileException e) {
			e.printStackTrace();
			throw e;
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		}
//		AudioInputStream pcmSignedStream = AudioSystemWrapper
//				.getAudioInputStream(Encoding.PCM_SIGNED, encodedInputStream);
		AudioInputStream pcmSignedStream=null;
		Selection sel=null;
		try{
			pcmSignedStream = ThreadSafeAudioSystem
			.getAudioInputStream(Encoding.PCM_SIGNED, encodedInputStream);
			AudioFormat af=pcmSignedStream.getFormat();
			float sr=af.getSampleRate();
			sel=rfe.toSelection(sr);
		}catch(IllegalArgumentException iae){
			iae.printStackTrace();
			if(encodedInputStream!=null){
				encodedInputStream.close();
			}
			throw iae;
		}
		AudioInputStream editedPcmSignedStream;
		
		if(sel==null) {
			editedPcmSignedStream=pcmSignedStream;
		}else {
			EditPlugin editplugin=new EditPlugin(sel);
			editedPcmSignedStream=editplugin.getAudioInputStream(pcmSignedStream);
		}
		try {
			ThreadSafeAudioSystem.write(editedPcmSignedStream, pcmAudioFileFormatType, outFile);
		} catch (IOException e) {
			if (pcmSignedStream != null){
				try {
					pcmSignedStream.close();
				} catch (IOException e1) {
					// we throw the first occured exception
				}
			}
			throw e;
		}
		if (pcmSignedStream != null){
			try {
				pcmSignedStream.close();
			} catch (IOException e1) {
				throw e1;
			}
		}
	}

	
	public void doWork() throws ExportException {
		
		EmuBundleAnnotationPersistor bPers=new EmuBundleAnnotationPersistor();
		AutoAnnotationManager autoAnnotationManager=new AutoAnnotationManager();
	    PromptAutoAnnotator paa=new PromptAutoAnnotator();
	    TemplateAutoAnnotator taa=new TemplateAutoAnnotator();
	    
		recordingFileInfo=null;
		
		// create dir if necessary
		if (outputDir == null) {
			throw new ExportException("No output directory!");
		}


		try {
			Files.createDirectories(outputDir);
		}catch(IOException e) {
			throw new ExportException("Could not cerate session directory: "+outputDir);
		}

		RecordingFile recordingFile=entityManager.find(RecordingFile.class,recordingFileId);
		Session session=recordingFile.getSession();
		int sessionId=session.getSessionId();
	    Recording r=recordingFile.getRecording();
	    String ic=null;
	    if(r!=null) {
	    	ic=r.getItemcode();
	    }
	    if(ic==null) {
	    	// No itemcode, use rec file UUD
	    	ic=recordingFile.getUuid();
	    }
	    if(ic==null) {
	    	// No identifier, drop this file
	    	// TODO Is this an error?
	    	return;
	    }
       
	    // Do not use versions
        int recVers=0;
//        Integer recVersion=recordingFile.getVersion();
//        if(recVersion!=null){
//            recVers=recVersion;
//        }
        sessionStorageManager.setOverwrite(true);
        String emuBundleName=sessionStorageManager.getRootFileName(sessionId,ic, session.getCode(),recVers);
        
        Path emuDbBndlDir=outputDir.resolve(emuBundleName+"_bndl");
        try {
			Files.createDirectory(emuDbBndlDir);
		} catch (IOException e2) {
			e2.printStackTrace();
			throw new ExportException(e2);
		}
       
        
        // TODO Duplicate code in RecordingFileExporter
		RecordingFileEdit rfe=new RecordingFileEdit(recordingFile);
		String signalFileUrlStr = recordingFile.getSignalFile();
		
		
		URL recFileUrl = null;

		try {
			recFileUrl = new URL(signalFileUrlStr);
		} catch (MalformedURLException e) {
			e.printStackTrace();
			throw new ExportException(e);
		}
		if (recFileUrl != null) {

			// TODO We need to export a single file for EMU, no versions, pick a channel if project records two or more channels.
			
			File[] emuRecFiles=null;
			
			//File pcmConvertedFile = null;
			File tempPcmConvertedFile=null;
			try{
				boolean isPCMSigned = AudioFormat.Encoding.PCM_SIGNED.toString()
				.equalsIgnoreCase(recordingFile.getEncoding());
//				String path = recFileUrl.getPath();
//				String fileName = path.substring(path.lastIndexOf("/") + 1);
//				int dotIndex = fileName.lastIndexOf(".");
//				String fileNameBody = fileName.substring(0, dotIndex);
//				
				
					// create splitted mono channel audio files 
					String outFileName = emuBundleName.concat(pcmDotExtension);
					Path bundleMasterPath=emuDbBndlDir.resolve(outFileName);
					
					Path tempPcmConvertedFilePath=null;
					// make sure to have a PCM decoded file
					//if (pcmConvertedFile == null) {
						try {
							tempPcmConvertedFilePath= Files.createTempFile(emuBundleName, pcmDotExtension);
							tempPcmConvertedFile =tempPcmConvertedFilePath.toFile();
							decodeAndEditAudiostream(recFileUrl, rfe,tempPcmConvertedFile);
							
						} catch (IOException | UnsupportedAudioFileException | AudioPluginException e) {
							
							throw new ExportException(e);
						}
					//}
					AudioFileFormat aff;
					try {
						aff = ThreadSafeAudioSystem.getAudioFileFormat(tempPcmConvertedFile);
					} catch (UnsupportedAudioFileException e) {
						e.printStackTrace();
						throw new ExportException(e);
					} catch (IOException e) {
						e.printStackTrace();
						throw new ExportException(e);
					}
					AudioFormat af = aff.getFormat();
					int rfChannels = af.getChannels();

					if(rfChannels==1){
						// already converted, mark as non temporary 
						try {
							Files.copy(tempPcmConvertedFilePath,bundleMasterPath);
						} catch (IOException e) {
							e.printStackTrace();
							throw new ExportException(e);
						}
						emuRecFiles=new File[] {bundleMasterPath.toFile()};
					}else if (rfChannels > 1 ) {
						// pick first channel if more than one channel
						// TODO export other channel(s)
						int[] pChannels=new int[] {0};
						int masterChannel=0;
						emuRecFiles=new File[pChannels.length];
						// split
						int pChannelCnt=0;
						for (int i = 0; i < pChannels.length; i++) {
							int selCh = pChannels[i];
							if (selCh > rfChannels) {
								throw new ExportException(
										"Cannot pick audio channel " + selCh
										+ " of " + tempPcmConvertedFile
										+ ". Audio stream has only "
										+ rfChannels + "!");
							}
							String pickedChannelFileName;
							if(selCh==masterChannel) {
								pickedChannelFileName= outFileName;
							}else {
								pickedChannelFileName= emuBundleName + "_"
										+ channelNumberFormatter.format(selCh)
										+ pcmDotExtension;
							}
							File pickedChannelFile = new File(emuDbBndlDir.toFile(),
									pickedChannelFileName);
							ChannelSelectorPlugin chSel = new ChannelSelectorPlugin(
									selCh);
							AudioInputStream pcmOrgStream=null;
							//						try {
							try {
								pcmOrgStream = ThreadSafeAudioSystem
								.getAudioInputStream(tempPcmConvertedFile);
							} catch (UnsupportedAudioFileException e) {
								throw new ExportException(e);
							} catch (IOException e) {
								throw new ExportException(e);
							}

							AudioInputStream pickedChannelStream;
							try {
								pickedChannelStream = chSel
								.getAudioInputStream(pcmOrgStream);
							} catch (AudioPluginException e) {
								e.printStackTrace();
								if(pcmOrgStream!=null){
									try {
										pcmOrgStream.close();
									} catch (IOException e1) {
										// already throwing an exception 
									}
								}
								throw new ExportException(e);
							}
							try {
								ThreadSafeAudioSystem.write(pickedChannelStream,
										pcmAudioFileFormatType, pickedChannelFile);
							} catch (Exception e) {
								if(pickedChannelStream!=null){
									try {
										pickedChannelStream.close();
									} catch (IOException ioe) {
										// we throw the first exception 
									}
								}
								throw new ExportException(e);
							}
							if(pickedChannelStream!=null){
								try {
									pickedChannelStream.close();
								} catch (IOException e) {
									throw new ExportException(e);
								}
							}
							emuRecFiles[pChannelCnt++]=pickedChannelFile;

						}

					}

			}catch(ExportException e){
				throw e;
			}finally{
				if(tempPcmConvertedFile!=null){
					tempPcmConvertedFile.delete();
				}
			}
			if(emuRecFiles!=null && emuRecFiles.length>0) {
				File testFile=emuRecFiles[0];
				if(!testFile.exists()) {
					System.out.println("Error: EMU recfile "+testFile+" dows not exist");
				}else {
					try {
						// build _annot.json file
						Bundle b=autoAnnotationManager.buildBundle(dbConfig,emuBundleName, emuRecFiles);

						paa.open();
						String prmptTxt="";
						if(r!=null) {
							prmptTxt=r.getDescription();
						}
						paa.setPromptText(prmptTxt);
						paa.setAnnotationRequest(new AnnotationRequest(b));
						paa.call();
						paa.close();

						taa.open();
						String templText=null;
						if(r!=null) {
							LocalizedText lt=r.annotationTemplateLocalizedText();
							if(lt!=null){
								templText=lt.getText();
							}
						}
						taa.setTemplateText(templText);
						taa.setAnnotationRequest(new AnnotationRequest(b));
						AutoAnnotation taan=taa.call();
						taa.close();


						if(link){
							List<Level> bLvls=b.getLevels();
							Item prtIt=null;
							for(Level bLvl:bLvls){
								if(PromptAutoAnnotator.PREDEFINED_LEVEL_DEFINITION.getKeyName().equals(bLvl.getName())){
									List<Item> its=bLvl.getItems();
									if(its.size()==1){
										prtIt=its.get(0);
									}
								}
							}
							Item tplIt=null;
							for(Level bLvl:bLvls){
								if(TemplateAutoAnnotator.PREDEFINED_LEVEL_DEFINITION.getKeyName().equals(bLvl.getName())){
									List<Item> its=bLvl.getItems();
									if(its.size()==1){
										tplIt=its.get(0);
									}
								}
							}

							// Link prompt to template item if both exist
							if(prtIt!=null & tplIt!=null){
								Link ln=new Link();
								ln.setFrom(prtIt);
								ln.setTo(tplIt);
								b.getLinksAsSet().add(ln);
							}
						}

						Path emuAnnotFile=emuDbBndlDir.resolve(emuBundleName+"_annot.json");
						bPers.setFile(emuAnnotFile.toFile());
						bPers.write(b);

					}catch(Exception e) {
						throw new ExportException(e);
					}
				}
			}
		}
	}



	public ipsk.audio.capture.session.info.RecordingFile getRecordingFileInfo() {
		return recordingFileInfo;
	}

	public RecordingFileExportConfiguration getConfiguration() {
		return configuration;
	}



	public void setConfiguration(RecordingFileExportConfiguration configuration) {
		this.configuration = configuration;
		pcmAudioFileFormatType = configuration.getPcmAudioFileFormatType();
		channelNumberFormatter = new DecimalFormat(configuration
				.getChannelNumberFormat());
		pcmDotExtension = "." + pcmAudioFileFormatType.getExtension();
	}




	public Path getOutputDir() {
		return outputDir;
	}



	public void setOutputDir(Path outputSessionDir) {
		this.outputDir = outputSessionDir;
	}

	public int getRecordingFileId() {
		return recordingFileId;
	}

	public void setRecordingFileId(int recordingFileId) {
		this.recordingFileId = recordingFileId;
	}



}
