package ipsk.webapps.db.servlets;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProjectDispatchServlet extends HttpServlet {

	public ProjectDispatchServlet() {
		super();
	}

	protected void doGet(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		String user = req.getRemoteUser();
		log("Project dispatch servlet (GET) started for user " + user + "...");
		
		String servletPath=req.getServletPath();
		String pathInfo=req.getPathInfo();
		
		String projectName=pathInfo.replaceAll("^/","").replaceAll("/.*$","");
		String projectPathInfo=pathInfo.replaceAll("^/[^/]*","");
		
		if(projectPathInfo.startsWith("/"+FileServer.RESOURCES_DIR)){
			// dispatch (script media) resource
			//TODO !!
			// check project resources first
			
			// and then global application resources
			RequestDispatcher rd=req.getRequestDispatcher(projectPathInfo);
			rd.forward(req, res);
		}else if(projectPathInfo.equals("/WebrecorderPrj.jsp")){
			// Forward to project configuration JSP file
			RequestDispatcher rd=req.getRequestDispatcher("/session/WebrecorderPrj.jsp");
			rd.forward(req, res);
		}else if(projectPathInfo.equals("/SpeechRecPrompts_3.dtd")){
			// Forward to DTD file
			RequestDispatcher rd=req.getRequestDispatcher("/session/SpeechRecPrompts_3.dtd");
			rd.forward(req, res);
		}
		
		
		
	}

	
}
