package ipsk.webapps.db.speech;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

import ipsk.db.speech.UserRoleId;
import ipsk.io.StreamCopy;
import ipsk.jsp.Controller;
import ipsk.text.StringTokenizer;
import ipsk.text.quoting.QuoteParser;
import ipsk.text.quoting.TextPart;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.ProcessResult.Type;
import ipsk.webapps.db.servlets.FileServer;



@WebListener
public class FilesystemController {
	public final static boolean DEBUG=true;
	private static volatile Charset cs;
	private static String CS_NAME="UTF-8";
	private File baseDir=null;
	public File getBaseDir() {
		return baseDir;
	}

	public void setBaseDir(File baseDir) {
		this.baseDir = baseDir;
	}

	
	private boolean upDirPossible=false;
	
	public boolean isUpDirPossible() {
		return upDirPossible;
	}

	public void setUpDirPossible(boolean upDirPossible) {
		this.upDirPossible = upDirPossible;
	}
	
	private String currentDirPath;
	

	public String getCurrentPath() {
		return currentDirPath;
	}

	public void setCurrentPath(String currentPath) {
		this.currentDirPath = currentPath;
	}

	private File[] files=null;
	
	public File[] getFiles() {
		return files;
	}

	public void setFiles(File[] files) {
		this.files = files;
	}

	private ProcessResult processResult;
	
	public ProcessResult getProcessResult() {
		return processResult;
	}

	public FilesystemController() {
		super();
		cs=Charset.forName(CS_NAME);
	}

	

	private Path securePath(String path) throws PermissionDeniedException{
		Path insecurePath=Paths.get(path);
		return securePath(insecurePath);
	}
	private Path securePath(Path insecurePath) throws PermissionDeniedException{
		// allow only relative pathes ...
		if(insecurePath.isAbsolute()){
			throw new PermissionDeniedException();
		}
		Path insecureNormPath=insecurePath.normalize();
		// ... which are normalized
		
		// However we double check, that there are no path elements to parent directories 
		int pLen=insecureNormPath.getNameCount();
		for(int i=0;i<pLen;i++){
			Path pNm=insecureNormPath.getName(i);
			if(pNm.startsWith("..")){
				throw new PermissionDeniedException();
			}	
		}
		return insecureNormPath;
	}
	
	private boolean isRoot(Path path){
		int nmCnt=path.getNameCount();
		boolean emptyPath=false;
		if(nmCnt==1){
			Path p=path.getName(0);
			String pNm=p.toString();
			emptyPath="".equals(pNm);
			
		}
		boolean isRoot=(nmCnt<1) || emptyPath;
		return isRoot;
	}
	
	
	public void processRequest(HttpServletRequest req) throws ControllerException {
		if(req.isUserInRole(UserRoleId.RoleName.ADMIN.name())){
			
			
				String[] path=req.getParameterValues("_path");
				Path securePath=null;
				if(path!=null && path.length==1){
					
					securePath=securePath(path[0]);
				}else{
					securePath=securePath("");
				}
				if(securePath!=null){
					Path reqPath=baseDir.toPath().resolve(securePath);
					setFiles(reqPath.toFile().listFiles());
					
					setUpDirPossible(!isRoot(securePath));
					setCurrentPath(securePath.toString());
					processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
				}
			
		}else{
			throw new PermissionDeniedException();
		}

	}

	

}
