package ipsk.webapps.db.speech;

import ipsk.db.speech.Account;
import ipsk.db.speech.Message;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.script.Script;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.db.speech.ws.ProjectScriptResource.OrderDirection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;

public class MessageController extends BasicWikiSpeechController<Message> {

	public static final String CMD_MSG_SELECT="msg_select"; 
	private Message message;
	
	private List<Account> allowedRecipients=new ArrayList<Account>();

//	public Message getSelectedMessage() {
//		return (Message)getSelectedItem();
//	}



	public MessageController() {
		super("WebSpeechDBPU",Message.class, "message");

		securityManager=new WikiSpeechSecurityManager(this);
	}

	
	
	public Message getMessageById(int id) {
		EntityManager em = getThreadEntityManager();
		message = em.find(Message.class, id);
		return message;
	}

//	public void merge(Message o) {
//		super.merge(o);
//	}
//
//	public void persist(Message o) {
//		super.persist(o);
//	}

	public void deleteMessage(int id) {
		System.out.println("Deleting message...");
		EntityManager em = getEntityManager();
		try {
			em.getTransaction().begin();
			Message o = em.find(Message.class, id);
			em.remove(o);
			em.getTransaction().commit();
		} catch (Exception e) {
			e.printStackTrace();
			em.getTransaction().rollback();
		} finally {

			em.close();
		}
		// super.delete(Message.class,id);
	}

	@SuppressWarnings("unchecked")
	public List<ipsk.db.speech.Message> getMessages() {
		EntityManager em = getEntityManager();
		List<ipsk.db.speech.Message> list = null;
		try {
			em.getTransaction().begin();
			Query q = em.createQuery("select object(o) from Message as o");
			q.setMaxResults(batchSize);
			q.setFirstResult(firstItem);
			list = q.getResultList();
			em.getTransaction().commit();
		} catch (Exception e) {
			e.printStackTrace();
			em.getTransaction().rollback();
			em.close();
		}

		return list;
	}

	

	public void newMessage() {
		this.message = new Message();

	}
	
	protected void setPropertiesAfterSelect(HttpServletRequest request, Object selObjectId) {
	
		
		if(selObjectId!=null){
			EntityManager em=getThreadEntityManager();
			//EntityTransaction tx=null;
			try{
			//tx=em.getTransaction();
			
			//tx.begin();
		
			Message message = em.find(Message.class,selObjectId);

			String currState = message.getStatus();
			if (currState != null && currState.equals(Message.SENT)){
				message.setStatus(Message.READ);
				message.setDateRead(new Date());
				em.merge(message);
			}
			
			//tx.commit();
			}catch(Exception e){
				e.printStackTrace();
				//if (tx!=null && tx.isActive())tx.rollback();
			}
		}
	}
	
//	public void markAsRead(Message m) {
//		EntityManager em = getThreadEntityManager();
//		EntityTransaction tx=null;
//		tx=em.getTransaction();
//		tx.begin();
//		message = em.find(Message.class, m.getMessageId());
//
//		String currState = message.getStatus();
//		if (currState != null && currState.equals(Message.SENT)){
//			message.setStatus(Message.READ);
//			message.setDateRead(new Date());
//			em.merge(message);
//		}
//		
//		tx.commit();
//		
//	}
	
	public List<Account> getAllowedRecipients() {
		return allowedRecipients;
	}

	@SuppressWarnings("unchecked")
	public List<Account> getAllowedRecipients(HttpServletRequest req) {

		EntityManager em = getThreadEntityManager();
		Account acc = getAccountByRequest(req);
		
		// ordered set (no duplicate entries)
		LinkedHashSet<Account> lhs = new LinkedHashSet<Account>();

		if (req.isUserInRole(UserRoleId.RoleName.ADMIN.name())) {
			Query q = em.createQuery("SELECT a FROM Account AS a");
			lhs.addAll(q.getResultList());
		} else {
			
			if (acc != null) {
				// add project admins to project admin
				Set<Project> admProjs=acc.getAdminOfProjects();
				for(Project admProj:admProjs){
					// other admins of project
					lhs.addAll(admProj.getAdminAccounts());
				}
				
				// add project accounts to project admin
				
				for(Project admProj:admProjs){
					// accunts of adminitsrated project
					lhs.addAll(admProj.getAccounts());
				}
				
				

				for(Project admProj:admProjs){
					// organisation participants of administered project
					Set<Organisation>admOrgas=admProj.getOrganisations();
					for(Organisation admOrga:admOrgas){
						lhs.addAll(admOrga.getAccounts());
					}
				}

				// add organisation related recipients
				Organisation orga = acc.getOrganisation();
				if (orga != null) {
					// add all accounts of same organisation
					lhs.addAll(orga.getAccounts());
					Set<Project> projs = orga.getProjects();
					Project selProj = getSelectedProject(req);
					if (selProj != null && projs.contains(selProj)) {
						// add all of organisation of selected project
						Set<Organisation> orgas = selProj.getOrganisations();
						if (orgas != null) {
							for (Organisation org : orgas) {
								lhs.addAll(org.getAccounts());
							}
						}
					}

					// finally add all of projects
					for(Project pr:projs){
						Set<Organisation> orgs=pr.getOrganisations();
						for(Organisation org:orgs){
							lhs.addAll(org.getAccounts());
						}
					}
				}

				// add account related project admins 
				Set<Project> assPrjs=acc.associatedProjects();
				for(Project assPrj:assPrjs){
					lhs.addAll(assPrj.getAdminAccounts());
				}
			}
			// Last in te list: add all admin accounts
			Query q = em.createQuery("SELECT a FROM Account a WHERE EXISTS (SELECT ur FROM UserRole ur WHERE ur.account = a AND ur.id.roleName = :adminRolename )");
			q.setParameter("adminRolename", UserRoleId.RoleName.ADMIN);
			lhs.addAll(q.getResultList());

			
		}
		if(acc!=null){
			// Remove self
			lhs.remove(acc);
		}
		allowedRecipients = new LinkedList<Account>(lhs);
		return allowedRecipients;

	}
	public List<Message> getUnreadMessages(String to){
	    return getMessagesByToWithState(to, Message.SENT);
	}
	public List<Message> getUnreadMessages(){
		return getUnreadMessages(currentRequest);
	}
	public List<Message> getUnreadMessages(HttpServletRequest req){
		if(req!=null)currentRequest=req;
		Account acc=getAccountByRequest(req);
		if(acc==null)return null;
		return getMessagesByToWithState(acc.getLogin(), Message.SENT);
	}

	@SuppressWarnings("unchecked")
	public List<Message> getMessagesByToOrderedByDescendingDateSent(String to) {

		EntityManager em = getThreadEntityManager();
		EntityTransaction tx=null;
		List<ipsk.db.speech.Message> list = null;
		try {
			tx=em.getTransaction();
			tx.begin();
			// TODO does not compare case insensitive
//			Query q = em
//					.createQuery("SELECT m FROM Message AS m WHERE m.accountByToLogin.login = :to ORDER BY m.dateSent DESC");
//			q.setParameter("to", to);
//			
			String toLc=to.toLowerCase(Locale.US);
			
			CriteriaBuilder cb = em.getCriteriaBuilder();
			CriteriaQuery<Message> cq = cb.createQuery(Message.class);
			Root<Message> rt = cq.from(Message.class);
			cq.select(rt);
			
			 Path<Account> toLoginPath = rt.<Account>get("accountByToLogin");
			 Path<String> toLoginNmPath=toLoginPath.<String>get("login");
			Expression<String> toLoginLc=cb.lower(toLoginNmPath);
			Predicate loginEqualsCaseInsensitive=cb.equal(toLoginLc, toLc);
			cq.where(loginEqualsCaseInsensitive);
			
			Order order=cb.desc(rt.<Date>get("dateSent"));
			cq.orderBy(order);
			
			//list = q.getResultList();
			TypedQuery<Message> tq = em.createQuery(cq);
			list = tq.getResultList();
			tx.commit();
		} catch (Exception e) {
			e.printStackTrace();
			if(tx!=null && tx.isActive())tx.rollback();
			em.close();
		}

		return list;

	}


	@SuppressWarnings("unchecked")
	public List<Message> getMessagesByToWithState(String to, String state) {
		EntityManager em = getThreadEntityManager();
		
		List<ipsk.db.speech.Message> list = null;
		try {
			
			Query q = em
					.createQuery("SELECT m FROM Message AS m WHERE LOWER(m.accountByToLogin.login) = :toLc AND m.status = :state ORDER BY m.dateSent");
			q.setParameter("toLc", to.toLowerCase(Locale.US));
			q.setParameter("state", state);
			list = q.getResultList();
			
		} catch (Exception e) {
			e.printStackTrace();
			
			close();
		}

		return list;

	}

	public Object getEditObject() {
		return message;
	}

	public Message getMessage() {
		return message;
	}

	public void setMessage(Message message) {
		this.message = message;
	}
	
	@SuppressWarnings("unchecked")
	private void initializeSelection(HttpServletRequest request){
		
		Object selectedId = getSelectedItemId();
		
		
		String user = request.getRemoteUser();
		// TODO Do we need the principal name here (case sensitivity)?
		if (user != null) {

			EntityManager em = getThreadEntityManager();
			//EntityTransaction tx = null;
			List<ipsk.db.speech.Message> list = null;
			try {
				//tx = em.getTransaction();
				//tx.begin();
				Message selMsg=null;
				if(selectedId!=null){
					selMsg=em.find(Message.class,selectedId);
				}
				if(selectedId==null || (selMsg!=null && selMsg.getStatus() != Message.SENT)){
					// if no message is selected or if the message selected is not new try to find a new message
				Query q = em
						.createQuery("select m from Message as m where lower(m.accountByToLogin.login) = :toLc and m.status = :state ORDER BY m.dateSent DESC");
				q.setParameter("toLc", user.toLowerCase(Locale.US));
				q.setParameter("state", Message.SENT);
				list = q.getResultList();
				if (list.size() > 0) {
					Message m = list.get(0);
					// New message found: set or override selection
					selectedId=m.getMessageId();
				}
				}
				//tx.commit();
			} catch (Exception e) {
				e.printStackTrace();
//				if (tx != null && tx.isActive())
//					tx.rollback();
				em.close();
			}
			
			setSelectedItemId(request, selectedId);
			
		}
	}
	
	
	
	public void processRequest(HttpServletRequest req) throws ControllerException{
		getAllowedRecipients(req);
		super.processRequest(req);
	}
	
	public void processListRequest(HttpServletRequest req) throws ControllerException{
		getAllowedRecipients(req);
		initializeSelection(req);
//		String cmd=req.getParameter("cmd");
//		if ("add".equals(cmd) || req.getParameter("_add") != null){
//			throw new ControllerException("test only !!!");
//		}
		super.processListRequest(req);
	}
	
}
