package ipsk.webapps.db.speech;

import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import ipsk.audio.FileAudioSource;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.dsp.AudioClipDSPInfo;
import ipsk.audio.dsp.AudioClipProcessor;
import ipsk.audio.io.KnownLengthAudioInputStream;
import ipsk.beans.BeanModel;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.RecordingTrack;
import ipsk.db.speech.Session;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
//import ipsk.webapps.audio.AudioSystemWrapper;
import ipsk.webapps.ProcessResult;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class RecordingFileController extends BasicPersistenceBeanController<RecordingFile> {
	public static String DEF_SESSION_ID_FORMAT="0000";
	public static String DEF_RECVERSION_FORMAT="_00";
	private RecordingFile recordingFile;
	public static DecimalFormat sessionIDFormat=new DecimalFormat(DEF_SESSION_ID_FORMAT);
	public static DecimalFormat recversionFormatter=new DecimalFormat(DEF_RECVERSION_FORMAT);
	
	public RecordingFileController() {
		super("WebSpeechDBPU",RecordingFile.class, "recordingFile");
		securityManager=new WikiSpeechSecurityManager(this);
	}
	
	protected void setPropertiesOnNew(Object bean) {
		super.setPropertiesOnNew(bean);
		if(bean instanceof RecordingFile) {
			RecordingFile rf=(RecordingFile)bean;
			rf.setUuid(UUID.randomUUID().toString());
		}
	}


	
	public RecordingFile getById(HttpServletRequest req,int id) throws ControllerException{
		EntityManager em = getThreadEntityManager();
		
		recordingFile = em.find(RecordingFile.class, id);
		em.refresh(recordingFile);
		securityManager.checkReadPermission(req, recordingFile);
		return recordingFile;
	}
	
	
	
//	private String createSignalFilePath(String sessionPath,String speakerCode,String itemCode,String extension,int sessionId,int version,boolean overwrite){
//		String speakerCodeStr="";
//		if(speakerCode!=null){
//			speakerCodeStr=speakerCode;
//		}
//		String session=sessionIDFormat.format(sessionId);
//		String versionStr="";
//		if(!overwrite){
//			versionStr=recversionFormatter.format(version);
//		}
//		
//		return sessionPath+"/"+speakerCodeStr+session+itemCode+versionStr+"."+extension;
//	}
//	
//	private String createSignalFilePath(String sessionPath,String speakerCode,String itemCode,String extension,RecordingFile rf,boolean overwrite){
////		String session=sessionIDFormat.format(rf.getSession().getSessionId());
////		String versionStr="";
////		if(!overwrite){
////			versionStr=recversionFormatter.format(rf.getVersion());
////		}
////		return session+"/"+speakerCode+session+itemCode+versionStr+"."+extension;
//		return createSignalFilePath(sessionPath, speakerCode, itemCode, extension, rf.getSession().getSessionId(), rf.getVersion(), overwrite);
//	}
	
	
	
//	@SuppressWarnings("unchecked")
//	public RecordingFile storeRecordingFileForSession(String recsDir, String speakerCode, RecordingFile recFile,AudioFileFormat aff, String itemCode,int sessionId, boolean overwrite){
//		EntityManager em = getThreadEntityManager();
//
//		// get active instance
//		Session sess=em.find(Session.class, sessionId);
//		String sessionDir=sess.getStorageDirectoryURL();
//		if(sessionDir==null){
//			sessionDir=SessionController.createSessionFilePath(recsDir, sess.getSessionId());
//			sess.setStorageDirectoryURL(sessionDir);
//		}
//		Script recScript=sess.getScript();
//		if(recScript==null){
//			throw new PersistenceException("Session has no associated script !");
//		}
//		Query q = em.createQuery("SELECT r FROM Recording AS r WHERE r.section.script = :recScript AND r.itemcode = :itemcode");
//		q.setParameter("recScript", recScript);
//		q.setParameter("itemcode",itemCode);
//		Recording recording=(Recording)q.getSingleResult();
////		Recording recording=null;
////		List<Recording> recordingList=q.getResultList();
////		if(recordingList.size()==0){
////
////		}else if(recordingList.size()>1){
////			// TODO where can we send a warning  
////			recording=recordingList.get(0);
////		}else{
////			recording=recordingList.get(0);
////		}
//			recFile.setSession(sess);
//
//			//recFile.setVersion(overwrite);
//			recFile.setRecording(recording);
//			recFile.setDate(new Date());
//			String extension="unknown";
//			if(aff!=null){
//				AudioFormat af = aff.getFormat();
//				AudioFileFormat.Type affType=aff.getType();
//				extension=affType.getExtension();
//				recFile.setFormat(affType.toString());
//				// TODO long method versions in JDK 1.5 ?
//				recFile.setBytes((long) aff.getByteLength());
//				recFile.setFrames((long) aff.getFrameLength());
//				recFile.setEncoding(af.getEncoding().toString());
//
//				recFile.setChannels(af.getChannels());
//				recFile.setQuantisation(af.getSampleSizeInBits());
//				recFile.setSamplerate(new Double(af.getSampleRate()));
//				recFile.setBigendian(af.isBigEndian());
//			}
//			
//			List<RecordingFile> rfs=null;
//			if(recording !=null){
//				q = em.createQuery("SELECT rF FROM RecordingFile AS rf,Recording AS r WHERE r = :recording AND rf MEMBER OF r.recordingFiles AND rf.session = :session");
//				q.setParameter("recording", recording);
//				q.setParameter("session",sess);
//				rfs=(List<RecordingFile>)(q.getResultList());
//			}
//			//String signalFile=null;
//			if (overwrite){
//				// overwrite
//				if(rfs==null || rfs.size() ==0){
//					recFile.setSignalFile(createSignalFilePath(sessionDir, speakerCode, itemCode, extension,recFile,overwrite));
//					em.persist(recFile);
//					recFile.setSession(sess);
//					sess.getRecordingFiles().add(recFile);
//				}else{
//					// Hmm. Not really correct.
//					RecordingFile rf=(RecordingFile)rfs.get(0);
//					Integer version=rf.getVersion();
//					if(version!=null){
//						recFile.setVersion(version++);
//					}else{
//						recFile.setVersion(0);
//					}
//					recFile.setRecordingFileId(rf.getRecordingFileId());
//
//					recFile.setSignalFile(createSignalFilePath(sessionDir, speakerCode, itemCode, extension,recFile,overwrite));
//					// overwrite by merge
//					em.merge(recFile);
//				}
//			}else{
//				int version=0;
//				if(rfs!=null){
//					for(RecordingFile rf:rfs){
//						Integer sVersion=rf.getVersion();
//						if(sVersion!=null){
//							if (sVersion>=version)version=sVersion+1;
//						}
//					}
//				}
//				recFile.setVersion(version);
//				recFile.setSignalFile(createSignalFilePath(sessionDir, speakerCode, itemCode, extension,recFile,overwrite));
//				em.persist(recFile);
//				recFile.setSession(sess);
//				sess.getRecordingFiles().add(recFile);
//			}
//		
//		return recFile;
//	}



	public void removeById(int id) {
		
		EntityManager em = getEntityManager();
		try {
			em.getTransaction().begin();
			RecordingFile o = em.find(RecordingFile.class, id);
			em.remove(o);
			em.getTransaction().commit();
		} catch (Exception e) {
			e.printStackTrace();
			em.getTransaction().rollback();
		} finally {

			em.close();
		}
		//super.delete(Organisation.class,id);
	}
	
	@Override
	protected void beforeDelete(HttpServletRequest request, Object objToDelete) {
		if(objToDelete instanceof RecordingFile) {
			RecordingFile rf=(RecordingFile)objToDelete;
			Session sess=rf.getSession();
			if(sess!=null) {
				SessionController.invalidateCachedValues(request.getServletContext(), sess.getSessionId());
			}
		}
		super.beforeDelete(request, objToDelete);
	} 

	@SuppressWarnings("unchecked")
	public List<ipsk.db.speech.RecordingFile> getRecordingFiles() {
		EntityManager em = getThreadEntityManager();
		//EntityTransaction tx=null;
		List<ipsk.db.speech.RecordingFile> list=null;
		try {
			
//			tx=em.getTransaction();
//			tx.begin();
		Query q = em.createQuery("select object(o) from RecordingFile as o");
		q.setMaxResults(batchSize);
		q.setFirstResult(firstItem);
		list = q.getResultList();
		//tx.commit();
		} catch (PersistenceException e) {
			e.printStackTrace();
//			if(tx!=null && tx.isActive())tx.rollback();
			throw e;
		} 
		
		return list;
	}

	
	
	public void newRecordingFile() {
		this.recordingFile = new RecordingFile();

	}
	
	
	

//	public void processRequest(HttpServletRequest request) throws ControllerException {
//		if (request.getCharacterEncoding() == null) {
//			try {
//				//System.out.println("Set encoding to UTF 8");
//				request.setCharacterEncoding("UTF-8");
//			} catch (UnsupportedEncodingException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//		}
//		String command = request.getParameter("_cmd");
//		System.out.println("Cmd: " + command);
//		if (command != null && request.getParameter("_cancel") == null) {
//			if (command.equals("store") || command.equals("add")) {
//				
//				Map map = request.getParameterMap();
//				MapConverter mapConverter = new MapConverter();
//				if (command.equals("add")){
//					newRecordingFile();
//				}
//				
//				
//				try {
//					mapConverter.setBeanProperties(recordingFile, map);
//				
//				} catch (MapConverterException e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
//				if (command.equals("add")){
//					//if(validate()){
//					persist(recordingFile);
//					//}
//					
//				}else{
//					merge(recordingFile);
//					
//				}
//				
//				
//			}else if (command.equals("edit")){
//				int id=Integer.parseInt(request.getParameter("id"));
//				getById(id);
//			}else {
//				super.processRequest(request);
//			}
//		} else {
//			super.processRequest(request);
//		}
//	}

	public Object getEditObject() {
		return recordingFile;
	}

	public RecordingFile getRecordingFile() {
		return recordingFile;
	}

	public void setRecordingFile(RecordingFile recordingFile) {
		this.recordingFile=recordingFile;
	}
	

	@SuppressWarnings("unchecked")
	public boolean processDSPInfoForAll(ServletContext servletContext, int maxCount) throws ControllerException{
		EntityManager em=getThreadEntityManager();
		List<ipsk.db.speech.RecordingFile> list=null;

		//Query q = em.createQuery("SELECT rF FROM RecordingFile AS rf WHERE rf.maxLevel IS NULL OR rf.frames IS NULL");
		Query q = em.createQuery("SELECT rF FROM RecordingFile AS rf WHERE rf.status = :recordedStatus");
		q.setParameter("recordedStatus",RecordingFile.Status.RECORDED);
		q.setMaxResults(maxCount+1);
		list = q.getResultList();
		int c=0;
		for (RecordingFile rf:list){
			
				processDSPInfo(servletContext,rf, true);
				
				c++;
				if(c>maxCount)break;
		}
		if(list.size()>maxCount)return true;
		return false;
	}




	public void processDSPInfo(ServletContext servletContext,RecordingFile rf, boolean overwrite) throws ControllerException{

		if (rf!=null && (overwrite || rf.getMaxLevel()==null || rf.getFrames()==null || rf.getRecordingTracks().size()==0)){
			try{
				URL audioFileURL;
				try {
					audioFileURL = new URL(rf.getSignalFile());
				} catch (MalformedURLException e) {
					rf.setMaxLevel(null);
					e.printStackTrace();
					throw new ControllerException(e);
				}
				if(!audioFileURL.getProtocol().equalsIgnoreCase("file")){
					rf.setMaxLevel(null);		
					throw new ControllerException("Only file URL's are supported!");
				}
				File decodedAudioFile=null;
				AudioInputStream srcStream=null;
				AudioInputStream decAis=null;
				try {
					// I cannot use the Convenience source directly here, because it does not use the AudioSystemWrapper

					//				ConvenienceFileAudioSource fas = new ConvenienceFileAudioSource(new File(audioFileURL.getPath()));

					File audioFile=new File(audioFileURL.getPath());


//					srcStream = AudioSystemWrapper.getAudioInputStream(audioFile);
					srcStream = ThreadSafeAudioSystem.getAudioInputStream(audioFile);
					AudioFormat af=srcStream.getFormat();
					AudioFormat.Encoding afEnc=af.getEncoding();
					if(AudioFormat.Encoding.PCM_FLOAT.equals(afEnc)) {
						
						decAis=AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_FLOAT, srcStream);
					}else {
						decAis=AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, srcStream);
					}
					decodedAudioFile=File.createTempFile(getClass().getName(), ".wav");
					decodedAudioFile.deleteOnExit();
					AudioSystem.write(decAis,AudioFileFormat.Type.WAVE,decodedAudioFile);
				}catch (UnsupportedAudioFileException e) {
					e.printStackTrace();
					throw new ControllerException(e);
				} catch (IOException e) {
					e.printStackTrace();
					throw new ControllerException(e);
				}finally{


					try {
						if(decAis!=null)decAis.close();
						if(srcStream!=null)srcStream.close();
					} catch (IOException e) {
						e.printStackTrace();
						throw new ControllerException(e);
					}
				}
				try{
					ConvenienceFileAudioSource fas=new ConvenienceFileAudioSource(decodedAudioFile);

					long frameLength=fas.getFrameLength();
					if(frameLength==AudioSystem.NOT_SPECIFIED){
						rf.setFrames(null);
					}else{
						rf.setFrames(frameLength);
					}
					if (frameLength>0){
						AudioClip audioClip=new AudioClip(fas);
						AudioClipProcessor acp=new AudioClipProcessor(audioClip);
						acp.setCalculateSBNR(true);
						AudioClipDSPInfo dspInfo=acp.process();
						int channels=dspInfo.getAudioFormat().getChannels();
						double[] maxPeakLevels=dspInfo.getNormalizedMaxPeakLevels();
						Double[] snrs=dspInfo.getEstimatedSignalToBackgroundNoiseRatio();
						Set<RecordingTrack> tracks=rf.getRecordingTracks();
						if(tracks!=null && tracks.size()>0){
							if(tracks.size()!=channels){

								throw new ControllerException("Recording file "+rf+" channel count does not match track count!!");
							}
						}else{
							EntityManager em=getThreadEntityManager();
							// create RecordingTrack objects and persist them
							HashSet<RecordingTrack> newTracks=new HashSet<RecordingTrack>();
							em.merge(rf);
							for(int ch=0;ch<channels;ch++){
								RecordingTrack newTrack=new RecordingTrack();
								newTrack.setRecordingFile(rf);
								newTrack.setChannelIndex(ch);
								em.persist(newTrack);	
								newTracks.add(newTrack);
							}
							rf.setRecordingTracks(newTracks);
							tracks=rf.getRecordingTracks();
						}
						for(RecordingTrack rt:tracks){
							int chIndex=rt.getChannelIndex();
							if(maxPeakLevels!=null){
								rt.setMaxLevel(maxPeakLevels[chIndex]);
							}
							if(snrs!=null && snrs[chIndex]!=null){
								rt.setEstimatedSNR(snrs[chIndex]);
							}
						}
						double maxLevelAll=dspInfo.getNormalizedMaxPeakLevelOfAllChannels();
						Double maxLevel=rf.getMaxLevel();
						if(maxLevel==null){
							rf.setMaxLevel(maxLevelAll);
						}else{
							if(maxLevel!=maxLevelAll){
								if(servletContext!=null)servletContext.log("Warning: max peak level all differ: "+maxLevel+" "+maxLevelAll+"\nOverwriting max peak level for "+rf+" !");
								rf.setMaxLevel(maxLevelAll);
							}
						}
					}
					rf.setStatus(RecordingFile.Status.PROCESSED);
					if(servletContext!=null)servletContext.log("Recorded file "+rf+" DSP processed.");
				} catch (AudioSourceException e1) {	
					e1.printStackTrace();
					rf.setFrames(null);
					rf.setMaxLevel(null);
					throw new ControllerException(e1);
				}finally{
					if(decodedAudioFile!=null){
						decodedAudioFile.delete();
					}
				}
			}catch(ControllerException ce){
				rf.setStatus(RecordingFile.Status.PROCESS_ERROR);
				throw ce;
			}
		}
	}
	
	
	/**
	 * Deletes recording file database entry and corresponding file.
	 *
	 * @return true if file could be deleted false if file remains.
	 * @throws ControllerException 
	 */
	public boolean deleteRecordingFile(HttpServletRequest request,RecordingFile rf) throws ControllerException{
		EntityManager em=getThreadEntityManager();
		boolean deletedFile=false;
		
		securityManager.checkRemovePermission(request, rf);
		
		String fileURLStr=rf.getSignalFile();
		URL fileURL=null;
		try {
			fileURL = new URL(fileURLStr);
			if(fileURL.getProtocol().equalsIgnoreCase("file")){
				File recFile=new File(fileURL.getFile());
				deletedFile=recFile.delete();
			}
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}

		// Necessary ? (Recording track will be cascade removed)
		//deleteRelated(request, rf);
		
		em.remove(rf);

		// Invalidate session DSP values and completeness value
		Session rfSess=rf.getSession();
		SessionController.invalidateCachedValues(request.getServletContext(), rfSess.getSessionId());
			
		return deletedFile;
	}
	
	/**
	 * Deletes recording file database entry and corresponding file.
	 *
	 * @return true if file could be deleted false if file remains.
	 * @throws ControllerException 
	 */
	public boolean deleteRecordingFile(HttpServletRequest request) throws ControllerException{
		clear();
		String command=processCommand(request);
		createBeanModel(request);
		EntityManager em=getThreadEntityManager();
		
		RecordingFile rf =(RecordingFile)getBeanModel().getBean();
		beanModel=new BeanModel<RecordingFile>(rf);
		
		boolean deletedFile=false;
		if(CMD_DELETE.equals(command)){
			deleteRecordingFile(request, rf);
			processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
		}else if(CMD_CANCEL.equals(command)){
			processResult=new ProcessResult(ProcessResult.Type.CANCELLED);
		}
		return deletedFile;
	}
	
	
}
