package ipsk.webapps.db.speech;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;

import ipsk.beans.MapConverter;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.PropertyValidationResult.Type;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Account;
import ipsk.db.speech.DialectRegion;
import ipsk.db.speech.FormConfiguration;
import ipsk.db.speech.InformedConsent;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.project.LocalizedDefaultPurposeText;
import ipsk.jsp.BeanTableModel;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.persistence.OrderBy;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.QueryParam;
import ipsk.sql.OrderByClause;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.ControllerException;
import ipsk.webapps.db.speech.validation.NotSingleSessionPropertyValidationError;

public class SpeakerController extends BasicWikiSpeechController<Speaker> {

	// TODO make configurable
	//public final static String SPEAKER_CODE = "VO";
	public final static String SINE_TEST_SPEAKER_CODE="SINE-TEST";

	
	private Speaker speaker;

	//private Vector fieldsToCorrect = new Vector();
	
	
	private boolean formConfigurationFromProject=false;
	

	public boolean isFormConfigurationFromProject() {
		return formConfigurationFromProject;
	}


	public void setFormConfigurationFromProject(boolean formConfigurationFromProject) {
		this.formConfigurationFromProject = formConfigurationFromProject;
		
		
	}


	public SpeakerController() {
		super("WebSpeechDBPU", Speaker.class, "speaker");
		OrderByClause defaultOrderByClause=new OrderByClause(new OrderBy[]{new OrderBy("registered",true)});
		setOrderByClause(defaultOrderByClause);
	}
	
//	protected void setPropertiesOnNew(Object bean) {
//		super.setPropertiesOnNew(bean);
//		if(bean instanceof Person) {
//			Person p=(Person)bean;
//			p.setUuid(UUID.randomUUID().toString());
//		}
//	}
//	

	
	public Speaker getById(int id) {
		return (Speaker)super.getById(id);
	}


	public void removeById(int id) {

		EntityManager em = getEntityManager();
		try {
			em.getTransaction().begin();
			Speaker o = em.find(Speaker.class, id);
			em.remove(o);
			em.getTransaction().commit();
		} catch (Exception e) {
			e.printStackTrace();
			em.getTransaction().rollback();
		} finally {

			em.close();
		}
		// super.delete(Organisation.class,id);
	}

	@SuppressWarnings("unchecked")
	public List<ipsk.db.speech.Speaker> getSpeakers() {
		EntityManager em = getThreadEntityManager();
		List<ipsk.db.speech.Speaker> list = null;
		Query q = em.createQuery("select object(o) from Speaker as o");
		q.setMaxResults(batchSize);
		q.setFirstResult(firstItem);
		list = q.getResultList();
		return list;
	}
	
	@SuppressWarnings("unchecked")
	public Speaker getSinusTestSpeakerByLogin(String login,boolean create) {
		EntityManager em = getThreadEntityManager();
		List<ipsk.db.speech.Speaker> list = null;
		Speaker sts=null;

			Account acc=(Account)em.find(Account.class, login);
			Organisation o=acc.getOrganisation();
			
			Query q = em.createQuery("SELECT object(o) FROM Speaker AS o WHERE ? MEMBER OF o.organisations AND o.code='"+SINE_TEST_SPEAKER_CODE+"'");
			q.setParameter(1, o);
			q.setMaxResults(1);
			q.setFirstResult(0);
			list = q.getResultList();
			
			if(list.size()==0){
				if(create){
				sts=new Speaker();
				sts.setCode(SINE_TEST_SPEAKER_CODE);
				
				HashSet<Organisation> orgaList=new HashSet<Organisation>();
				orgaList.add(o);
				sts.setOrganisations(orgaList);
				em.persist(sts);
				}
			}else{
				sts=list.get(0);
			}

		
		return sts;
	}
	public void newSpeaker() {
		this.speaker = new Speaker();

	}
	
	public Organisation getAssociatedOrganisation(){
//		EntityManager em=getThreadEntityManager();
		Account acc=getAccountByRequest(currentRequest);
		return acc.getOrganisation();
	}
	
	public Organisation getAssociatedOrganisation(HttpServletRequest req){
//		EntityManager em=getThreadEntityManager();
		Account acc=getAccountByRequest(req);
		return acc.getOrganisation();
	}
	
	/**
	 * Returns alphabetical ordered list of dialect regions of project. Records marked as alternative are always sorted to the end. 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public List<DialectRegion> getOrderedDialectRegionsForSelectedProject(){
		List<DialectRegion> list=null;
		EntityManager em = getThreadEntityManager();

		Project selectedProject=getSelectedProject();
		
		//Query q = em.createQuery("SELECT dr FROM DialectRegion dr WHERE :selectedProject MEMBER OF dr.projects ORDER BY dr.position");
		Query q = em.createQuery("SELECT dr FROM DialectRegion dr WHERE :selectedProject MEMBER OF dr.projects ORDER BY dr.alternative DESC,dr.name,dr.position");
		q.setParameter("selectedProject", selectedProject);
		list=q.getResultList();
		return list;
	}
	
	
//	private boolean validate() {
//		fieldsToCorrect.clear();
//		if (speaker.getDateOfBirth() == null
//				|| speaker.getDateOfBirth().equals("")) {
//			// fieldsToCorrect.add()
//		}
//		return true;
//	}
	
	
	
//	public ipsk.beans.form.FormConfiguration getFormConfiguration(){
//		if(formConfigurationFromProject){
//			return getProjectSpeakerFormConfiguration();
//		}else{
//			return null;
//		}
//	}
	
	
	public boolean speakerHasInformedConsentForSelectedProject(Speaker spk) {
		Project selPrj=getSelectedProject();
		if(selPrj!=null) {
			Set<InformedConsent> infCnsts=spk.getInformedConsents();
			for(InformedConsent ic:infCnsts) {
				if(selPrj.equals(ic.getProject())) {
					return true;
				}
			}
		}
		return false;
	}
	
	
	public ipsk.beans.form.FormConfiguration getFormConfiguration(){

		FormConfiguration spkFmCfg=null;
		//Project selProj=getSelectedProject();
		
		if(formConfigurationFromProject){
			spkFmCfg=getProjectSpeakerFormConfiguration();
			return spkFmCfg;
			
//			try {
//				SpeakerFormConfigForceInformedConsent spkFrfed=new SpeakerFormConfigForceInformedConsent(spkFmCfg,selProj.isInformedConsentPaperForm());
//				return spkFrfed;
//			} catch (IntrospectionException e) {
//				// should never happen
//				e.printStackTrace();
//				return null;
//			}
		}
		return null;

	}
	
	
	
	
	/**
	 * Set some properties
	 */
	protected void setPropertiesOnCreate(HttpServletRequest request,EntityManager em,Object bean) {
		Speaker speaker=(Speaker)bean;
	
		speaker.setRegistered(new Date());

		// Should be already set by speaker form ...
		Account regAcc=speaker.getRegisteredByAccount();
		if(regAcc==null){
			Account acc=getAccountByRequest(request);
			speaker.setRegisteredByAccount(acc);
		}
	
		String drIdStr=request.getParameter("dialectRegion."+MapConverter.OBJECT_ID);
		if (drIdStr!=null){
			DialectRegion dr=em.find(DialectRegion.class, Integer.parseInt(drIdStr));
			if(dr!=null){
				speaker.setDialectRegion(dr);
			}
		}

	}
	
	
	public void getSpeakersByProjectWithSession(HttpServletRequest req) throws ControllerException{
		
		Project selProject=getSelectedProject(req);
		if(selProject==null){
			createEmptyBeanTableModel(req);
			return;
		}
		ParameterizedQuery pq=new ParameterizedQuery(queryType);
		pq.setWhereClause("EXISTS (SELECT sn FROM Session sn WHERE sn.project = :project AND sn MEMBER OF "+ParameterizedQuery.JPQL_SELECT_EXPRESSION+".sessions)");
		pq.setQueryParams(new QueryParam[]{new QueryParam("project",selProject)});
		setParameterizedQuery(pq);
		processListRequest(req);
	}
	
//	public void speakersByAccount(HttpServletRequest req) throws ControllerException{
//		
//		Project selProject=getSelectedProject(req);
//		if(selProject==null) {
//			allSpeakersByAccount(req);
//		}else {
//			speakersOfSelectedProjectByAccount(req,selProject);
//		}
//	}
	
	public void allSpeakersByAccount(HttpServletRequest req) throws ControllerException{
		
		Account acc = getAccountByRequest(req);

		createEmptyBeanTableModel(req);
		if (acc != null) {

			if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())){
				ParameterizedQuery<Speaker> pq = new ParameterizedQuery<Speaker>(queryType);
				String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;

//				String whereClause="(EXISTS (SELECT orga FROM Organisation orga,Project prj WHERE "+jse+" MEMBER OF orga.persons AND :account MEMBER OF prj.adminAccounts AND prj MEMBER OF orga.projects)) OR "
//						+ "("+jse+" IN (SELECT spk FROM Speaker spk, Session sess WHERE :account IS MEMBER OF sess.project AND spk MEMBER OF sess.speakers)) OR ("+jse+".registeredByAccount=:account)";
				
				String orgaCond="("+jse+" IN (SELECT p FROM Person p,Organisation orga,Project pr WHERE ( :account MEMBER OF pr.adminAccounts ) AND ( pr MEMBER OF orga.projects ) AND ( p MEMBER OF orga.persons)))";
				
				// Add speakers which participate in projects the account is admin of.
				// Fixes WSP-0044
				String personCond="("+jse+" IN (SELECT p FROM Person p,Project pr WHERE ( :account MEMBER OF pr.adminAccounts ) AND (p.account MEMBER OF pr.accounts)))";
				
				String speakerProjectBndCond="("+jse+" IN (SELECT spk FROM Speaker spk,Project pr WHERE ( :account MEMBER OF pr.adminAccounts ) AND (spk.project = pr)))";
				// Note! the sessionCond query part only works using SpeakerInformedConsent !! Maybe a Eclipse Link bug
				// or maybe this issue https://www.eclipse.org/forums/index.php/t/199730/
				String sessionCond="("+jse+" IN (SELECT spk FROM Speaker spk,Project prj,Session sess WHERE ( :account MEMBER OF prj.adminAccounts ) AND ( prj=sess.project ) AND ( spk MEMBER OF sess.speakers)))";
				String registeredByCond="("+jse+".registeredByAccount=:account)";
				
				
				String whereClause=orgaCond+" OR "+personCond+ " OR "+speakerProjectBndCond+" OR "+sessionCond+" OR "+registeredByCond;
				
				
				pq.setWhereClause(whereClause);

				pq.setQueryParams(new QueryParam[] {new QueryParam("account",acc) });

				pq.setSelectDistinct(true);
				setParameterizedQuery(pq);
				processListRequest(req);
			}else if(req.isUserInRole(UserRoleId.RoleName.ORGANISATION.name())){
				ParameterizedQuery<Speaker> pq = new ParameterizedQuery<Speaker>(queryType);
				String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
				pq.setWhereClause("EXISTS (SELECT orga FROM Organisation orga,Project prj WHERE :organisationId = orga.organisationId AND orga MEMBER OF "+jse+".organisations)");

				pq.setQueryParams(new QueryParam[] { new QueryParam("organisationId", acc.getOrganisation().getOrganisationId())});

				setParameterizedQuery(pq);
				processListRequest(req);
			}else if(req.isUserInRole(UserRoleId.RoleName.SUBJECT.name())){
				Person p=acc.getPerson();

				ParameterizedQuery<Speaker> pq = new ParameterizedQuery<Speaker>(queryType);
				String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;

				String whereCl="(";
				// list contains: 
				if(p!=null) {
					// the person directly associated with the account 
					whereCl=whereCl+"(:personId = "+jse+".personId) OR ";
				}

				// or registered by this account 
				whereCl=whereCl+"(:acc = "+jse+".registeredByAccount) OR ";
				// or project bound speaker data
				whereCl=whereCl+"(:acc = "+jse+".speakerDataAccount)";

				whereCl=whereCl+")";

				pq.setWhereClause(whereCl);
				List<QueryParam> qps=new ArrayList<>();
				if(p!=null) {
					qps.add(new QueryParam("personId",p.getPersonId()));
				}
				qps.add(new QueryParam("acc",acc));
				pq.setQueryParams(qps.toArray(new QueryParam[0]));

				setParameterizedQuery(pq);
				processListRequest(req);
			}
		}
	}
	
//public void speakersOfSelectedProjectByAccount(HttpServletRequest req,Project selProject) throws ControllerException{
//		
//		Account acc = getAccountByRequest(req);
//		
//		createEmptyBeanTableModel(req);
//		if (acc != null)
//
//			if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())&& (selProject!=null) && (selProject.getAdminAccounts().contains(acc))){
//				ParameterizedQuery pq = new ParameterizedQuery(queryType);
//				String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
//
//				String whereClause="(EXISTS (SELECT orga FROM Organisation orga WHERE "+jse+" MEMBER OF orga.persons AND :project MEMBER OF orga.projects)) OR "
//						+ "("+jse+" IN (SELECT spk FROM Speaker spk, Session sess WHERE sess.project =:project AND spk MEMBER OF sess.speakers)) OR ("+jse+".registeredByAccount=:account)";
//
//				pq.setWhereClause(whereClause);
//
//				pq.setQueryParams(new QueryParam[] {new QueryParam("project", selProject),new QueryParam("account",acc) });
//
//				pq.setSelectDistinct(true);
//				setParameterizedQuery(pq);
//				processListRequest(req);
//			}else if(req.isUserInRole(UserRoleId.RoleName.ORGANISATION.name())){
//				ParameterizedQuery pq = new ParameterizedQuery(queryType);
//				String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
//				pq.setWhereClause("EXISTS (SELECT orga FROM Organisation orga WHERE :organisationId = orga.organisationId AND orga MEMBER OF "+jse+".organisations AND :project MEMBER OF orga.projects)");
//
//				pq.setQueryParams(new QueryParam[] { new QueryParam("organisationId", acc.getOrganisation().getOrganisationId()),new QueryParam("project", selProject) });
//
//				setParameterizedQuery(pq);
//				processListRequest(req);
//			}else if(req.isUserInRole(UserRoleId.RoleName.SUBJECT.name())){
//				Person p=acc.getPerson();
//				if(p!=null){
//					ParameterizedQuery pq = new ParameterizedQuery(queryType);
//					String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
//
//					// list contains: the person directly associated with the account 
//					pq.setWhereClause("((:personId = "+jse+".personId) OR "+
//					// or registered by this account and are member of sessions of the selected project 
//				    "(:acc = "+jse+".registeredByAccount) AND "+
//					"("+jse+" IN (SELECT spk FROM Speaker spk, Session sess WHERE sess.project =:project AND spk MEMBER OF sess.speakers))) OR "+
//				    
//					// or speakers registered by this account which are not member of any sessions yet (and cannot associated to the selected project)
//					"(:acc = "+jse+".registeredByAccount AND SIZE("+jse+".sessions)=0 )");
//					
//					pq.setQueryParams(new QueryParam[] { new QueryParam("personId",p.getPersonId()),new QueryParam("acc",acc),new QueryParam("project",selProject) });
////					pq.setQueryParams(new QueryParam[] { new QueryParam("personId",p.getPersonId()),new QueryParam("acc",acc)});
//
//					setParameterizedQuery(pq);
//					processListRequest(req);
//				}
//			}
//	}


	
	
	public FormConfiguration getProjectSpeakerFormConfiguration(){
		FormConfiguration spkFormConfig=null;
		Project project= getSelectedProject();
		if(project!=null){
			FormConfiguration fCfg=project.getSpeakerFormConfiguration();
				if(fCfg!=null && Speaker.class.equals(fCfg.getBeanClass())){
					spkFormConfig=fCfg;
				}
		}
		return  spkFormConfig;
	}
	
	public String localizedDefaultResearchPurpose(Locale loc,Project prj) {
		
		// Init with default
		String defResearchPupose=prj.getDefaultResearchPurpose();
		String defRpLc=prj.getDefaultResearchPurposeLanguageISO3code();
		List<LocalizedDefaultPurposeText> addLangs=prj.getDefaultResearchPurposeAdditionalLanguages();
		String iso3Lang=loc.getISO3Language();
		if(addLangs.size()>0 && !iso3Lang.equals(defRpLc)) {
			for(LocalizedDefaultPurposeText ldpt:addLangs) {
				String ldptLc=ldpt.getLanguageISO3code();
				if(iso3Lang.equals(ldptLc)) {
					defResearchPupose=ldpt.getLocalizedText();
				}
			}
		}
		return defResearchPupose;
	}
	
	public String getConsentInformText(){
		if(currentRequest==null){
			return null;
		}
		Locale loc=LocaleSupport.getLocale(currentRequest);
		ResourceBundle rb=ResourceBundle.getBundle("Messages",loc);
		
		Project selProject=getSelectedProject(currentRequest);
		String prjNm=selProject.getName();
		String defResearchPupose=localizedDefaultResearchPurpose(loc,selProject);
		String p=rb.getString("consent.inform.text");
		String t=MessageFormat.format(p,new Object[]{prjNm,defResearchPupose});	
		return t;
		
	}
	
	public String getConsentInformedText(){
		if(currentRequest==null){
			return null;
		}
		Locale loc=LocaleSupport.getLocale(currentRequest);
		ResourceBundle rb=ResourceBundle.getBundle("Messages",loc);
		
		Project selProject=getSelectedProject(currentRequest);
		String prjNm=selProject.getName();
		
		String p=rb.getString("consent.informed.text");
		String t=MessageFormat.format(p,new Object[]{prjNm});	
		return t;
		
	}
	
	
	public String getBroadConsentInformedText(){
		if(currentRequest==null){
			return null;
		}
		Locale loc=LocaleSupport.getLocale(currentRequest);
		ResourceBundle rb=ResourceBundle.getBundle("Messages",loc);
		
		Project selProject=getSelectedProject(currentRequest);
		String prjNm=selProject.getName();
		
		String p=rb.getString("consent.informed.broad.purpose.text");
		String t=MessageFormat.format(p,new Object[]{prjNm});	
		return t;
		
	}
	
	
	public void getSpeakersByOrganisation(HttpServletRequest req) throws ControllerException{

		Project selProject=getSelectedProject(req);
		//String remoteUser = req.getRemoteUser();
		Account acc=getAccountByRequest(req);
		if(selProject==null || acc==null){
			beanTableModel=new BeanTableModel<Speaker>();
			return;
		}
		
		ParameterizedQuery pq=new ParameterizedQuery(queryType);
		pq.setWhereClause("( EXISTS (SELECT sn FROM Session sn WHERE sn.project = :project AND (sn MEMBER OF "+ParameterizedQuery.JPQL_SELECT_EXPRESSION+".sessions)) AND :organisation MEMBER OF "+ParameterizedQuery.JPQL_SELECT_EXPRESSION+".organisations )");
		pq.setQueryParams(new QueryParam[]{new QueryParam("project",selProject),new QueryParam("organisation",acc.getOrganisation())});
		setParameterizedQuery(pq);
		processListRequest(req);
	}

	public Organisation getOrganisationOfAccount(){
		if(currentRequest==null)return null;
		Account acc=getAccountByRequest(currentRequest);
		Organisation organisationOfAccount=null;
		if(acc!=null){
			organisationOfAccount=acc.getOrganisation();
		}
		return organisationOfAccount;
	}
	
	public ValidationResult validate(Object o, ValidationResult validationResult)
			throws ValidationException {
		ValidationResult vr = super.validate(o, validationResult);
		if (!vr.isValid())
			return vr;
		
		
		Speaker spk = (Speaker) o;
		
		//var propVrMap=new Hashtable<String, PropertyValidationResult>();
		
		//Check code
		String spkCode=spk.getCode();
		SpeakerInformedConsentController.validateSpeakerCode(vr, spkCode);
		
		return vr;

	}

//	public Speaker getPersonalSpeakerByLogin(String remoteUser){
//		Speaker speaker=null;
//		if (remoteUser!=null){
//			EntityManager em = getThreadEntityManager();
//				Account a=em.find(Account.class,remoteUser);
//				if (a!=null){
//					Person p=a.getPerson();
//					if (p!=null){
//						// Hmm . How to get the Speaker now ?
//						Speaker s=em.find(Speaker.class,p.getPersonId());
//						if (s!=null){
//							speaker=s;
//						}else{
//							// ??
//						}
//					}
//				}	
//		}
//		return speaker;
//	}
	
	public Speaker getSpeaker() throws ControllerException {
		return (Speaker)getItem();
	}

	public void setSpeaker(Speaker speaker) {
		this.speaker = speaker;
	}
		
	

	

}
