package ipsk.webapps.db.speech.filter;

import ipsk.db.speech.Project;
import ipsk.webapps.db.speech.ProjectController;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AutoSessionFilter implements Filter {

	public void destroy() {
		// nothing to do
	}

	public void doFilter(ServletRequest arg0, ServletResponse arg1,
			FilterChain arg2) throws IOException, ServletException {
		boolean forwardable = !arg1.isCommitted();
		if (arg0 instanceof HttpServletRequest) {
			HttpServletRequest httpReq = (HttpServletRequest) arg0;

			// TODO Check hidden link

			// if OK create session
			HttpSession sess = httpReq.getSession(false);
			ProjectController prjCtrl = new ProjectController();
			prjCtrl.open();
			boolean urlOk=false;
			
			prjCtrl.close();
			if (urlOk && sess != null && forwardable) {
				sess.setAttribute("HIDDEN_LINK_LOGIN", new Date());
				// forward to speaker or session form

				RequestDispatcher rd = httpReq.getRequestDispatcher("bla");
				rd.forward(arg0, arg1);
				return;
			}
			
			
		}

		if (arg2 != null)
			arg2.doFilter(arg0, arg1);

	}

	public void init(FilterConfig arg0) throws ServletException {
		// nothing to do
	}

}
