package ipsk.webapps.db.speech.script;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;

import ips.servlet.http.ParameterMapHttpServletRequestWrapper;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.servlets.FileServer;
import ipsk.webapps.db.speech.AdminSecurityManager;
import ipsk.webapps.db.speech.FilesystemController;

@WebListener
public class MediaitemController extends BasicPersistenceBeanController<Mediaitem> implements ServletContextListener{
	
	private FilesystemController fsContr;
	
	public boolean isUpDirPossible() {
		return fsContr.isUpDirPossible();
	}

	public String getCurrentPath() {
		return fsContr.getCurrentPath();
	}

	public void setCurrentPath(String currentPath) {
		fsContr.setCurrentPath(currentPath);
	}

	public File[] getFiles() {
		return fsContr.getFiles();
	}
	
	private static File baseDir;

	private boolean showResources=false;
	
	public boolean getShowResources() {
		return showResources;
	}

	public MediaitemController() {
		super("WebSpeechDBPU",Mediaitem.class, "mediaitem");
		securityManager=new AdminSecurityManager();
		fsContr=new FilesystemController();
		fsContr.setBaseDir(MediaitemController.baseDir);
	}
	
	@Override
	public void processRequest(HttpServletRequest req) throws ControllerException {
		String cmdSelRes=req.getParameter("_apply_and_select_resource");
		String cmdApplRes=req.getParameter("_apply_resource");
		String cmdParam=req.getParameter("_cmd");
		
		
		// check the file path as URI
		String srcStrParam=req.getParameter("srcStr");
		if(srcStrParam!=null){
			try {
				new URI(srcStrParam);
			} catch (URISyntaxException e) {
				processResult=new ProcessResult(ProcessResult.Type.ERROR);
				processResult.setLocalizableMessage(new LocalizableMessage("Could not convert file path \""+srcStrParam+"\" to an URI."));
				return;
			}
		}
	
		if(cmdParam!=null && "filesystem.cd".equals(cmdParam)){
			showResources=true;
			fsContr.processRequest(req);
			processResult=null;
		}else if(cmdSelRes!=null){
			showResources=true;
			Map<String,String[]> modMap=new HashMap<>(req.getParameterMap());
			modMap.put("_apply", new String[]{"apply"});
			ParameterMapHttpServletRequestWrapper rw=new ParameterMapHttpServletRequestWrapper(req, modMap);
			super.processRequest(rw);
			fsContr.processRequest(req);
			processResult=null;
			
		}else if(cmdApplRes!=null){
			showResources=false;
			Map<String,String[]> modMap=new HashMap<>(req.getParameterMap());
			modMap.put("_merge", new String[]{"merge"});
			ParameterMapHttpServletRequestWrapper rw=new ParameterMapHttpServletRequestWrapper(req, modMap);
			super.processRequest(rw);
			Mediaitem mi=getItem();
			if(mi!=null){
				if(mi.getSrc()!=null){
					mi.setText(null);
				}
			}
			processResult=null;
		}else{
			showResources=false;
			super.processRequest(req);
		}
		
	}
	
	@Override
	public void contextInitialized(ServletContextEvent sce) {
		String baseDirPath = sce.getServletContext().getInitParameter(FileServer.BASE_DIR_PARAMETER_KEY);
		if(baseDirPath!=null){
			File baseDir=new File(baseDirPath);
			sce.getServletContext().log("Base directory set on context initialize: "+baseDir);
			Path resourcesDir=baseDir.toPath().resolve(FileServer.RESOURCES_DIR);
			if(!Files.exists(resourcesDir)){
				try {
					Files.createDirectory(resourcesDir);
					
				} catch (IOException e) {
					sce.getServletContext().log("ERROR: Could not create resources directory: "+resourcesDir+": "+e.getMessage());
					return;
				}
			}
			MediaitemController.baseDir=resourcesDir.toFile();
			fsContr.setBaseDir(MediaitemController.baseDir);
			sce.getServletContext().log("Resource directory set: "+resourcesDir);
		}
	}

	@Override
	public void contextDestroyed(ServletContextEvent sce) {
		
	}

}
