package ipsk.webapps.db.speech.ws;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import ipsk.db.speech.Account;
import ipsk.webapps.EntityManagerFactoryInitializer;

@Path("/self")
public class SelfResource extends WikispeechBasicResource<Account>{

	public SelfResource() {
		super(Account.class);
	}

	@GET
	@Produces({MediaType.APPLICATION_JSON,MediaType.APPLICATION_XML})
	@Path("/account")
	public Response selfAccount(@Context HttpServletRequest req){
		EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		try{	
			Account loggedAcc=getAccountByRequest(req, em);
			if(loggedAcc!=null){
				return Response.ok(loggedAcc).build();
			}
			return Response.status(Status.NOT_FOUND).build();

		}finally{
			em.close();
		}
	}

}
