package ipsk.webapps.db.speech.ws;

//import javax.ws.rs.ApplicationPath;

import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.CsrfProtectionFilter;

import ipsk.webapps.db.speech.ws.pub.WavFileBodyWriter;

// Now declared in web.xml servlet-mappings to have second access path for Angular
//@ApplicationPath("/api/v1")
public class WikiSpeechApplication extends ResourceConfig{
	
	
	public WikiSpeechApplication() {
		super();
		register(LoggingFeature.class);
		property(LoggingFeature.LOGGING_FEATURE_LOGGER_LEVEL_SERVER, "FINEST");
       
		// tracing, logging commented out
        //property("jersey.config.server.tracing.type", "ALL");
        //property("jersey.config.server.tracing.threshold", "VERBOSE");
        
        //property("org.glassfish.jersey.tracing.level","FINER");
        
		// Use Eclipse Moxy for marshalling/unmarshalling 
		register(org.glassfish.jersey.moxy.json.MoxyJsonFeature.class);
		
        //Configure MoXY (e.g. pretty print)
        register(JsonMoxyConfigurationContextResolver.class);
        
        // Catch ClientAbortExceptions and reduce output to stdout (catalina.out)
        register(ClientAbortExceptionWriterInterceptor.class);
        
     	// register event listener to log MoXY marshalling execption to stderr (-> catalina.out) 
        register(ExceptionListener.class);
        
        register(MultiPartFeature.class);
        
        // Used for chunked audio downloads
        register(WavFileBodyWriter.class);
        
        // Add resources
        register(CSRFProtectionFilter.class);
        register(CSRFTestResource.class);
        register(SelfResource.class);
        register(AccountResource.class);
		register(ProjectResource.class);
		register(SessionResource.class);
		register(SpeakerResource.class);
		register(ScriptResource.class);
		register(RecordingFileResource.class);
		
		
	}
}
