<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page isELIgnored="false" import="javax.servlet.jsp.*,java.util.*" session="true"%>
<%@page import="ipsk.db.speech.UserRoleId"%>
<fmt:setBundle var="msgs" basename="Messages" scope="request"/>
<fmt:setBundle var="commons" basename="ipsk.util.Messages" scope="request"/>
<fmt:setBundle var="beans" basename="ipsk.db.speech.PropertyNames" scope="request" /> 
<%

String remoteUser=request.getRemoteUser();
//Session sess=request.getSession(false)
if(session!=null){
	String id=session.getId();
}
boolean authenticated=(remoteUser != null && session!=null && ((session.getAttribute("logout.request")==null) || (! session.getAttribute("logout.request").equals(Boolean.valueOf(true)))));
%>

<jsp:useBean id="menuProjectsDb" scope="request" class="ipsk.webapps.db.speech.ProjectController" />
<ips:ctrl_process controller="${menuProjectsDb}" processMethod="getAssociatedProjects" var="menuAssProjects">

<h2><fmt:message  bundle="${msgs}" key="menu"/></h2>
<table class="menu">
<tr><td><a href="<c:url  value="/index.jsp"/>"><i class="fa fa-fw fa-home"></i> <fmt:message  bundle="${msgs}" key="menu.home"/></a></td></tr>
<!-- <tr><td><a href="<c:url value="/infos/about.jsp"/>"><i class="fa fa-fw fa-info"></i> <fmt:message  bundle="${msgs}" key="application.about"/></a></td></tr>-->
<tr><td><a href="<c:url value="/infos/contact.jsp"/>"><i class="fa fa-fw fa-envelope"></i> <b><fmt:message  bundle="${msgs}" key="contact"/></b></a></td></tr>
<tr><td><a href="<c:url value="/infos/privacy_policy.jsp"/>"><i class="fa fa-fw fa-user-shield"></i> <b><fmt:message  bundle="${msgs}" key="privacy.policy"/></b></a></td></tr>
<tr><td><a href="http://www.phonetik.uni-muenchen.de" target="_blank"><i class="fa fa-fw fa-external-link-square-alt"></i> <fmt:message  bundle="${msgs}" key="ipsk.name"/></a></td></tr>
<tr><td><a href="http://www.lmu.de" target="_blank"><i class="fa fa-fw fa-university"></i> <fmt:message  bundle="${msgs}" key="lmu.name"/></a></td></tr>

</table>
<br>
<table class="menu">
<tr><td><a href="<c:url value="/infos/system_requirements.jsp"/>"><i class="material-icons">devices</i> <fmt:message  bundle="${msgs}" key="system_requirements"/></a></td></tr>
<tr><td><a href="<c:url value="/infos/manual.jsp"/>"><i class="fas fa-book-open"></i> <fmt:message  bundle="${msgs}" key="manual"/></a></td></tr>
<c:if test="${menuProjectsDb.admin or menuProjectsDb.projectAdmin}">
<tr><td><a href="<c:url value="/infos/changelog.jsp"/>"><i class="material-icons">format_list_bulleted</i> Application changelog</a></td></tr>
</c:if>
</table>
<br>
 
<c:choose>
<c:when test="${menuProjectsDb.admin}">
<table class="menu">
<tr><td><a href="<c:url value="/db/SessionObserver.jsp"/>"><fmt:message  bundle="${msgs}" key="web.sessions"/></a></td></tr>
<tr><td><a href="<c:url value="/db/account/request/AccountRequests.jsp"/>">Account requests</a></td></tr>
<tr><td><a href="<c:url value="/db/account/request/InvitationRequests.jsp"/>">Invitation requests</a></td></tr>
<tr><td><a href="<c:url value="/db/SystemInfo.jsp"/>"><fmt:message  bundle="${msgs}" key="system.info"/></a></td></tr>
<tr><td><a href="<c:url value="/db/PersistenceUnit.jsp"/>"><fmt:message  bundle="${msgs}" key="system.persistence_unit"/></a></td></tr>
<tr><td><a href="<c:url value="/db/MaintenanceSwitch.jsp"/>">Maintenance</a></td></tr>
</table>
<br>
<table class="menu">
<!--  <tr><td><a href="<c:url value="/db/Statistic.jsp"/>"><fmt:message  bundle="${msgs}" key="statistic"/></a></td></tr>
<tr><td><a href="<c:url value="/db/ActionDatabase.jsp?_cmd=list&amp;order=id"/>"><fmt:message  bundle="${msgs}" key="actions"/></a></td></tr>-->
<tr><td><a href="<c:url value="/db/project/Projects.jsp"/>"><fmt:message  bundle="${msgs}" key="projects"/></a></td></tr>
<tr><td><a href="<c:url value="/db/project/audio/AudioFormats.jsp"/>"><fmt:message  bundle="${msgs}" key="audio.formats"/></a></td></tr>
<tr><td><a href="<c:url value="/db/project/audio/AudioDevices.jsp"/>"><fmt:message  bundle="${msgs}" key="audio.devices"/></a></td></tr><tr><td><a href="<c:url value="/db/project/region/DialectRegions.jsp"/>"><fmt:message  bundle="${msgs}" key="dialect_regions"/></a></td></tr>
<tr><td><a href="<c:url value="/db/project/text/LocalizableMessages.jsp"/>"><fmt:message  bundle="${msgs}" key="loc_messages"/></a></td></tr>
<tr><td><a href="<c:url value="/db/organisation/Organisations.jsp?_cmd=list&amp;order=zipcode"/>"><fmt:message  bundle="${msgs}" key="organisations"/></a></td></tr>
<tr><td><a href="<c:url value="/db/project/forms/speaker/FormConfigurations.jsp"/>"><fmt:message  bundle="${msgs}" key="form.configurations"/></a></td></tr>
<tr><td><a href="<c:url value="/db/person/Persons.jsp?_cmd=list"/>"><fmt:message  bundle="${msgs}" key="persons"/></a></td></tr>
<tr><td><a href="<c:url value="/db/account/Accounts.jsp"/>"><fmt:message  bundle="${msgs}" key="accounts"/></a></td></tr>
<tr><td><a href="<c:url value="/db/account/ProjectAdminAccounts.jsp"/>"><fmt:message  bundle="${msgs}" key="accounts.project_admin"/></a></td></tr>
<tr><td><a href="<c:url value="/db/account/UserRoles.jsp"/>"><fmt:message  bundle="${msgs}" key="roles"/></a></td></tr>
<tr><td><a href="<c:url value="/db/speaker/Speakers.jsp"/>"><fmt:message  bundle="${msgs}" key="speakers"/></a></td></tr>
<tr><td><a href="<c:url value="/db/person/Technicians.jsp"/>"><fmt:message  bundle="${msgs}" key="technicians"/></a></td></tr>
<tr><td><a href="<c:url value="/db/informedconsent/InformedConsents.jsp"/>"><fmt:message  bundle="${beans}" key="consents.informed"/></a></td></tr>
<tr><td><a href="<c:url value="/db/session/Sessions.jsp"/>"><fmt:message  bundle="${msgs}" key="sessions"/></a></td></tr>
<fmt:bundle basename="ipsk.db.speech.PropertyNames" >
<tr><td><a href="<c:url value="/db/session/recfiles/RecordingFiles.jsp?_cmd=list_order_by&amp;_ob0=date&amp;_obd0=DESC"/>"><fmt:message  bundle="${msgs}"  key="recording_files"/></a></td></tr>
<tr><td><a href="<c:url value="/db/distribution/Distributions.jsp"/>"><fmt:message  bundle="${msgs}"  key="distributions"/></a></td></tr>
</fmt:bundle>
</table>
<br>
<table class="menu">
<tr><td><a href="<c:url value="/db/script/Scripts.jsp"/>"><i class="fa fa-fw fa-scroll"></i> <fmt:message  bundle="${msgs}" key="speechrecorder.recording_scripts"/></a></td></tr>
<tr><td><a href="<c:url value="/db/script/Sections.jsp"/>"><fmt:message  bundle="${msgs}" key="speechrecorder.recording_script.sections"/></a></td></tr>
<tr><td><a href="<c:url value="/db/script/Groups.jsp"/>"><fmt:message  bundle="${msgs}" key="speechrecorder.recording_script.groups"/></a></td></tr>
<tr><td><a href="<c:url value="/db/script/Recordings.jsp"/>"><fmt:message  bundle="${msgs}" key="speechrecorder.recording_script.recordings"/></a></td></tr>
<tr><td><a href="<c:url value="/db/script/Recinstructionss.jsp"/>"><fmt:message  bundle="${msgs}" key="recscript.recinstructionss"/></a></td></tr>
<tr><td><a href="<c:url value="/db/script/Mediaitems.jsp"/>"><fmt:message  bundle="${msgs}" key="speechrecorder.recording_script.mediaitems"/></a></td></tr>
<tr><td><a href="<c:url value="/db/script/Reccomments.jsp"/>"><fmt:message  bundle="${msgs}" key="recscript.reccomments"/></a></td></tr>
</table>
<br>
</c:when>

<c:when test="${menuProjectsDb.projectAdmin}">
<table class="menu">
<tr><td><a href="<c:url value="/prjdb/project/Projects.jsp?_cmd=list_all"/>"><i class="fa fa-fw fa-list"></i> <fmt:message  bundle="${msgs}" key="projects"/></a></td></tr>
<tr><td><a href="<c:url value="/prjdb/script/Scripts.jsp?_cmd=list_all"/>"><i class="fa fa-fw fa-scroll"></i> <fmt:message  bundle="${msgs}" key="speechrecorder.recording_scripts"/></a></td></tr>
<tr><td><a href="<c:url value="/prjdb/organisation/Organisations.jsp?_cmd=list_all"/>"><i class="fa fa-fw fa-building"></i> <fmt:message  bundle="${msgs}" key="organisations"/></a></td></tr>
<tr><td><a href="<c:url value="/prjdb/account/Accounts.jsp?_cmd=list_all"/>"><i class="fa fa-fw fa-user"></i> <fmt:message  bundle="${msgs}" key="accounts"/></a></td></tr>
<tr><td><a href="<c:url value="/prjdb/account/request/InvitationRequests.jsp?_cmd=list_all"/>"><i class="fa fa-fw fa-seedling"></i> <fmt:message bundle="${msgs}" key="invitations"/></a></td></tr>
<tr><td><a href="<c:url value="/prjdb/speaker/Speakers.jsp?_cmd=list_all"/>"><i class="material-icons">face</i> <fmt:message  bundle="${msgs}" key="speakers"/></a></td></tr>
<tr><td><a href="<c:url value="/prjdb/session/Sessions.jsp?_cmd=list_all"/>"><i class="fa fa-fw fa-clipboard-list"></i> <fmt:message  bundle="${msgs}" key="sessions"/></a></td></tr>
</table>
<br>
</c:when>

<c:when test="${menuProjectsDb.projectSubject}">
<table class="menu">
<tr><td><a href="<c:url value="/session/db/speaker/Speakers.jsp?_cmd=list_all"/>"><i class="material-icons">face</i> <fmt:message  bundle="${msgs}" key="speakers"/></a></td></tr>
<tr><td><a href="<c:url value="/session/db/session/Sessions.jsp?_cmd=list_all"/>"><i class="fa fa-fw fa-clipboard-list"></i> <fmt:message  bundle="${msgs}" key="sessions"/></a></td></tr>
</table>
<br>
</c:when>

</c:choose>


<%
if (authenticated && (request.isUserInRole(UserRoleId.RoleName.SUBJECT.name()) || request.isUserInRole(ipsk.db.speech.UserRoleId.RoleName.ORGANISATION.name()) || request.isUserInRole(ipsk.db.speech.UserRoleId.RoleName.PROJECT_ADMIN.name()))){ %>

<!--  Authenticated subject or organisation user -->



<c:if test="${fn:length(menuAssProjects) > 1}">
<table class="menu">
<!--  Select project -->
<tr><td><a href="<c:url value="/session/select_project.jsp"/>"><i class="fa fa-fw fa-bars"></i> <b><fmt:message  bundle="${msgs}" key="project.select"/></b></a></td></tr>
</table>
<br>
</c:if>

<table class="menu">
<c:if test="${menuProjectsDb.selfRecordingSessionAllowed}">
<!-- User has selected a project and is allowed to record  -->
			
			<c:choose>
			<c:when test="${menuProjectsDb.speakerDataAvailable}">
				<!--  some speaker data already available -->
				<c:choose>
				<c:when test="${menuProjectsDb.subjectHasInformedConsentForSelectedProject and menuProjectsDb.speakerDataComplete}">
			<!--  Speaker data already complete, start session -->
								<c:url var="newSessionURL"
									value="/session/db/session/SessionNew.jsp">
									<c:param name="_cmd" value="new" />
									<c:param name="project.name"
										value="${menuProjectsDb.selectedProject.name}" />
									<c:param name="type" value="NORM" />
									<c:param name="code"
										value="${menuProjectsDb.selectedProject.sessionCode}" />
									<c:param name="speakers.personId"
										value="${menuProjectsDb.speakerId}" />
								</c:url>
								<tr>
									<td><a href="${newSessionURL}"><b><fmt:message  bundle="${msgs}"
													key="session.new" /></b></a></td>
								</tr>
						</c:when>
				
						<c:otherwise>
								<!--  Speaker data not complete, show speaker editor to request completion -->
								<c:url var="editSpeakerURL"
									value="/session/db/speaker/SpeakerEdit.jsp">
									<c:param name="_cmd" value="edit" />
									<c:param name="personId" value="${menuProjectsDb.speakerId}" />
								</c:url>
								<tr>
									<td><a href="${editSpeakerURL}"><b><fmt:message  bundle="${msgs}"
													key="session.new" /></b></a></td>
								</tr>
							</c:otherwise>
					</c:choose>
					</c:when>
					
					<c:otherwise>
					<!--  No speaker data available, show new speaker form -->
					<c:url var="newSpeakerURL" value="/session/db/speaker/SpeakerNew">
					<c:param name="_cmd" value="new" />
					</c:url>	
					<tr><td><a href="${newSpeakerURL}"><b><fmt:message  bundle="${msgs}" key="session.new" /></b></a></td></tr>
					</c:otherwise>
					</c:choose>

		</c:if> <!--  End condition self recording session allowed -->

<c:if test="${menuProjectsDb.projectExperimenter}">

<!-- Account is project experimenter or no speaker data is yet available for this account.  Show new speaker form -->
<!--  <tr><td><a href="<c:url value="/session/BeginNewSession"/>"><b><fmt:message  bundle="${msgs}" key="session.new"/></b></a></td></tr>-->
 <tr><td><a href="<c:url value="/session/db/speaker/SpeakerNew?_cmd=new"/>"><i class="fas fa-user-plus"></i> <b><fmt:message  bundle="${msgs}" key="speaker.new"/></b></a></td></tr>
</c:if>

<!--  Java Web upload cache without session. Deprecated. -->
<c:if test="${menuProjectsDb.selfRecordingSessionAllowed or menuProjectsDb.projectExperimenter}">
<c:if test="${menuProjectsDb.usesJavaWebStart}">
<!-- Menu item to start Upload of client pending recordings -->
<tr><td><a href="<c:url value="/session/speechrecorder/UploadStart.jsp"/>"><b><fmt:message  bundle="${msgs}" key="recordings.upload.pending"/></b></a></td></tr>
</c:if>
</c:if>

<!--  Test session. Not for SUBJECT roles. -->
<c:if test="${menuProjectsDb.projectExperimenter}">
<!--  Test session URL  -->
<c:url var="testSessionNewLink" value="/session/db/session/SessionNew.jsp">
<c:param name="_cmd" value="new"/>
<c:param name="_test_session" value="true"/>
<c:param name="project.name" value="${menuProjectsDb.selectedProject.name}"/>
<c:param name="code" value="${menuProjectsDb.selectedProject.sessionCode}"/>
</c:url>
<tr><td><a href="<c:out value="${testSessionNewLink}" escapeXml="true" />"><i class="fa fa-fw fa-quote-right"></i> <b><fmt:message  bundle="${msgs}" key="session.test"/></b></a></td></tr>
</c:if>

</table>
<br>

<% } %>


<% 
boolean msgsEnabled=false;
if (authenticated && msgsEnabled) { 
ipsk.webapps.db.speech.MessageController mDB=new ipsk.webapps.db.speech.MessageController();
mDB.open();
List<ipsk.db.speech.Message> newMsgs=mDB.getUnreadMessages(request.getRemoteUser());
boolean msgNotify=(newMsgs != null && newMsgs.size() >0);
mDB.close();

String blinkStr="";
if (msgNotify) blinkStr=" class=\"blink\"";
%>
<table class="menu">
<tr><td><a href="<c:url value="/session/msgs/Messages.jsp"/>"><span<%= blinkStr %>><b><fmt:message  bundle="${msgs}" key="messages"/></b></span></a></td></tr>
</table>
<br>

<% } %>


<table class="menu">
<% if (authenticated) { 
%>
<tr><td><a href="<c:url value="/logout.jsp"/>"><i class="fa fa-fw fa-sign-out-alt"></i> <b><fmt:message  bundle="${msgs}" key="logout"/></b></a></td></tr><% } else { %>
<tr><td><a href="<c:url value="/login.jsp"/>"><i class="fa fa-fw fa-sign-in-alt"></i> <b><fmt:message  bundle="${msgs}" key="login"/></b></a></td></tr>
<% } %>

</table>
<br>


<% if(!authenticated && !request.isSecure()) { %>
<table class="menu">
<tr><td>
<a href="http://validator.w3.org/check?uri=referer"><img
        src="http://www.w3.org/Icons/valid-html401"
        alt="Valid HTML 4.01 Transitional" style="border:0;width:88px;height:31px"></a>
        </td></tr>
<tr><td>
    <a href="http://jigsaw.w3.org/css-validator/check/referer">
        <img style="border:0;width:88px;height:31px"
            src="http://jigsaw.w3.org/css-validator/images/vcss"
            alt="CSS is valid!">
    </a>
    </td></tr>
</table>
<% } %>

</ips:ctrl_process>
