<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page isELIgnored="false" import="javax.servlet.jsp.*,java.util.*" %>
<%@page import="ipsk.db.speech.UserRoleId"%>
<fmt:setBundle basename="Messages" scope="session"/>
<ul class="nav navbar-nav navbar-left">
            <li class="dropdown">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true"
                   aria-expanded="false">Help<span class="caret"></span></a>
              <ul class="dropdown-menu">

                <li class="dropdown-header">Info</li>
                  <li>WebSpeechRecorder&nbsp;0.0.9</li>
                <li class="divider"></li>

              </ul>
            </li>
<% 
boolean authenticated=(request.getRemoteUser() != null && request.getSession(false)!=null && ((session.getAttribute("logout.request")==null) || (! session.getAttribute("logout.request").equals(Boolean.valueOf(true)))));


if (authenticated && (request.isUserInRole(UserRoleId.RoleName.SUBJECT.name()) || request.isUserInRole(ipsk.db.speech.UserRoleId.RoleName.ORGANISATION.name()) || request.isUserInRole(ipsk.db.speech.UserRoleId.RoleName.PROJECT_ADMIN.name()))){ %>

<!--  Authenticated subject or organisation user -->
<jsp:useBean id="menuProjectsDb" scope="request" class="ipsk.webapps.db.speech.ProjectController" />
<ips:ctrl_process controller="${menuProjectsDb}" processMethod="getAssociatedProjects" var="menuAssProjects">


            <li class="dropdown">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown">Project <b class="caret"></b></a>
              <ul class="dropdown-menu">
                
               
             
<c:if test="${fn:length(menuAssProjects) > 1}">
<!--  Select project -->
<li><a href="<c:url value="/session/select_project.jsp"/>"><b><fmt:message key="project.select"/></b></a></li>
</c:if>
 </ul>
            </li>
            
            <li class="dropdown">
              <a href="#" class="dropdown-toggle" data-toggle="dropdown">Session <b class="caret"></b></a>
              <ul class="dropdown-menu">
                
<c:if test="${menuProjectsDb.recordingSessionAllowed}">
<!-- User has selected a project and is allowed to record  -->

<c:choose>
<c:when test="${menuProjectsDb.speakerDataAvailable}">
<!--  some speaker data already available -->
<c:choose>
<c:when test="${menuProjectsDb.speakerDataComplete}">

<!--  Speaker data already complete, start session -->
<c:url var="newSessionURL" value="/session/db/session/SessionNew.jsp">
<c:param name="_cmd" value="new"/>
<c:param name="project.name" value="${menuProjectsDb.selectedProject.name}"/>
<c:param name="type" value="NORM"/>
<c:param name="code" value="${menuProjectsDb.selectedProject.sessionCode}"/>
<c:param name="speakers.personId" value="${menuProjectsDb.speakerId}"/>
</c:url>
<li><a href="${newSessionURL}"><b><fmt:message key="session.new"/></b></a></li>
</c:when>

<c:otherwise>
<!--  Speaker data not complete, show speaker editor to request completion -->
<c:url var="editSpeakerURL" value="/session/db/speaker/SpeakerEdit.jsp">
<c:param name="_cmd" value="edit"/>
<c:param name="personId" value="${menuProjectsDb.speakerId}"/>
</c:url>
<li><a href="${editSpeakerURL}"><b><fmt:message key="session.new"/></b></a></li>
</c:otherwise>
</c:choose>
</c:when>

<c:otherwise>
<!--  No speaker data available, show new speaker form -->
<!--  <tr><td><a href="<c:url value="/session/BeginNewSession"/>"><b><fmt:message key="session.new"/></b></a></td></tr>-->
 <li><a href="<c:url value="/session/db/speaker/SpeakerNew?_cmd=new"/>"><b><fmt:message key="speaker.new"/></b></a></li>
</c:otherwise>
</c:choose>


<!--  Test session URL  -->
<c:url var="testSessionNewLink" value="/session/db/session/SessionNew.jsp">
<c:param name="_cmd" value="new"/>
<c:param name="project.name" value="${menuProjectsDb.selectedProject.name}"/>
<c:param name="code" value="${menuProjectsDb.selectedProject.sessionCode}"/>
<c:param name="type" value="TEST"/>
</c:url>
<li><a href="<c:out value="${testSessionNewLink}" escapeXml="true" />"><b><fmt:message key="session.test.new"/></b></a></li>

</c:if> <!--  End section recording session allowed -->
</ul>

</ips:ctrl_process>
<% } %>
</ul>