<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle var="msgs" basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message bundle="${msgs}" key="speaker.invite"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message bundle="${msgs}" key="speaker.invite"/></h2>
 
<jsp:useBean id="spkInvCtrl" scope="session" class="ipsk.webapps.db.speech.SpeakerInvitationController" />

<ips:ctrl_process controller="${spkInvCtrl}" processMethod="inviteSpeaker" checkSecureRequestToken="true">
<ips:ctrl_div>
<p><fmt:message bundle="${msgs}" key="speaker.invite.for.project.text"><fmt:param>${spkInvCtrl.projectName}</fmt:param></fmt:message></p>
<fmt:message bundle="${msgs}" key="speaker.invite" var="submitText"/>
<ips:bform actionCommand="invite" submitText="${submitText}" bean="${spkInvCtrl.item}">

<ips:pedit name="locale">
<tr><td><ips:pdescr/></td><td><ips:languageSelect standard="ISO-639-1" name="locale" languages="en,de,it" value="${spkInvCtrl.item.locale}"/></td></tr>
</ips:pedit>
</ips:bform>
<p><fmt:message bundle="${msgs}" key="speaker.invite.for.project.instructions"/></p>
</ips:ctrl_div>
<ips:ctrl_div result="success">
<c:choose>
<c:when test="${spkInvCtrl.isRealisationProvideLink()}">
<c:set var="link" value="${spkInvCtrl.invitationLink}"/>
<c:set var="mailToUri" value="${spkInvCtrl.invitationMailToUri}"/>
<p><fmt:message bundle="${msgs}" key="speaker.invitation.confirm"/><p>
<!-- TODO <p><a href="${mailToUri}">Start email application with template</a></p> -->
<p><fmt:message bundle="${msgs}" key="invitation.email_data.instructions"/></p>
<p style="display:block"><fmt:message bundle="${msgs}" key="email"/>:</p><p class="texttocopy"><c:out value="${spkInvCtrl.item.email}"/></p>
<c:set var="cbBtnScriptEmail" value="navigator.clipboard.writeText(\'${spkInvCtrl.item.email}\');" />
<button onclick="${cbBtnScriptEmail}" title="<fmt:message bundle="${msgs}" key="clipboard.copy"/>"><i class="fa fa-fw fa-copy"></i></button>
</div>
<div>
<p style="display:block"><fmt:message bundle="${msgs}" key="invitation.link"/>:</p>
<p class="texttocopy"><c:out value="${link}"/></p>
<c:set var="cbBtnScriptLink" value="navigator.clipboard.writeText(\'${link}\');" />
<button onclick="${cbBtnScriptLink}" title="<fmt:message bundle="${msgs}" key="clipboard.copy"/>"><i class="fa fa-fw fa-copy"></i></button>
</div>
<div>
<p style="display:block"><fmt:message bundle="${msgs}" key="validUntil"/>:</p>
<p class="texttocopy"><c:out value="${spkInvCtrl.invitationValidString()}"/></p>
<c:set var="cbBtnScriptValidUntil" value="navigator.clipboard.writeText(\'${spkInvCtrl.invitationValidString()}\');" />
<button onclick="${cbBtnScriptValidUntil}" title="<fmt:message bundle="${msgs}" key="clipboard.copy"/>"><i class="fa fa-fw fa-copy"></i></button>
</div>
</div>
</c:when>
<c:otherwise>
<p><fmt:message bundle="${msgs}" key="speaker.invite.confirm"/></p>
</c:otherwise>
</c:choose>
</ips:ctrl_div>
<ips:ctrl_div result="cancel">
<p><fmt:message bundle="${msgs}" key="speaker.invite.canceled"/></p>
</ips:ctrl_div>
</ips:ctrl_process>

</td></tr>
</table>
</body>
</html>
