<!DOCTYPE html>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" import="ipsk.beans.*" %>
<fmt:setBundle basename="Messages" scope="request"/>
<fmt:setBundle var="beans" basename="ipsk.db.speech.PropertyNames" scope="request" /> 
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="speaker.new"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="speaker.new"/></h2>		 
 
<jsp:useBean id="spkCtrl" scope="session" class="ipsk.webapps.db.speech.SpeakerInformedConsentController"/>
<jsp:setProperty name="spkCtrl" property="formConfigurationFromProject" value="true"/>
<ips:ctrl controller="${spkCtrl}">

<ips:bform  action="/session/db/speaker/SpeakerNew" actionCommand="add" requiredProps="uuid,project,registeredByAccount,organisations" >

<ips:pedit name="height" editUnit="cm"/>

<!--  
<ips:pedit name="height" var="defHeight">
<tr><td><fmt:message key="body_height"/>:</td><td><input name="height.<%= MapConverter.LEN_CM_KEY %>" type="text" value="<%= request.getParameter("height."+MapConverter.LEN_CM_KEY) %>"></td></tr>
</ips:pedit>
-->

<!--
<ips:pedit hidden="true" name="uuid">
<input type="hidden" name="uuid" value="${spkCtrl.item.uuid}"/>
</ips:pedit>
-->
 
<ips:pedit name="informedConsentInPaperFormSignedDelegate">
<c:if test="${spkCtrl.selectedProject.informedConsentPaperForm}">
<tr><td><ips:pdescr/></td><td><input type="checkbox" name="informedConsentInPaperFormSignedDelegate"></td><ips:pvalidationresult/></tr>
</c:if>
</ips:pedit>

<ips:pedit name="informedConsentDelegate">
<c:if test="${not spkCtrl.selectedProject.informedConsentPaperForm}">
<tr style="margin: 2em"><td colspan="2"><div>
    <input type="checkbox" id="subscribeInformedConsent" name="informedConsentDelegate" value="<c:out value="${spkCtrl.consentInformText}"/> <c:out value="${spkCtrl.consentInformedText}"/>" class="tableTextEmp"/>
    <label for="subscribeInformedConsent" ><ips:pdescr/> <ips:prequired/></label><p class="tableTextEmp">${spkCtrl.consentInformHtml}</p><p class="tableTextEmp"><c:out value="${spkCtrl.consentInformedText}"/></p>
  </div></td><ips:pvalidationresult/></tr>
  </c:if>
</ips:pedit>

<ips:pedit name="informedBroadConsentDelegate">
<c:if test="${spkCtrl.selectedProject.enableBroadConsent and not spkCtrl.selectedProject.informedConsentPaperForm}">
<tr style="margin: 2em"><td colspan="2"><div>
    <input type="checkbox" id="subscribeInformedBroadConsent" name="informedBroadConsentDelegate" value="<c:out value="${spkCtrl.broadConsentInformedText}"/>" class="tableTextEmp"/>
    <label for="subscribeInformedBroadConsent" ><ips:pdescr/> <ips:prequired/></label><p class="tableTextEmp"><c:out value="${spkCtrl.broadConsentInformedText}"/></p>
  </div></td><ips:pvalidationresult/></tr>
  </c:if>
</ips:pedit>

<ips:pedit name="wouldLikeToBeInformedOfTheStudysFindings">
   <tr style="margin: 2em"><td colspan="2"><div>
   <input type="checkbox" id="wouldLikeToBeInformedOfTheStudysFindingsCb" name="wouldLikeToBeInformedOfTheStudysFindings"<c:if test="${spkCtrl.item.wouldLikeToBeInformedOfTheStudysFindings}"> checked="checked"</c:if>/>
   <label for="wouldLikeToBeInformedOfTheStudysFindingsCb"><fmt:message key="would.like.to.be.informed.of.the.studys.findings.text" bundle="${beans}"/></label>
   </div></td></tr>
</ips:pedit>

<ips:pedit name="wouldLikeToBeContactedForParticipationInFutureStudies">
   <tr style="margin: 2em"><td colspan="2"><div>
   <input type="checkbox" id="wouldLikeToBeContactedForParticipationInFutureStudiesCb" name="wouldLikeToBeContactedForParticipationInFutureStudies"<c:if test="${spkCtrl.item.wouldLikeToBeContactedForParticipationInFutureStudies}"> checked="checked"</c:if>/>
   <label for="wouldLikeToBeContactedForParticipationInFutureStudiesCb"><fmt:message key="would.like.to.be.contacted.for.participation.in.future.studies.text" bundle="${beans}"/></label>
   </div></td></tr>
</ips:pedit>
 
<ips:pedit hidden="true" name="project">
 <input type="hidden" name="project" value="${spkCtrl.selectedProject}"/>
</ips:pedit>

<ips:pedit hidden="true" name="registeredByAccount">
<input type="hidden" type="hidden" name="registeredByAccount.login" value="${spkCtrl.sessionAccountLogin}"/>
</ips:pedit>

<ips:pedit hidden="true" name="organisations">
<c:set var="orgaByAcc" value="${spkCtrl.associatedOrganisation}" scope="request"/>
<c:if test="${orgaByAcc != null}">
<input type="hidden" name="organisations.organisationId" value="${orgaByAcc.organisationId}"/>
</c:if>
</ips:pedit>

<ips:pedit name="dialectRegion">
<tr><td><ips:pdescr/></td><td><select name="dialectRegion.dialectRegionId">
    
       <c:forEach var="dr" items="${spkCtrl.orderedDialectRegionsForSelectedProject}">
        <c:choose>
        <c:when test="${spkCtrl.item.dialectRegion.dialectRegionId eq dr.dialectRegionId}">
        <option value="${dr.dialectRegionId}" selected><c:out value="${dr.name}"/></option>
        </c:when>
        <c:otherwise>
        <option value="${dr.dialectRegionId}"><c:out value="${dr.name}"/></option>
        </c:otherwise>
        </c:choose>
       </c:forEach>
     </select></td></tr>

</ips:pedit>


<ips:pedit name="informedConsent">
<tr style="margin: 2em"><td colspan="2"><div>
    <input type="checkbox" id="subscribeInformedConsent" name="informedConsent" value="<c:out value="${spkCtrl.consentInformText}"/> <c:out value="${spkCtrl.consentInformedText}"/>" class="tableTextEmp"/>
    <label for="subscribeInformedConsent" ><ips:pdescr/> <ips:prequired/></label><p class="tableTextEmp"><c:out value="${spkCtrl.consentInformText}"/></p><p class="tableTextEmp"><c:out value="${spkCtrl.consentInformedText}"/></p>
  </div></td><ips:pvalidationresult/></tr>

</ips:pedit>


<ips:pedit name="informedBroadConsent">
<tr style="margin: 2em"><td colspan="2"><div>
    <input type="checkbox" id="subscribeInformedBroadConsent" name="informedBroadConsent" value="<c:out value="${spkCtrl.broadConsentInformedText}"/>" class="tableTextEmp"/>
    <label for="subscribeInformedBroadConsent" ><ips:pdescr/> <ips:prequired/></label><p class="tableTextEmp"><c:out value="${spkCtrl.broadConsentInformedText}"/></p>
  </div></td><ips:pvalidationresult/></tr>

</ips:pedit>

</ips:bform>
<p><fmt:message key="speaker.request.attributes"/></p>
</ips:ctrl>

</td></tr>
</table>
</body>
</html>
