<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<script src="<c:url value="/lib/script/ips_lib.js"/>" type="text/javascript"></script>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="speakers"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="speakers"/></h2>		 
 
<jsp:useBean id="spksDb" scope="session" class="ipsk.webapps.db.speech.SpeakerController" />
<ips:ctrl_process controller="${spksDb}" processMethod="allSpeakersByAccount">
<!-- Disabled for VOYS -->
<!-- 
<p><a href="SpeakerNew.jsp?_cmd=new&organisations.organisationId=<c:out value="${spksDb.organisationOfAccount.organisationId}"/>">[<fmt:message key="speaker.new"/>]</a></p>
-->

<ips:boolExpr/><br>
<ips:orderby/><br>
<ips:btable tableClass="db" beanVar="spk"  defColOrder="personId,code,project,registered,registeredByAccount,sessions">
<ips:col name="sessions" href="../session/Sessions.jsp"/>

<ips:btrowaction name="view" href="SpeakerView.jsp"/>
<ips:btrowaction name ="session.new">
 <c:choose>
  <c:when test="${spksDb.speakerHasInformedConsentForSelectedProject(spk) and spksDb.speakerDataComplete(spk) }">
   <c:url value="/session/db/session/SessionNew.jsp" var="sessionNewHref">
			<c:param name="_cmd" value="new"/>
			<c:param name="project.name" value="${spksDb.selectedProject.name}"/>	
			<c:param name="speakers.personId" value="${spk.personId}"/>
			<c:param name="type" value="NORM"/>
			<c:param name="code" value="${spksDb.selectedProject.sessionCode}"/>
   </c:url>
   <a href="${sessionNewHref}">[<fmt:message key="session.new"/>]</a>
  </c:when>
  <c:otherwise>
   <c:url var="editSpeakerURL" value="/session/db/speaker/SpeakerEdit.jsp">
    <c:param name="_cmd" value="edit" />
    <c:param name="personId" value="${spk.personId}" />
   </c:url>
   <a href="${editSpeakerURL}">[<fmt:message key="session.new"/>]</a>
  </c:otherwise>
 </c:choose>
</ips:btrowaction>

</ips:btable>
<ips:page_navigation/>
<ips:page_position/>
<ips:items_position/>
</ips:ctrl_process>

</td></tr>
</table>
</body>
</html>
