<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" %>
<fmt:setBundle basename="Messages" scope="request" var="msgs"/>
<fmt:setBundle basename="ipsk.db.speech.PropertyNames" scope="request" var="bndlSpDb"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="account.own.delete.request" bundle="${msgs}"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="account.own.delete.request" bundle="${msgs}"/></h2>		 
 
<jsp:useBean id="accountViewCtrl" scope="request" class="ipsk.webapps.db.speech.AccountController" />
<ips:ctrl_process controller="${accountViewCtrl}">
<ips:ctrl_div>
<ips:bview bean="${accountViewCtrl.item}" actionCommand="delete" action="DeleteOwnAccount.jsp"  tableClass="dbView">
<ips:pview name="userRoles" var="urs">
<tr><td><ips:pdescr/></td><td>
<c:choose>
 <c:when test="${accountViewCtrl.item.editable}">
  <c:forEach items="${urs}" var="ur" varStatus="ursLoopStatus">
   <fmt:message key="${ur.id.roleName.resourceKey}" bundle="${bndlSpDb}"/> (<c:out value="${ur.id.roleName.name}"/>)<c:if test="${!ursLoopStatus.last}">,</c:if>
  </c:forEach>
 </c:when>
  <c:otherwise>
  (<c:choose>
    <c:when test="${not empty initParam['directoryServiceDisplayName']}"><fmt:message key="roles.defined.in.directory.service"><fmt:param>${initParam['directoryServiceDisplayName']}</fmt:param></fmt:message></c:when>
    <c:otherwise><fmt:message key="roles.defined.in.a.directory.service"/></c:otherwise>
   </c:choose>)
 </c:otherwise>
</c:choose>
</ips:pview>
<ips:pview name="person" var="pers">
<c:if test="${not empty pers}">
 <tr><td><ips:pdescr/></td><td>
 <c:if test="${pers['class'].simpleName eq 'Speaker'}">
  <span<c:if test="${fn:length(pers.sessions) eq 0}"> style="color:red"</c:if>><fmt:message key="delete"/></span> 
  <c:choose>
   <c:when test="${fn:length(pers.sessions) gt 0}">
    <!-- Disable deletion of person if this person is a speaker which already participated in sessions -->
    <input type="checkbox" name="_delete_rel.person.personId" disabled="disabled" readonly="readonly">
   </c:when>
   <c:otherwise>
    <!-- Force deletion of person which has not yet participated in session. This would cause an completely unrelated speaker -->
    <input type="checkbox" name="_delete_rel.person.personId" disabled="disabled" readonly="readonly" checked="checked" value="<c:out value="${pers.personId}"/>">
   </c:otherwise>
  </c:choose>
<!--  TODO link will force project selection -->
<!--<c:url value="/session/db/speaker/SpeakerView.jsp" var="speakerViewUrl">
<c:param name="_cmd" value="view"/>
<c:param name="personId" value="${pers.personId}"/>
</c:url>
<a href="${speakerViewUrl}"><c:out value="${pers}"/></a> -->
 
<!--  else: empty table cell -->
 </td></tr>
</c:if>
</c:if>
</ips:pview>

<ips:pview name="organisation" hideIfEmpty="true"/>
<ips:pview name="projects" hideIfEmpty="true" maxListLength="2"/>
<ips:pview name="adminOfProjects" hideIfEmpty="true" maxListLength="2"/>

</ips:bview>
<p class="warn"><fmt:message key="deletion.cannot.be.undone"/></p>
<c:if test="${not empty accountViewCtrl.item.person}">
 <p><fmt:message key="account.speaker.associated"/></p>
<c:choose>
<c:when test="${fn:length(accountViewCtrl.item.person.sessions) gt 0}">
 <p><fmt:message key="account.own.speaker.associated.participant.cannot.deleted"/></p>
</c:when>
<c:otherwise>
 <p><fmt:message key="account.own.speaker.associated.not.participant.will.be.deleted"/></p>
</c:otherwise>
</c:choose>
</c:if>
</ips:ctrl_div>

<ips:ctrl_div result="cancel">
<p><fmt:message key="cancelled"/></p>
</ips:ctrl_div>

</ips:ctrl_process>
</td></tr>
</table>
</body>
</html>
