package ipsk.webapps.audio;

import ipsk.webapps.ControllerException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.db.speech.RecordingFileController;

import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class DSPProcessor extends Thread implements ServletContextListener,Runnable {

	public final static String THREAD_NAME="WikiSpeech-DSP-Processor";
	
	/**
	 * 	Number of recording files, which will be processed in one controller (entity manager) cycle.
	 */
	public final static int DEF_PROCESSING_BATCH_SIZE=20;
	//public final static Integer DEF_IDLE_WAIT_TIME=10*60*1000; // 10 minutes
	public final static Integer DEF_IDLE_WAIT_TIME=null; // process only on notify
	public final static boolean DEF_CONTINUE_ON_ERROR=true;
	private RecordingFileController recFileController;
	private boolean active=true;
	private boolean continueOnError=DEF_CONTINUE_ON_ERROR;
	private ServletContext servletContext;
	private static Object notify=new Object();
	private Integer idleWaitTime=DEF_IDLE_WAIT_TIME;
	private static boolean processRequest=false;
	
	public void contextDestroyed(ServletContextEvent arg0) {
		active=false;
		synchronized (notify) {
			processRequest=false;
			notify.notifyAll();
		}
		try {
			interrupt();
			join(20000);
		} catch (InterruptedException e) {
			e.printStackTrace();
			servletContext.log("Join wait on DSP process thread interrupted!");
		}
		
	}

	public void contextInitialized(ServletContextEvent event) {
		servletContext=event.getServletContext();
		// Check Entity manager Factory
		EntityManagerFactory emf=EntityManagerFactoryInitializer.getEntityManagerFactory();
		if(emf==null){
			servletContext.log("DSP Processor not started. (no entity manager factory)");

		}else{
			recFileController=new RecordingFileController();
			setName(THREAD_NAME);
			setDaemon(true);
			setPriority(MIN_PRIORITY);
			start();
			servletContext.log("DSP Processor thread \""+THREAD_NAME+"\" started.");
		}
	}
	
	
	public void run(){
		servletContext.log("DSP process thread running.");
		while(active){
			boolean moreAvailable=false;
			recFileController.open();
			try {
				moreAvailable=recFileController.processDSPInfoForAll(servletContext,DEF_PROCESSING_BATCH_SIZE);
				
				recFileController.commit();
				if(!moreAvailable)servletContext.log("Processed and stored DSP info.");
				//if(moreAvailable)servletContext.log("More audio files for processing available...");
			} catch (Exception e) {
				servletContext.log("Could not process or store DSP info: "+e.getMessage());
				
				if(!continueOnError){
					servletContext.log("WARNING! The DSP processing backgroung thread will shutdown now!!");
					active=false;
				}else{
					moreAvailable=true;
				}
			}finally{
				recFileController.close();
			}
			
			// wait for notify
			synchronized (notify) {
                try {
                	if(active && (moreAvailable || processRequest)){
                		// give a chance to interrupt
                		notify.wait(100);
                	}else{
                		if(idleWaitTime!=null){
                			notify.wait(idleWaitTime);
                		}else{
                			notify.wait();
                		}
                	}
                } catch (InterruptedException e1) {
                	servletContext.log("DSP process thread interrupted.");
                    if(recFileController!=null){
                    	recFileController.close();
                    	servletContext.log("DSP process thread controller closed.");
                    }
                }finally{
                	processRequest=false;
                }
            }
		}
	}
	
	public static void notifyThread(){
		synchronized (notify) {
			processRequest=true;
         notify.notifyAll();
     }
	}
}
