package ipsk.webapps.db.servlets;

import ipsk.audio.AudioPluginException;
import ipsk.audio.AudioSourceException;
import ipsk.audio.FileAudioSource;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.clip.AudioClipPainter;
import ipsk.audio.plugins.ChannelSelectorPlugin;
import ipsk.db.speech.RecordingFile;
import ipsk.net.http.Utils;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.db.speech.RecordingFileController;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioClipImageServlet extends HttpServlet {

	private static boolean DEBUG=false;
//	private RecordingFileController rfContr;
	public final static String IMAGE_TYPE="png";
	public final static String CONTENT_TYPE="image/"+IMAGE_TYPE;
	
	private final static int DEF_BUF_SIZE=4096;
	private static final double DEFAULT_XZOOM = 1.0;
	
	public static int DEFAULT_HEIGHT_PER_CHANNEL=100;
	private int heightPerChannel=DEFAULT_HEIGHT_PER_CHANNEL;
	
	
	public void init() throws ServletException {
		super.init();
//		rfContr=new RecordingFileController();
	}
	
	protected void doSendImage(HttpServletRequest req,
			HttpServletResponse res)
			throws IOException {
		log("Audio servlet...");
		if(DEBUG) log("Debug mode");
		int bufSize=DEF_BUF_SIZE;
		String recFileId =req.getParameter("recordingFileId");
		String channelParam=req.getParameter("channel");
		
		String xZoomParam =req.getParameter("xZoom");
		double xZoom=DEFAULT_XZOOM;
		if(xZoomParam!=null){
			xZoom=Double.parseDouble(xZoomParam);
		}
		
		RecordingFileController rfContr=new RecordingFileController();
		rfContr.open();
		RecordingFile rf=null;
		String rfStringDescr;
		String fileURLStr;
		boolean available=false;
		try {
			rf = rfContr.getById(req,Integer.parseInt(recFileId));
			available=(!rf.getStatus().equals(RecordingFile.Status.REGISTERED));
			rfStringDescr=rf.toString();
			fileURLStr=rf.getSignalFile();
		} catch (NumberFormatException e2) {
			e2.printStackTrace();
			rfContr.close();
			String msg="Parameter recordingFileId: "+recFileId+" is not a number.";
			log("ERROR "+msg);
			res.sendError(500,msg);
			return;
		} catch (ControllerException e2) {
			e2.printStackTrace();
			rfContr.close();
			String msg;
			if(e2 instanceof PermissionDeniedException){
				msg="Permission denied for recordingFileId "+recFileId;
				log("ERROR "+msg);
				res.sendError(403,msg);
			}else{
				msg=e2.getMessage();
				log("ERROR "+msg);
				res.sendError(500,msg);
			}
			return;
		}finally{
			// we have all we need from recording file so close the controller
			rfContr.close();
		}
		log("Requested: " + rfStringDescr);
		if(!available){
			// not yet stored, return 500
			String msg="Recording file "+recFileId+" has status REGISTERED";
			log("ERROR "+msg);
			res.sendError(404,msg);
			return;
		}
		
		URL fileURL=new URL(fileURLStr);
		AudioInputStream pcmStream=null;
		
		// TODO try/catch/finally to close the streams properly
		log("Create PCM stream for URL: " + fileURL);
//		File audioFile=new File(fileURL.getPath());
//		FileInputStream fis=new FileInputStream(audioFile);
//		FileChannel fc=fis.getChannel();
//		fc.close();
		
//		
		AudioInputStream srcStream=null;
		try {
			srcStream=ThreadSafeAudioSystem.getAudioInputStream(fileURL);

			if(DEBUG)log("Source audio format: "+srcStream.getFormat());
			if(DEBUG)log("Using AudioSystemWrapper");
			pcmStream=ThreadSafeAudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED,srcStream);
		} catch(IOException ioe){
			log("ERROR IO exception audio file: "+rfStringDescr+": "+ioe.getMessage());
			ioe.printStackTrace();
			res.sendError(500,ioe.getMessage());
			return;
		} catch (UnsupportedAudioFileException uae) {	
			log("ERROR unsupported audio file: "+rfStringDescr);
			uae.printStackTrace();
			res.sendError(500,uae.getMessage());
			return;
		}

		File tmpFile=File.createTempFile(getClass().getName(),".wav");
		tmpFile.deleteOnExit();
		AudioInputStream editStream=pcmStream;
		if (channelParam !=null){
		    int channel=Integer.parseInt(channelParam);
		    ChannelSelectorPlugin chSel=new ChannelSelectorPlugin(channel);
		    try {
                editStream=chSel.getAudioInputStream(pcmStream);
            } catch (AudioPluginException e1) {
            	if(editStream!=null)editStream.close();
                log("ERROR channel select: "+rfStringDescr);
    		    //sendError(res,e1);
                e1.printStackTrace();
                res.sendError(500,e1.getMessage());
                return;
            }
		}
		try{
			ThreadSafeAudioSystem.write(editStream,AudioFileFormat.Type.WAVE,tmpFile);
		}catch(IOException ioe){
			if(tmpFile!=null){
				tmpFile.delete();
			}
			throw ioe;
		}finally{
			editStream.close();
		}
		FileAudioSource fas=new FileAudioSource(tmpFile);
		int channels;
		try {
			channels = fas.getFormat().getChannels();
		} catch (AudioSourceException e2) {
			tmpFile.delete();
			log("Could not determine channel count: " + e2.getMessage());
			throw new IOException(e2);
		}
		AudioClipPainter acp=new AudioClipPainter(fas);
//		System.out.println("New audio clip painter for: "+rfStringDescr);
//		BufferedImage img=new BufferedImage(300, 40, BufferedImage.TYPE_INT_ARGB);
		RenderedImage img=null;
		try {
//			acp.paintToImage(img,xZoom);
			img=acp.createImage(xZoom, heightPerChannel*channels);
		} catch (Exception e1) {
			log("Could not paint audio clip to image: " + e1.getMessage());
			throw new IOException(e1);
		}finally{
			tmpFile.delete();
		}
		
		File tmpImgFile=File.createTempFile(getClass().getName(),"."+IMAGE_TYPE);
		System.out.println("painted to: "+tmpImgFile);
		try{
			ImageIO.write(img, IMAGE_TYPE, tmpImgFile);
		}catch(IOException ioe){
			if(tmpImgFile!=null){
				tmpImgFile.delete();
			}
			log("Could not write clip image to temp file: " + ioe.getMessage());
			throw ioe;
		}
		long contentLength=tmpImgFile.length();
        res.setContentType(CONTENT_TYPE);
        //res.setContentLength((int)contentLength);
        Utils.responseSetContentLength(res, contentLength);
        FileInputStream tmpInput=null;
        try{
        	OutputStream out=res.getOutputStream();
        	tmpInput=new FileInputStream(tmpImgFile);
		
			byte[] buf=new byte[bufSize];
			int read=0;
			while((read=tmpInput.read(buf))!=-1){
				out.write(buf,0,read);
			}
		}catch(IOException e){
			log("Could not write clip image stream: " + e.getMessage());
			throw e;
		}finally{
			try{
				if(tmpInput !=null)tmpInput.close();
			}catch(IOException e){
				log("Could not close temporary clip image stream: " + e.getMessage());
				throw e;
			}finally{
				if(tmpImgFile !=null){
					tmpImgFile.delete();
				}
			}
		}
		log("Sent clip image for: " + rfStringDescr);
			
	}
	
	protected void doGet(
			HttpServletRequest req,
			HttpServletResponse res)
			throws IOException {
			doSendImage(req, res);
	}
	protected void doPost(
			HttpServletRequest req,
			HttpServletResponse res)
			throws IOException {
			doSendImage(req, res);
	}
}
