package ipsk.webapps.db.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

import org.w3c.dom.Document;

import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.db.speech.Project;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.io.StreamCopy;
import ipsk.net.MIMEType;
import ipsk.net.MIMEUtils;
import ipsk.persistence.EntityManagerProvider;
import ipsk.text.ParserException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.audio.DSPProcessor;
import ipsk.webapps.db.speech.RecordingFileController;
import ipsk.webapps.db.speech.SessionController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;

/**
 * Servlet implementation class RESTService
 */
@MultipartConfig
@Deprecated
public class RESTServiceV1 extends HttpServlet implements EntityManagerProvider {

	private final static boolean DEBUG = true;

	private static final long serialVersionUID = 1L;
	private static volatile JAXBContext jaxbContext;
	private static volatile Charset cs;
	private static String CS_NAME = "UTF-8";

	private volatile EntityManager entityManager;
	private WikiSpeechSecurityManager securityManager;
	private HashMap jaxbEclipseLinkPropsmap;
	private File tempDir = null;

	protected final static int DEFAULT_BUFSIZE = 2048;

	protected int bufSize = DEFAULT_BUFSIZE;

	// TODO build a generic and a WikiSpeech specific service class

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public RESTServiceV1() {
		super();
		jaxbEclipseLinkPropsmap = new HashMap();
		jaxbEclipseLinkPropsmap.put("javax.xml.bind.context.factory",
				"org.eclipse.persistence.jaxb.JAXBContextFactory");
		// jaxbEclipseLinkPropsmap.put(JAXBContextFactory.ECLIPSELINK_OXM_XML_KEY,
		// "ipsk/db/speech/moxy_binding_overwrites.xml");
		//jaxbEclipseLinkPropsmap.put(JAXBContextFactory.ECLIPSELINK_OXM_XML_KEY,
		//		"ipsk/db/speech/moxy_binding_wikispeech_client_overwrites.xml");

		securityManager = new WikiSpeechSecurityManager(this);

	}

	public void init() throws ServletException {
		super.init();
		tempDir = new File(System.getProperty("java.io.tmpdir"));

	}

	private synchronized JAXBContext jaxbContext() throws JAXBException {
		if (jaxbContext == null) {
			cs = Charset.forName(CS_NAME);

			// JAXBContext jc = JAXBContext.newInstance(Bundle.class);
			jaxbContext = org.eclipse.persistence.jaxb.JAXBContextFactory.createContext(new Class[] { Script.class },
					jaxbEclipseLinkPropsmap);

		}
		return jaxbContext;
	}

	private void useDomconverter(HttpServletResponse response, Document d) throws IOException, ServletException {
		if (d != null) {
			DOMConverter conv;
			try {
				conv = new DOMConverter();
				conv.writeXML(d, response.getWriter());
			} catch (DOMConverterException e) {
				throw new ServletException(e);
			}

		}
	}

	private String createSignalFilePath(String sessionPath, String speakerCode, String itemCode, String extension,
			int sessionId, int version, boolean overwrite) {
		String speakerCodeStr = "";
		if (speakerCode != null) {
			speakerCodeStr = speakerCode;
		}
		String session = SessionController.sessionIDFormat.format(sessionId);
		String versionStr = "";
		if (!overwrite) {
			versionStr = RecordingFileController.recversionFormatter.format(version);
		}

		return sessionPath + "/" + speakerCodeStr + session + itemCode + versionStr + "." + extension;
	}

	private String createSignalFilePath(String sessionPath, String speakerCode, String itemCode, String extension,
			RecordingFile rf, boolean overwrite) {
		return createSignalFilePath(sessionPath, speakerCode, itemCode, extension, rf.getSession().getSessionId(),
				rf.getVersion(), overwrite);
	}

	private void storeToFile(InputStream is, File f, boolean append) throws IOException {
		byte[] buf = new byte[bufSize];
		FileOutputStream fos;
		File pd = f.getParentFile();
		if (DEBUG)
			log("Parent dir: " + pd.getPath());
		if (DEBUG)
			log("Saving:" + f.getAbsolutePath());
		try {
			if (DEBUG)
				log("Path:" + f.getCanonicalPath());
		} catch (IOException e) {
			log("Cannot get canonical path.", e);
			throw e;
		}
		boolean created = false;
		if (!pd.exists()) {
			if (DEBUG)
				log("Creating dir ...");
			created = pd.mkdirs();
		}
		if (created)
			log("Directory " + pd.getName() + " created.");

		// save the content
		fos = new FileOutputStream(f, append);
		int read = 0;
		long size = 0;
		// try to lock file
		try {
			fos.getChannel().lock();
		} catch (Exception locke) {
			log("could not lock file " + locke.getMessage());
		}
		try {
			do {
				read = is.read(buf, 0, bufSize);

				if (read > 0) {
					size += read;
					fos.write(buf, 0, read);
				}
			} while (read >= 0);

			log("File '" + f.getAbsolutePath() + "' (" + size + " bytes) written.");
		} catch (IOException e) {
			throw e;
		} finally {

			if (fos != null) {
				fos.getChannel().close();
				fos.close();
			}
		}

	}
	
	protected boolean checkSecurity(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{
		String serverName=request.getServerName();
		String originHeader=request.getHeader("Origin");
		String refererHeader=request.getHeader("Referer");
		String requestedWithHeader=request.getHeader("X-Requested-With");
		
		// Check for Cross-Site-Request-Forgery (CSRF)
		
		// See https://www.owasp.org/index.php/Cross-Site_Request_Forgery_(CSRF)_Prevention_Cheat_Sheet
		
		// Check Referer or Origin header
		
		if(refererHeader!=null){
			try {
				URL refererURL=new URL(refererHeader);
				String refererHost=refererURL.getHost();
				if(!serverName.equals(refererHost) ){
					log("Reject request! Invalid Referer: "+refererHeader);
					response.sendError(403);
					return false;
				}
			} catch (MalformedURLException e) {
				log("Reject request! Malformed Referer (URL) header: "+refererHeader, e);
				response.sendError(403, "Invalid Referer header");
				return false;
			}
			
		}else if(originHeader!=null){
			try {
				URL originURI=new URL(originHeader);
				String originHost=originURI.getHost();
				if(!serverName.equals(originHost) ){
					log("Reject request! Invalid Origin: "+originHeader);
					response.sendError(403);
					return false;
				}
			} catch (MalformedURLException e) {
				log("Invalid Referer header: ", e);
				response.sendError(403, "Invalid Referer header");
				return false;
			}
		}else{
			log("Reject request! Origin or Referer header not found!");
			response.sendError(403);
			return false;
		}
		
		// See https://www.owasp.org/index.php/Cross-Site_Request_Forgery_(CSRF)_Prevention_Cheat_Sheet#Verifying_Same_Origin_with_Standard_Headers
	    // Chapter: "Protecting REST Services: Use of Custom Request Headers"
		
		if(requestedWithHeader==null){
			log("Reject request! Header X-Requested-With not set");
			response.sendError(403);
			return false;
		}
		if(!"XMLHttpRequest".equals(requestedWithHeader)){
			log("Reject request! Header X-Requested-With not equal \"XMLHttpRequest\"");
			response.sendError(403);
			return false;
		}
		// all checks passed
	    return true;
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	@SuppressWarnings("unchecked")
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		// TODO disabled for debugging only !!!
		//checkSecurity(request, response);
		String reqPath = request.getPathInfo();
		
		String contentType = request.getContentType();
		MIMEType contentMimeType=null;
		try {
			contentMimeType = MIMEType.parse(contentType);
		} catch (ParserException e1) {
			log("Could not parse conent type "+contentType);
		}
		response.setCharacterEncoding("UTF-8");
		
		// Remove redundant slashes for path compare
		String restfulPath = reqPath.replaceAll("/{2,}", "/");
		entityManager = EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		if (restfulPath.startsWith("/session/")) {
			String sessionIdStr = restfulPath.replaceFirst("/session/", "");
			sessionIdStr=sessionIdStr.replaceFirst("/.*$", "");
			int sessionId = Integer.parseInt(sessionIdStr);
			Session s = entityManager.find(Session.class, sessionId);

			String recFilesPath = restfulPath.replaceFirst("/session/" + sessionIdStr, "");
			if (recFilesPath.startsWith("/recfile/")) {
				String itemCode = recFilesPath.replaceFirst("/recfile/", "");
				if (!MIMEType.AUDIO_WAVE.equals(contentMimeType)) {
					// TODO
					//response.sendError(406, "Unsupported MIME type");
				}
				EntityTransaction tx = entityManager.getTransaction();
				tx.begin();

				String sessionDir = s.getStorageDirectoryURL();
				if (sessionDir == null) {
					ServletContext sc = getServletContext();
					String recsDir = sc.getInitParameter("recsDir");
					String recsDirURL = "file:" + recsDir;
					sessionDir = SessionController.createSessionFilePath(recsDirURL, s.getSessionId());
					s.setStorageDirectoryURL(sessionDir);
				}
				tx.commit();

				String speakerCode = "";
				Set<Speaker> spks = s.getSpeakers();
				if (!spks.isEmpty()) {
					speakerCode = spks.iterator().next().getCode();
				}

				// Integer recVersion=null;
				boolean overwrite = false; // default

				InputStream is = request.getInputStream();

				String tempFilename = getClass().getName() + "_" + sessionIdStr + "_" + itemCode + "_"
						+ UUID.randomUUID() + "." + contentMimeType.getFileExtension();
				File tempAudioFile = new File(tempDir, tempFilename);

				StreamCopy.copy(is, tempAudioFile, true);

				AudioFileFormat aff = null;
				try {
					aff = ThreadSafeAudioSystem.getAudioFileFormat(tempAudioFile);
				} catch (UnsupportedAudioFileException e) {
					log(e.getMessage());

					tempAudioFile.deleteOnExit();
					// hold the temporary files for debug purposes
					// tmpFile.delete();
					throw new IOException(e.getMessage());
				}

				// store meta data to DB

				RecordingFile recFile = new RecordingFile();
				if (aff != null) {
					log("detected audio file format: " + aff);
				} else {
					log("could not detect audio file format !");
				}

				recFile.setStatus(RecordingFile.Status.REGISTERED);
				recFile.setDate(new Date());
				// recFile.setSignalFile("file:" + f.getCanonicalPath());
				tempAudioFile.deleteOnExit();
				tx = entityManager.getTransaction();
				tx.begin();
				Script recScript = s.getScript();
				if (recScript == null) {
					rollBackAndClose(entityManager);
					throw new PersistenceException("Session has no associated script !");
				}
				Query q = entityManager.createQuery(
						"SELECT r FROM Recording AS r WHERE  r.group.section.script = :recScript AND r.itemcode = :itemcode");
				q.setParameter("recScript", recScript);
				q.setParameter("itemcode", itemCode);
				Object srObj = q.getSingleResult();
				if (srObj == null) {
					throw new PersistenceException("Could not retrieve associated recording script element!");
				}
				if (!(srObj instanceof Recording)) {
					throw new PersistenceException("Expected type Recording!");
				}
				Recording recording = (Recording) srObj;
				recFile.setSession(s);

				// recFile.setVersion(overwrite);
				recFile.setRecording(recording);
				recFile.setDate(new Date());
				String extension = "unknown";
				if (aff != null) {
					AudioFormat af = aff.getFormat();
					AudioFileFormat.Type affType = aff.getType();
					extension = affType.getExtension();
					recFile.setFormat(affType.toString());
					// TODO long method versions in JDK 1.5 ?
					recFile.setBytes((long) aff.getByteLength());
					long frameLength = aff.getFrameLength();
					Long recFileFl = null;
					if (frameLength != AudioSystem.NOT_SPECIFIED) {
						recFileFl = (Long) frameLength;
					}
					recFile.setFrames(recFileFl);
					recFile.setEncoding(af.getEncoding().toString());

					recFile.setChannels(af.getChannels());
					recFile.setQuantisation(af.getSampleSizeInBits());
					recFile.setSamplerate(new Double(af.getSampleRate()));
					recFile.setBigendian(af.isBigEndian());
				}

				
				List<RecordingFile> rfs = null;
				if (recording != null) {
					q = entityManager.createQuery(
							"SELECT rF FROM RecordingFile AS rf,Recording AS r WHERE r = :recording AND rf MEMBER OF r.recordingFiles AND rf.session = :session");
					q.setParameter("recording", recording);
					q.setParameter("session", s);
					
					rfs = q.getResultList();
				}
				// String signalFile=null;
				if (overwrite) {
					// overwrite
					if (rfs == null || rfs.size() == 0) {
						recFile.setSignalFile(
								createSignalFilePath(sessionDir, speakerCode, itemCode, extension, recFile, overwrite));
						entityManager.persist(recFile);
						recFile.setSession(s);
						s.getRecordingFiles().add(recFile);
						entityManager.merge(s);
						entityManager.merge(recFile);
					} else {
						// Hmm. Not really correct.
						RecordingFile rf = (RecordingFile) rfs.get(0);
						Integer version = rf.getVersion();
						if (version != null) {
							recFile.setVersion(version++);
						} else {
							recFile.setVersion(0);
						}
						recFile.setRecordingFileId(rf.getRecordingFileId());

						recFile.setSignalFile(
								createSignalFilePath(sessionDir, speakerCode, itemCode, extension, recFile, overwrite));
						// overwrite by merge
						entityManager.merge(recFile);
					}
				} else {
					int version = 0;
					if (rfs != null) {
						for (RecordingFile rf : rfs) {
							Integer sVersion = rf.getVersion();
							if (sVersion != null) {
								if (sVersion >= version)
									version = sVersion + 1;
							}
						}
					}
					recFile.setVersion(version);
					recFile.setSignalFile(
							createSignalFilePath(sessionDir, speakerCode, itemCode, extension, recFile, overwrite));
					entityManager.persist(recFile);
					recFile.setSession(s);
					s.getRecordingFiles().add(recFile);
					entityManager.merge(s);
					entityManager.merge(recFile);
				}

				if (recFile == null) {
					rollBackAndClose(entityManager);
					tempAudioFile.delete();
					throw new IOException("Could not generate database entry !");
				}
				URL signalFile = new URL(recFile.getSignalFile());

				File storeFile = null;
				if (signalFile.getProtocol().equalsIgnoreCase("file")) {
					// copy File
					FileInputStream fis = null;
					try {
						storeFile = new File(signalFile.getFile());
						fis = new FileInputStream(tempAudioFile);
						storeToFile(fis, storeFile, false);
						fis.close();
						recFile.setStatus(RecordingFile.Status.RECORDED);
						// tempAudioFile.delete();
					} catch (IOException ioe) {
						rollBackAndClose(entityManager);
						throw ioe;
					} finally {
						if (fis != null) {
							fis.close();
						}
					}

					// DSPProcessor.notifyThread();
				} else {
					// tempAudioFile.delete();
					rollBackAndClose(entityManager);
					throw new IOException("Cannot store URL " + signalFile + "\nOnly protocol file: is supported");
				}
				try {
					// recFileContr.commit();
					tx.commit();
					// notify the DSP processor about new recording file
					DSPProcessor.notifyThread();
					// empty JSON to make Angular HttpClient happy
					response.getWriter().append("{}");
				} catch (Exception e) {
					rollBackAndClose(entityManager);
					throw new IOException("Could not store recording file metadata to database !");
				} finally {
					// recFileContr.close();

					tempAudioFile.delete();
				}

			} else {
				response.sendError(404);
			}

		} else {
			response.sendError(404);
		}

		entityManager.close();

	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		// TODO Disabled for debugging !!!
		//checkSecurity(request, response);
		
		Document d = null;
		String reqPath = request.getPathInfo();
		List<MIMEType> reqMimes = null;
		String accHeader = request.getHeader("Accept");
		response.setCharacterEncoding("UTF-8");
		MIMEType reqAccType = null;
		if (accHeader == null) {
			// default JSON
			reqAccType = MIMEType.APPLICATION_JSON;
		} else {
			try {
				reqMimes = MIMEUtils.parseMediaRange(accHeader);
			} catch (ParserException e) {
				log(e.getMessage());
				response.sendError(500, "Error parsing accept header.");
			}
		}
		// Remove redundant slashes for path compare
		String restfulPath = reqPath.replaceAll("/{2,}", "/");
		entityManager = EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		if (restfulPath.startsWith("/project/")) {
			String projectId = restfulPath.replaceFirst("/project/", "");
			projectId.replaceFirst("/$", "");
			Project p = null;
			if (projectId != null && !projectId.equals("")) {
				p = entityManager.find(Project.class, projectId);
			} else {
				// request by session ID
				String sessionIdStr = request.getParameter("sessionId");
				if (sessionIdStr != null) {
					int sessionId = Integer.parseInt(sessionIdStr);
					Session s = entityManager.find(Session.class, sessionId);
					p = s.getProject();
				}
			}
			// securityManager.checkReadPermission(request, s);
			if (reqAccType == null) {
				// check Accept header for matching MIMEs
				// MIMEType[] suppMts = new MIMEType[] { MIMEType.TEXT_XML };
				MIMEType[] suppMts = new MIMEType[] { MIMEType.APPLICATION_JSON, MIMEType.TEXT_XML };
				reqAccType = MIMEUtils.preferredMimeType(Arrays.asList(suppMts), reqMimes);
			}
			if (reqAccType == null) {
				response.sendError(406, "Unsupported MIME type");
			} else {
				if (MIMEType.TEXT_XML.equals(reqAccType)) {
					DOMCodec dc;
					try {
						dc = new DOMCodec(Session.class.getPackage());
						d = dc.createDocument(p);
					} catch (DOMCodecException e) {
						throw new ServletException(e);
					}
					useDomconverter(response, d);
				} else if (MIMEType.APPLICATION_JSON.equals(reqAccType)) {
					Marshaller marshaller;
					try {

						JAXBContext jc = jaxbContext = org.eclipse.persistence.jaxb.JAXBContextFactory
								.createContext(new Class[] { Session.class }, jaxbEclipseLinkPropsmap);
						marshaller = jc.createMarshaller();

						marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
						marshaller.setProperty("eclipselink.media-type", "application/json");
						marshaller.marshal(p, response.getWriter());
						// unmarshaller.setProperty("eclipselink.json.include-root",
						// false);
					} catch (JAXBException e) {
						throw new ServletException(e);
					}
				}
			}

		} else if (restfulPath.startsWith("/session/")) {
			String sessionIdStr = restfulPath.replaceFirst("/session/", "");
			sessionIdStr.replaceFirst("/$", "");
			int sessionId = Integer.parseInt(sessionIdStr);
			Session s = entityManager.find(Session.class, sessionId);

//			// TODO very dirty TEST workaround to set script to session
//			// should not be here
//			// This is not REST ful !
//			if (s.getScript() == null) {
//				SessionController sc = new SessionController();
//				entityManager.getTransaction().begin();
//				Script scr = sc.setScriptWithLowestUsageForSession(s.getSessionId());
//				s.setScript(scr);
//				scr.getSessionsSet().add(s);
//				entityManager.merge(s);
//				entityManager.merge(scr);
//				entityManager.getTransaction().commit();
//
//			}
			// securityManager.checkReadPermission(request, s);
			if (reqAccType == null) {
				// check Accept header for matching MIMEs
				// MIMEType[] suppMts = new MIMEType[] { MIMEType.TEXT_XML };
				MIMEType[] suppMts = new MIMEType[] { MIMEType.APPLICATION_JSON, MIMEType.TEXT_XML };
				reqAccType = MIMEUtils.preferredMimeType(Arrays.asList(suppMts), reqMimes);
			}
			if (reqAccType == null) {
				response.sendError(406, "Unsupported MIME type");
			} else {
				if (MIMEType.TEXT_XML.equals(reqAccType)) {
					DOMCodec dc;
					try {
						dc = new DOMCodec(Session.class.getPackage());
						d = dc.createDocument(s);
					} catch (DOMCodecException e) {
						throw new ServletException(e);
					}
					useDomconverter(response, d);
				} else if (MIMEType.APPLICATION_JSON.equals(reqAccType)) {
					Marshaller marshaller;
					try {

						JAXBContext jc = jaxbContext = org.eclipse.persistence.jaxb.JAXBContextFactory
								.createContext(new Class[] { Session.class }, jaxbEclipseLinkPropsmap);
						marshaller = jc.createMarshaller();

						marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
						marshaller.setProperty("eclipselink.media-type", "application/json");
						marshaller.marshal(s, response.getWriter());
						// unmarshaller.setProperty("eclipselink.json.include-root",
						// false);
					} catch (JAXBException e) {
						throw new ServletException(e);
					}
				}
			}

		} else if (restfulPath.startsWith("/script/")) {
			String scriptIdStr = restfulPath.replaceFirst("/script/", "");
			scriptIdStr.replaceFirst("/$", "");
			if ("".equals(scriptIdStr)) {
				Query q = entityManager.createQuery("SELECT sc FROM " + Script.class.getSimpleName() + " sc");
				@SuppressWarnings("unchecked")
				List<Script> sList = q.getResultList();
				// TODO Test JSON
				PrintWriter pw = response.getWriter();
				pw.println("{ scripts: [");
				for (Script sc : sList) {
					pw.println("{ id: " + sc.getScriptId() + " }");
				}
				pw.println("] }");
			} else {
				int scriptId = Integer.parseInt(scriptIdStr);
				Script sc = entityManager.find(Script.class, scriptId);
				try {
					securityManager.checkReadPermission(request, sc);
					if (reqAccType == null) {
						// check Accept header for matching MIMEs
						MIMEType[] suppMts = new MIMEType[] { MIMEType.TEXT_XML, MIMEType.APPLICATION_JSON };
						reqAccType = MIMEUtils.preferredMimeType(Arrays.asList(suppMts), reqMimes);
					}
					if (reqAccType == null) {
						response.sendError(406, "Unsupported MIME type");
					} else {
						response.setContentType(reqAccType.toString());
						if (MIMEType.TEXT_XML.equals(reqAccType) || MIMEType.APPLICATION_XML.equals(reqAccType)) {

							response.setContentType(reqAccType.toString());
//							// Speechrecorder has its own XML conversion methods
//							RecscriptHandler rsh = new RecscriptHandler();
//							try {
//								rsh.writeXML(sc, response.getWriter());
//							} catch (DOMConverterException | ParserConfigurationException e) {
//								log(e.getMessage());
//								response.sendError(500);
//							}
							
							Marshaller marshaller;
							try {
							JAXBContext jc = jaxbContext();
							marshaller = jc.createMarshaller();

							marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
							marshaller.setProperty("eclipselink.media-type", "application/xml");
							marshaller.marshal(sc, response.getWriter());
							if(DEBUG){
								StringWriter sw=new StringWriter();
								marshaller.marshal(sc, sw);
								log("Script:\n"+sw.toString());
							}
							} catch (JAXBException e) {
								throw new ServletException(e);
							}
							
							
						} else if (MIMEType.APPLICATION_JSON.equals(reqAccType)) {
							Marshaller marshaller;
							try {

								JAXBContext jc = jaxbContext();
								marshaller = jc.createMarshaller();

								marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
								marshaller.setProperty("eclipselink.media-type", "application/json");
								marshaller.marshal(sc, response.getWriter());
								if(DEBUG){
									StringWriter sw=new StringWriter();
									marshaller.marshal(sc, sw);
									log("Script:\n"+sw.toString());
								}
								// unmarshaller.setProperty("eclipselink.json.include-root",
								// false);
							} catch (JAXBException e) {
								throw new ServletException(e);
							}
						}
					}

				} catch (PermissionDeniedException e1) {
					response.sendError(403);
				}
			}
		} else {
			response.sendError(404);
		}

		entityManager.close();

	}

	private void rollBackAndClose(EntityManager em) {
		if (em != null) {
			EntityTransaction tr = em.getTransaction();
			if (tr != null && tr.isActive()) {
				tr.rollback();
			}
			if (em.isOpen()) {
				em.close();
			}
		}
	}

	@Override
	public EntityManager getThreadEntityManager() {
		return entityManager;
	}

}
