package ipsk.webapps.db.speech;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.jsp.PageContext;

import ipsk.awt.ProgressListener;
import ipsk.awt.ProgressWorker;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.io.FileUtils;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.persistence.EntityManagerProviderImpl;
import ipsk.text.MediaTimeFormat;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import ipsk.webapps.BasicController;
import ipsk.webapps.BasicPersistenceController;
import ipsk.webapps.ControllerException;



/**
 * Session bean to control the export thread
 * @author klausj
 *
 */
public abstract class BasicExportController extends BasicController implements HttpSessionBindingListener{
	
	public final static String CMD_START="start";
	public final static String CMD_CANCEL="cancel";
	public final static String CMD_UPDATE_VIEW="update_view";
	public final static String CMD_UPDATE_VIEW_AJAX="update_view_ajax";
	//public final static String CMD_KEY="_cmd";
	
	protected volatile Boolean cancel=false;

	//protected Thread exportThread;
	
	protected ProgressWorker worker;
	protected File exportBaseDir;
	protected File exportDir;
	protected File exportArchiveFile;
	protected String exportArchivePath;
	
	protected String message="";
	
	protected File sessionTempDir=null;
	protected MediaTimeFormat elapsedTimeFormat;
	protected PageContext ajaxPageContext;
	private ServletContext servletContext;
	private EntityManagerProviderImpl emProv=null;
	
	public EntityManager getThreadEntityManager() {
		return emProv.getThreadEntityManager();
	}

	public void removeEntityManagerThreadLocal() {
		emProv.removeEntityManagerThreadLocal();
	}

	public BasicExportController(){
		super();
		emProv=new EntityManagerProviderImpl();
	//worker=new ProgressWorker("WikiSpeech export thread");
		elapsedTimeFormat=new MediaTimeFormat();
		elapsedTimeFormat.setShowMilliSeconds(false);
	}
	
	public void setServletContext(ServletContext servletContext){
		this.servletContext=servletContext;
	}
	
	public abstract void processRequest(HttpServletRequest request)
	throws ControllerException;


	
//	public String getStatusMessage(){
//		return worker.getStatus().toString()+message;
//	}
	public String getStatusMessage(){
		//return status.toString()+message;
		Locale loc=LocaleSupport.getLocale(ajaxPageContext);
//		ResourceBundle rb;
//		if(currentRequest!=null){
//			loc=currentRequest.getLocale();
////			rb=ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, loc);
//		}else{
////			rb=ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME);
//		}
		StringBuffer msg=new StringBuffer();
		ProgressStatus ps=worker.getProgressStatus();
		Worker.State status=worker.getStatus();
		
		
		if(status.equals(Worker.State.CANCEL)){
			msg.append(ps.getPercentProgress());
			msg.append(" %");
			msg.append(LocaleSupport.getLocalizedMessage(ajaxPageContext, "canceling"));
			msg.append("...");
		}else if(status.equals(Worker.State.ERROR)){
			String progressMessage=ps.getMessage().localize(loc);

			if(progressMessage!=null){
				msg.append("ERROR: ");
				msg.append(progressMessage);
			}else{
				msg.append("ERROR.");
			}
		}else if(status.equals(Worker.State.CANCELLED)){
			String s=LocaleSupport.getLocalizedMessage(ajaxPageContext, "canceled");
			msg.append(s);
			msg.append(". ");
		}else{
			msg.append(ps.getPercentProgress());
			msg.append(" %");
			LocalizableMessage progressMessage=ps.getMessage();
			if(progressMessage!=null){
				msg.append(", ");
				msg.append(progressMessage.localize(loc));
			}

			Long elapsedTime =ps.elapsedTimeMillis();
			if(elapsedTime!=null){
				String s=LocaleSupport.getLocalizedMessage(ajaxPageContext, "time.elapsed");
				msg.append(", "+s+": ");
				msg.append(elapsedTimeFormat.format(elapsedTime*1000*1000));
			}
			Date estimatedFinishTime =ps.estimatedFinishTime();
			if(estimatedFinishTime!=null){
				DateFormat df;
				if(loc!=null){
					df=DateFormat.getTimeInstance(DateFormat.MEDIUM,loc);
				}else{
					df=DateFormat.getTimeInstance(DateFormat.MEDIUM);
				}
				msg.append(", ");
				String s=LocaleSupport.getLocalizedMessage(ajaxPageContext, "time.finish.estimated");
				msg.append(s);
				msg.append(": ");
				msg.append(df.format(estimatedFinishTime));
			}
		}
		return msg.toString();
	}
	

	public File getExportDir() {
		return exportDir;
	}

	public void setExportDir(File exportDir) {
		this.exportDir = exportDir;
	}



	public String getCommand(){
		if(getBusy()){
			return CMD_CANCEL;
		}else {
			return CMD_START;
		}
	}
	
	public boolean getBusy(){
		Worker.State status=worker.getStatus();
		if(status.equals(Worker.State.INIT) || status.equals(Worker.State.CLOSED) || status.equals(Worker.State.DONE) || status.equals(Worker.State.ERROR) || status.equals(Worker.State.CANCELLED)){
			return false;
		}else {
			return true;
		}
	}
	
	public boolean isDone(){
		Worker.State status=worker.getStatus();
		return (status.equals(Worker.State.CLOSED) || status.equals(Worker.State.DONE));
	}

	public void addProgressListener(ProgressListener progressListener) {
		worker.addProgressListener(progressListener);
	}

	public void cancel() {
		worker.cancel();
	}

//	public void close() throws WorkerException {
//		worker.close();
//	}

	public Worker.State getStatus() {
		return worker.getStatus();
	}

//	public void open() throws WorkerException {
//		worker.open();
//	}

	public void removeProgressListener(ProgressListener progressListener) {
		worker.removeProgressListener(progressListener);
	}

	public void start() {
		worker.start();
	}
	
	public String getExportArchivePath() {
		return exportArchivePath;
	}


	public void setExportArchivePath(String exportArchivePath) {
		this.exportArchivePath = exportArchivePath;
	}

	public PageContext getAjaxPageContext() {
		return ajaxPageContext;
	}


	public void setAjaxPageContext(PageContext ajaxPageContext) {
		this.ajaxPageContext = ajaxPageContext;
	}
	
	
	public void valueBound(HttpSessionBindingEvent event) {
		// nothing to do for now
	}


	public void valueUnbound(HttpSessionBindingEvent event) {
		cancel();
		
		if(worker!=null){
			try {
				//Note: close method of worker 
				worker.close();
			} catch (WorkerException e) {
				// thread might be still running at this point 
			}
		}
		// Note: close method of controller
		//close();
		if(sessionTempDir!=null){
			FileUtils.deleteRecursive(sessionTempDir);
		}
	}
	
	
}