package ipsk.webapps.db.speech;

import java.util.Locale;

import ipsk.db.speech.LocalizableMessage;
import ipsk.db.speech.LocalizedMessage;
import ipsk.webapps.BasicPersistenceBeanController;

public class LocalizableMessageController extends BasicPersistenceBeanController<LocalizableMessage> {
	
	public LocalizableMessageController() {
		super("WebSpeechDBPU",LocalizableMessage.class, "localizable_message");
		securityManager=new AdminSecurityManager();
	}
	public LocalizableMessageController(String persistenceUnit, String jsfIdentifier) {
		super(persistenceUnit, LocalizableMessage.class, jsfIdentifier);
		securityManager=new AdminSecurityManager();
	}
	
	
	String[] getISOLanguageCodeList(){
		return Locale.getISOLanguages();
		
	}
	
}
