package ipsk.webapps.db.speech;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import ipsk.apps.speechrecorder.storage.SessionStorageManager;
import ipsk.beans.BeanModel;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Account;
import ipsk.db.speech.AudioDevice;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.Project.ScriptSelectionMode;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.SpeechRecorderClient;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.io.StreamCopy;
import ipsk.net.UploadCache;
import ipsk.persistence.OrderBy;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.QueryParam;
import ipsk.sql.JoinClause;
import ipsk.sql.OrderByClause;
import ipsk.util.LocalizableMessage;
import ipsk.util.zip.ZipPacker;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
//import ipsk.webapps.audio.AudioSystemWrapper;
import ipsk.webapps.db.speech.script.ScriptController;
import ipsk.webapps.db.speech.validation.NotSingleSessionPropertyValidationError;
import ipsk.webapps.db.speech.validation.SessionAlreadyStartedPropertyValidationError;

public class SessionController extends BasicWikiSpeechController<Session> {
	
	public static final String RECORDER_HTML5_BASE_HREF="/lib/ng/recorder";
	public static final String RECORDER_DEFAULT_BASE_HREF=RECORDER_HTML5_BASE_HREF;
	
	public static final String SPEECHRECORDER_HTML5_BASE_HREF="/lib/ng";
	public static final String SPEECHRECORDER_DEFAULT_BASE_HREF=SPEECHRECORDER_HTML5_BASE_HREF;
	
	public static String DEF_SESSION_ID_FORMAT="0000";
	public static DecimalFormat sessionIDFormat=new DecimalFormat(DEF_SESSION_ID_FORMAT);
	private Session session;

	public SessionController() {
		super("WebSpeechDBPU", Session.class, "session");
		securityManager=new WikiSpeechSecurityManager(this);
		OrderByClause defaultOrderByClause=new OrderByClause(new OrderBy[]{new OrderBy("date",true)});
		setOrderByClause(defaultOrderByClause);
	}

//	protected void setPropertiesOnNew(Object bean) {
//		super.setPropertiesOnNew(bean);
//		if(bean instanceof Session) {
//			Session session=(Session)bean;
//			session.setUuid(UUID.randomUUID().toString());
//		}
//	}

	
	public Session getById(int id) {
		return (Session)super.getById(id);
	}
	
	public static String createSessionFilePath(String basePath,int sessionId){
		String session=sessionIDFormat.format(sessionId);
		
		return basePath+"/"+session;
	}
	
//	public void sessionsByAccount(HttpServletRequest req)
//			throws ControllerException {
//		Project selProject=getSelectedProject(req);
//		if(selProject==null) {
//			allSessionsByAccount(req);
//		}else {
//			sessionsOfSelectedProjectByAccount(req);
//		}
//	}
//	
	public void allSessionsByAccount(HttpServletRequest req)
	throws ControllerException {
//		EntityManager em = getThreadEntityManager();
		Account acc = getAccountByRequest(req);
		//Project selProject=getSelectedProject(req);
		createEmptyBeanTableModel(req);
		if (acc == null)
			return;
		if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())){
			ParameterizedQuery pq = new ParameterizedQuery(queryType);
			String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;

			pq
			.setWhereClause("(EXISTS (SELECT pr FROM Project pr WHERE :account MEMBER OF pr.adminAccounts AND "
					+ jse + ".project = pr))");
			pq.setQueryParams(new QueryParam[] { new QueryParam("account", acc) });

			setParameterizedQuery(pq);
			processListRequest(req);
		}else if(req.isUserInRole(UserRoleId.RoleName.ORGANISATION.name())){
			ParameterizedQuery pq = new ParameterizedQuery(queryType);
			String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
			
			pq.setWhereClause("(EXISTS (SELECT sp FROM Speaker sp WHERE :organisation MEMBER OF sp.organisations AND sp MEMBER OF " + jse + ".speakers))");
			pq.setQueryParams(new QueryParam[] { new QueryParam("organisation", acc.getOrganisation()) });

			setParameterizedQuery(pq);
			processListRequest(req);
		}else if(req.isUserInRole(UserRoleId.RoleName.SUBJECT.name())){
			ParameterizedQuery<Session> pq = new ParameterizedQuery<Session>(queryType);
			String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
			Person p=acc.getPerson();
			JoinClause pqJc=new JoinClause(JoinClause.Type.LEFT,jse+".speakers spk");
			pq.setJoinClause(pqJc);
			//pq.setWhereClause(":person MEMBER OF "+ jse + ".speakers");
			// Add sessions of project bound speaker data as well 
			pq.setWhereClause("spk IN  (SELECT spk FROM Speaker spk WHERE :acc= spk.speakerDataAccount OR :person=spk)");
			pq.setQueryParams(new QueryParam[] { new QueryParam("acc", acc),new QueryParam("person", p)});
			setParameterizedQuery(pq);
			processListRequest(req);
		}
	}
	
//	public void sessionsOfSelectedProjectByAccount(HttpServletRequest req)
//			throws ControllerException {
////				EntityManager em = getThreadEntityManager();
//				Account acc = getAccountByRequest(req);
//				Project selProject=getSelectedProject(req);
//				createEmptyBeanTableModel(req);
//				if (acc == null)
//					return;
//				if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name()) && (selProject==null)){
//					ParameterizedQuery pq = new ParameterizedQuery(queryType);
//					String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
//
//					pq
//					.setWhereClause("(EXISTS (SELECT pr FROM Project pr WHERE :account MEMBER OF pr.adminAccounts AND "
//							+ jse + ".project = pr))");
//					pq.setQueryParams(new QueryParam[] { new QueryParam("account", acc) });
//
//					setParameterizedQuery(pq);
//					processListRequest(req);
//				}else if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name()) && (selProject!=null) && (selProject.getAdminAccounts().contains(acc))){
//					ParameterizedQuery pq = new ParameterizedQuery(queryType);
//					String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
//
//					pq
//					.setWhereClause("(EXISTS (SELECT pr FROM Project pr WHERE :account MEMBER OF pr.adminAccounts AND "
//							+ jse + ".project = pr AND "+jse+".project = :selProject))");
//					pq.setQueryParams(new QueryParam[] { new QueryParam("account", acc),new QueryParam("selProject",selProject)});
//
//
//					setParameterizedQuery(pq);
//					processListRequest(req);
//				}else if(req.isUserInRole(UserRoleId.RoleName.ORGANISATION.name())){
//					ParameterizedQuery pq = new ParameterizedQuery(queryType);
//					String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
//					//pq.setWhereClause("(EXISTS (SELECT sp FROM Speaker sp WHERE :organisation MEMBER OF sp.organisations AND sp MEMBER OF " + jse + ".speakers))");
//					pq.setWhereClause("(EXISTS (SELECT sp FROM Speaker sp WHERE :organisation MEMBER OF sp.organisations AND sp MEMBER OF " + jse + ".speakers)) AND "+jse+".project = :selProject");
//					pq.setQueryParams(new QueryParam[] { new QueryParam("organisation", acc.getOrganisation()),new QueryParam("selProject",selProject) });
//
//					setParameterizedQuery(pq);
//					processListRequest(req);
//				}else if(req.isUserInRole(UserRoleId.RoleName.SUBJECT.name())){
//					ParameterizedQuery pq = new ParameterizedQuery(queryType);
//					String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
//					Person p=acc.getPerson();
//					pq.setWhereClause(":person MEMBER OF "+ jse + ".speakers AND "+jse+".project = :selProject");
//					pq.setQueryParams(new QueryParam[] { new QueryParam("person", p),new QueryParam("selProject",selProject)});
//					setParameterizedQuery(pq);
//					processListRequest(req);
//				}
//			}
	
	public Set<Speaker> getSpeakersBySessionId(int sessionId) {
		EntityManager em = getThreadEntityManager();
//		EntityTransaction tx = null;
//		tx = em.getTransaction();
//		tx.begin();
		Session s = em.find(Session.class, sessionId);
		Set<Speaker> spks = s.getSpeakers();
		//tx.commit();
		return spks;
	}

	public Session storeSessionForSpeaker(String projectName,Speaker sp, Session.Type type) {
		EntityManager em = getThreadEntityManager();
//		EntityTransaction tx = null;
//		try {
//			tx = em.getTransaction();
//			tx.begin();
			//Speaker sp2 = em.find(Speaker.class, sp.getPersonId());
			Set<Speaker> spSet = new HashSet<Speaker>();
			spSet.add(sp);
			if(projectName!=null){
			Project project=em.find(Project.class, projectName);
			session.setProject(project);
			}
			session.setSpeakers(spSet);
			Set<Session> spSess=sp.getSessions();
			spSess.add(session);
			sp.setSessions(spSess);
			session.setType(type);

			session.setDate(new Date());
			em.persist(session);
			em.merge(sp);
//			tx.commit();
//		} catch (PersistenceException e) {
//			e.printStackTrace();
//			if (tx != null && tx.isActive())
//				tx.rollback();
//			em.close();
//			throw e;
//		}
		return session;
	}

	public Session storeSessionForSpeaker(Speaker sp) {

		return storeSessionForSpeaker(null,sp, Session.Type.NORM);
	}
	
	public Session storeSessionForSpeaker(String projectName,Speaker sp) {

		return storeSessionForSpeaker(projectName,sp, Session.Type.NORM);
	}


	@SuppressWarnings("unchecked")
	public List<ipsk.db.speech.Session> getSessions() {
		EntityManager em = getThreadEntityManager();
		EntityTransaction tx = null;
		List<ipsk.db.speech.Session> list = null;
		try {
			tx = em.getTransaction();
			tx.begin();
			Query q = em.createQuery("select object(o) from Session as o");
			q.setMaxResults(batchSize);
			q.setFirstResult(firstItem);
			list = q.getResultList();
			tx.commit();
		} catch (PersistenceException e) {
			e.printStackTrace();
			if (tx != null && tx.isActive())
				tx.rollback();
			em.close();
			throw e;
		}

		return list;
	}

	public void newSession() {
		this.session = new Session();

	}
	
	
	public boolean getManualScriptSelection() {
		Project prj=getSelectedProject();
		ScriptSelectionMode ssm=prj.getScriptSelectionMode();
		boolean manual=(ScriptSelectionMode.MANUAL.equals(ssm));
		return manual;
	}
	
	public Set<Script> getActiveScriptsBySelectedProject() {
		Project selProject=getSelectedProject();
		return selProject.getScripts();
	}
	
	public List<Script> getActiveScriptsBySelectedProjectSortedByNameAndId() {
		Project selProject=getSelectedProject();
		Set<Script> selScriptsSet=selProject.getScripts();
		List<Script> selSortedScripts=new ArrayList<Script>(selScriptsSet);
		selSortedScripts.sort((Script s1, Script s2) -> {
			int c=0;
			String s1Nm=s1.getName();
			String s2Nm=s2.getName();
			int s1Id=s1.getScriptId();
			int s2Id=s2.getScriptId();
			if(s1Nm!=null) {
				if(s2Nm!=null) {
					int strC=s1Nm.compareTo(s2Nm);
					if(strC==0) {
						// sub compare ID
						c=s1Id-s2Id;
					}else {
						c=strC;
					}
				}else {
					// Script s1 with name first
					c=-1;
				}
			}else {
				if(s2Nm!=null) {
					// Script s2 with name first
					c=1;
				}else {
					// Both scripts have no name, compare by ID
					c=s1Id-s2Id;
				}
			}
			return c;
		});
		return selSortedScripts;
	}
	
	
	
	/**
	 * Checks if session is already started, sets session status to started, creates session model.
	 * @throws ControllerException 
 */
	
	public void startRecording(HttpServletRequest request) throws ControllerException{
		currentRequest=request;
		clear();
		EntityManager em = getThreadEntityManager();
		Map<String,String[]> map = request.getParameterMap();
		Object idObj = createIdObject(map);
		Session sess = (Session)em.find(queryType, idObj);
		if(!sess.getStatus().equals(Session.Status.CREATED)){
			// session is already started
			
			ValidationResult vr=new ValidationResult();
			vr.putPropertyValidationResult("status",new SessionAlreadyStartedPropertyValidationError());
			vr.setType(ValidationResult.Type.ERRORS);
			
			beanModel=new BeanModel<Session>(sess,vr);
			processResult=new ProcessResult(vr);
		}else{
			// OK
			processRequest(request);
		}
	}
	
	public static final String CACHED_MISSING_RECORDING_ITEMS_NAME="CACHED_MISSING_RECORDING_ITEMS_NAME";
	public static final String CACHED_MAX_LEVEL_NAME="CACHED_MAX_LEVEL_NAME";
	
	public static void invalidateCachedValues(ServletContext sc,int sessionId) {
		// Invalidate missing recording items cache
		Map<Integer,List<Recording>> cmrim=null;
		Object cmrimo=sc.getAttribute(SessionController.CACHED_MISSING_RECORDING_ITEMS_NAME);
		if(cmrimo instanceof Map) {
			@SuppressWarnings("unchecked")
			Map<Integer,List<Recording>> cmrimoc = (Map<Integer,List<Recording>>)cmrimo;
			cmrim=cmrimoc;
		}
		if(cmrim!=null) {
			// invalidate by setting to null
			cmrim.put(sessionId, null);
		}
		
		Map<Integer,Double> mlm=null;
		Object mlmo=sc.getAttribute(SessionController.CACHED_MAX_LEVEL_NAME);
		if(mlmo instanceof Map) {
			@SuppressWarnings("unchecked")
			Map<Integer,Double> mlmoc = (Map<Integer,Double>)mlmo;
			mlm=mlmoc;
		}
		if(mlm!=null) {
			// invalidate by setting to null
			mlm.put(sessionId, null);
		}
	}
	
	@SuppressWarnings("unchecked")
	public Double getMaxLevel(Session s){
		Double ml=null;
		if(currentRequest==null) {
			ml=s.getMaxLevel();
		}else {
			ServletContext ctx=currentRequest.getServletContext();
			Map<Integer,Double> mlm=null;
			Object mlmo=ctx.getAttribute(CACHED_MAX_LEVEL_NAME);
			if(mlmo==null) {
				mlm=new HashMap<Integer,Double>();
				ctx.setAttribute(CACHED_MAX_LEVEL_NAME,mlm);
			}else if(mlmo instanceof Map) {
				mlm=(Map<Integer,Double>)mlmo;
			}
				
			if(mlm!=null) {
				ml=mlm.get(s.getSessionId());
				if(ml==null) {
					ml=s.getMaxLevel();
					mlm.put(s.getSessionId(), ml);
				}
			}else {
				ml=s.getMaxLevel();
			}
		}
		return ml;
	}
	
	@SuppressWarnings("unchecked")
	public List<Recording> getMissingRecordingItems(Session s){
		List<Recording> cmri=null;
		if(currentRequest==null) {
			cmri=s.getMissingRecordingItems();
		}else {
			ServletContext ctx=currentRequest.getServletContext();
			Map<Integer,List<Recording>> cmrim=null;
			Object cmrimo=ctx.getAttribute(CACHED_MISSING_RECORDING_ITEMS_NAME);
			if(cmrimo==null) {
				cmrim=new HashMap<Integer,List<Recording>>();
				ctx.setAttribute(CACHED_MISSING_RECORDING_ITEMS_NAME,cmrim);
			}else if(cmrimo instanceof Map) {
				cmrim=(Map<Integer,List<Recording>>)cmrimo;
			}
				
			if(cmrim!=null) {
				cmri=cmrim.get(s.getSessionId());
				if(cmri==null) {
					cmri=s.getMissingRecordingItems();
					cmrim.put(s.getSessionId(), cmri);
				}
			}else {
				cmri=s.getMissingRecordingItems();
			}
		}
		return cmri;
	}
	
	
	public List<String> getJavaAudioExtensions() throws ControllerException{
		List<String> extList=new ArrayList<String>();
		Session s=getSession();
		Project p=s.getProject();
		if(p!=null){
			List<AudioDevice> ads=p.getAudioDevices();
			for(AudioDevice ad:ads){
				String jExt=ad.getJextension();
				if(jExt!=null){
					extList.add(jExt);
				}
			}
		}
		return extList;
	}

	/**
	 * Creates debug session, sets session status to started, creates session model.
	 * @throws ControllerException 
 */
	public Session startDebugRecording(HttpServletRequest request) throws ControllerException{
		clear();
		EntityManager em = getThreadEntityManager();
		Session sess=new Session();
		sess.setType(Session.Type.TEST);
		sess.setCode("DEBUG");
		sess.setStatus(Session.Status.CREATED);
		em.persist(sess);
		ValidationResult vr=new ValidationResult();
		vr.setType(ValidationResult.Type.SUCCESS);
		beanModel=new BeanModel<Session>(sess,vr);
		processResult=new ProcessResult(vr);
		return sess;
	}

//	public Object getEditObject() {
//		return session;
//	}

	public Session getSession() throws ControllerException {
		return (Session)getItem();
	}

//	public void setSession(Session session) {
//		this.session = session;
//	}
	
	public List<Script> selectedProjectScriptsSortedByLowestUsageOld() {
		Project project=getSelectedProject();
		if(project!=null){
			EntityManager em = getThreadEntityManager();
			CriteriaBuilder cb = em.getCriteriaBuilder();
			CriteriaQuery<Script> cq = cb.createQuery(Script.class);
			Root<Script> scr = cq.from(Script.class);
			cq.select(scr);
			Predicate scriptofProjectPred=cb.isMember(project, scr.<Collection<Project>>get("projects"));
			Predicate notSinusTestExp=cb.notEqual(scr.<String>get("name"),"Sinus-Test");
			cq.where(cb.and(scriptofProjectPred, notSinusTestExp));
			cq.orderBy(cb.asc(cb.size(scr.<Collection<Session>>get("sessions"))));
			TypedQuery<Script> q = em.createQuery(cq);
			//q.setMaxResults(100);
			List<Script> resultList = q.getResultList();

			if (resultList.isEmpty())
				return null;
			else
				return resultList;
		}else{
			return null;
		}
	}
	
	public int countSessionsOfScript(Script script,boolean testSessions) {
		int sessCnt=0;
		Set<Session> sesss=script.getSessions();
		for(Session sess:sesss) {
			Session.Type sessType=sess.getType();
			boolean isNorm=Session.Type.NORM.equals(sessType);
			if(isNorm) {
				if(!testSessions) {
					sessCnt++;
				}
			}else {
				if(testSessions) {
					sessCnt++;
				}
			}
		}
		return sessCnt;
	}
	
	
	public List<Script> selectedProjectScriptsSortedByLowestUsage(boolean test) {
		Project project=getSelectedProject();
		if(project!=null){
			EntityManager em = getThreadEntityManager();
			CriteriaBuilder cb = em.getCriteriaBuilder();
			CriteriaQuery<Script> cq = cb.createQuery(Script.class);
			Root<Script> scr = cq.from(Script.class);
			
			Predicate scriptofProjectPred=cb.isMember(project, scr.<Collection<Project>>get("projects"));
			Predicate notSinusTestExp=cb.notEqual(scr.<String>get("name"),"Sinus-Test");
			cq.where(cb.and(scriptofProjectPred, notSinusTestExp));
			
			cq.select(scr);
			TypedQuery<Script> q = em.createQuery(cq);
			
			List<Script> resultList = q.getResultList();

			resultList.sort(new Comparator<Script>() {

				@Override
				public int compare(Script o1, Script o2) {
					int o1NormSessCnt;
					int o2NormSesscnt;
					
					o1NormSessCnt=countSessionsOfScript(o1,test);
					o2NormSesscnt=countSessionsOfScript(o2,test);
					
					return (o1NormSessCnt-o2NormSesscnt);
				}
				
			});
			
//			for(Script script:resultList) {
//					System.out.println(script.getScriptId()+" norm sessions:"+countNormSessionsOfScript(script));
//			}
			
			if (resultList.isEmpty())
				return null;
			else
				return resultList;
		}else{
			return null;
		}
	}
	
	
	
	public Script getSelectedProjectScriptWithLowestUsage(){
		List<Script> scripts=selectedProjectScriptsSortedByLowestUsage(false);
		if(scripts!=null && scripts.size()>0){
			return scripts.get(0);
		}
		
		return null;
	}
	
	public Script getSelectedProjectScriptWithLowestTestUsage(){
		List<Script> scripts=selectedProjectScriptsSortedByLowestUsage(true);
		if(scripts!=null && scripts.size()>0){
			return scripts.get(0);
		}
		
		return null;
	}
	
	public Script setScriptForSession(int sessionId,int scriptId) {
		Script script = null;
		EntityManager em = getThreadEntityManager();
		Session sess = em.find(Session.class, sessionId);
		script = em.find(Script.class, scriptId);
		sess.setScript(script);
		return script;
	}

	@SuppressWarnings("unchecked")
	public Script setScriptWithLowestUsageForSession(int sessionId) {
		Script script = null;
		EntityManager em = getThreadEntityManager();
//		EntityTransaction tx = null;
//		try {
//			tx = em.getTransaction();
//			tx.begin();
			Session sess = em.find(Session.class, sessionId);
			Project project=sess.getProject();

			Query q = em
					.createQuery("SELECT object(o) FROM Script o WHERE :project MEMBER OF o.projects AND o.name <> 'Sinus-Test'");
			//q.setHint("toplink.refresh", "true");
			q.setParameter("project", project);
			// TODO this list maybe very long !!
			List<Script> list = q.getResultList();

			int minUsed = Integer.MAX_VALUE;
			for (Script s : list) {
				em.refresh(s);
				Set<Session> sesss = s.getSessions();
				int size = sesss.size();
				if (size < minUsed) {
					script = s;
					minUsed = size;
				}
			}
			sess.setScript(script);
			
			// TODO and this does not work yet ???
			// yes because argument of MIN() must be a "state-field" in JPQL
			// so we need a counter field in Script class
//			Query minUsageQuery=em.createQuery("select min(o.sessionsSet.size) from Script o");
//			Integer minUsage=(Integer)minUsageQuery.getSingleResult();
//			Query q = em.createQuery("select object(o) from Script as o where o.name != 'Sinus-Test' and size(o.sessionsSet) = ?");
//			q.setParameter(1, minUsage);
//			List<Script> list = q.getResultList();
//			
//			sess.setScript(list.get(0));
			
			
//			tx.commit();
//
//		} catch (PersistenceException e) {
//			e.printStackTrace();
//			if (tx != null && tx.isActive())
//				tx.rollback();
//			em.close();
//			throw e;
//		}

		return script;
	}

	@SuppressWarnings("unchecked")
	public Script setSinusTestScriptForSession(int sessionId) {

		Script script = null;
		EntityManager em = getThreadEntityManager();

		List<ipsk.db.speech.script.Script> list = null;

		Query q = em
		.createQuery("select object(o) from Script as o where o.name='"
				+ ScriptController.SINE_TEST_SCRIPT_NAME + "'");
		q.setHint("toplink.refresh", "true");
		q.setMaxResults(1);
		q.setFirstResult(0);
		list = q.getResultList();

		script = list.get(0);
		em.refresh(script);
		Session sess = em.find(Session.class, sessionId);
		em.refresh(sess);
		sess.setScript(script);
		return script;

	}
	
	
//	public boolean getPermittedByProjectConfiguration() throws ControllerException{
//		// TODO add project configuration
//		// for now only single session per speaker allowed
//		return getSingleSessionOfSpeaker();
//	}
//	public boolean getSingleSessionOfSpeaker() throws ControllerException{
//		Session sess=(Session)getItem();
//		Set<Speaker> spks=sess.getSpeakers();
//		if(spks.size()==1){
//			Speaker singleSpk=spks.toArray(new Speaker[0])[0];
//			Set<Session> spkSesss=singleSpk.getSessions();
//			int spkSesssCount=spkSesss.size();
//			if(spkSesssCount<=1)return true;
//		}
//		return 	false;
//	}
//	
	
	public String getSpeechRecorderBaseHref(Session s) {

		if(s!=null) {
			SpeechRecorderClient sprCl=s.getSpeechRecorderClient();
			if(s.getScript()==null) {
				if(SpeechRecorderClient.HTML5_ANGULAR.equals(sprCl)) {
					return RECORDER_HTML5_BASE_HREF;
				}
				return RECORDER_DEFAULT_BASE_HREF;
			}else {
				if(SpeechRecorderClient.HTML5_ANGULAR.equals(sprCl)) {
					return SPEECHRECORDER_HTML5_BASE_HREF;
				}
				return SPEECHRECORDER_DEFAULT_BASE_HREF;
			}
		}
		return SPEECHRECORDER_DEFAULT_BASE_HREF;
	}
	
	
	public NotSingleSessionPropertyValidationError getNotSingleSessionPropertyValidationError(){
		BeanModel<Session> bm=getBeanModel();
		if(bm!=null){
			ValidationResult vr=bm.getValidationResult();
			if(vr!=null){
				PropertyValidationResult pvr=vr.getPropertyValidationResult("speakers");
				if(pvr!= null && pvr instanceof NotSingleSessionPropertyValidationError){
					
					return (NotSingleSessionPropertyValidationError)pvr;
				}
			}
		}
		return null;
	}
	
	public SessionAlreadyStartedPropertyValidationError getSessionAlreadyStartedPropertyValidationError(){
		BeanModel<Session> bm=getBeanModel();
		if(bm!=null){
			ValidationResult vr=bm.getValidationResult();
			if(vr!=null){
				PropertyValidationResult pvr=vr.getPropertyValidationResult("status");
				if(pvr!= null && pvr instanceof SessionAlreadyStartedPropertyValidationError){
					return (SessionAlreadyStartedPropertyValidationError)pvr;
				}
			}
		}
		return null;
	}
	
	public ValidationResult validate(Object o,ValidationResult validationResult) throws ValidationException{
		ValidationResult vr=super.validate(o, validationResult);
		Session sess=(Session)o;
		Project prj=sess.getProject();
		
		
		Set<Speaker> spks=sess.getSpeakers();
		
		if(spks.size()==0){
			// session without speaker is only allowed for testing 
			Session.Type st=sess.getType();
			if(!(Session.Type.TEST.equals(st) || Session.Type.TEST_DEF_A.equals(st) || Session.Type.SINE_TEST.equals(st))){
				vr.putPropertyValidationResult("speakers",new PropertyValidationResult(PropertyValidationResult.Type.ERROR));
				vr.setType(ValidationResult.Type.ERRORS);
			}
		}else if(spks.size()==1){
			
			
			Speaker singleSpk=spks.toArray(new Speaker[0])[0];
			Account spkAccount=singleSpk.getAccount();
			Account spkDataAccount=singleSpk.getSpeakerDataAccount();
			Account acc=getAccountByRequest(currentRequest);
			
			// speaker/person accounts can have multiple sessions and project admins are allowed to 
			if(spkAccount==null && spkDataAccount==null && (acc==null || ! acc.getAdminOfProjects().contains(getSelectedProject()))){
				//check for single session per speaker
				Set<Session> spkSesss=singleSpk.getSessions();
				int spkSesssCount=spkSesss.size();
				if(spkSesssCount>1){
					// 
					//Project prj=sess.getProject();
					// TODO
					//if(!prj.isAllowMultipleSessionsPerSpeaker){
//					if(false) {
//						vr.putPropertyValidationResult("speakers",new NotSingleSessionPropertyValidationError());
//						vr.setType(ValidationResult.Type.ERRORS);
//					}
				}
			
			}
		}else{
			// more than one speaker not supported yet
			// TODO
			
			LocalizableMessage localizableMessage=new LocalizableMessage(RESOURCE_BUNDLE_NAME,"session.error.not_single_speaker");
			vr.putPropertyValidationResult("speakers",new PropertyValidationResult(PropertyValidationResult.Type.ERROR,localizableMessage));
			vr.setType(ValidationResult.Type.ERRORS);
			
		}
		
		Set<Script> activeProjectScripts=prj.getScripts();
		if(activeProjectScripts!=null && activeProjectScripts.size()>0) {
			// Project uses scripts (SpeechRecorder mode). Validate if a script is set for this session.
			Script script=sess.getScript();
			if(script==null) {
				vr.putPropertyValidationResult("script",new PropertyValidationResult(PropertyValidationResult.Type.ERROR));
				vr.setType(ValidationResult.Type.ERRORS);
			}
		}
		return vr;
	}
	
	/**
	 * Deletes complete recording session.
	 * Deletes all files in the session directory and the session directory itself.
	 * Removes the recording file entries in the database and the session entry.
	 * @return true if all files could be deleted false if there are remaining files.
	 * @throws ControllerException 
	 */
	public boolean deleteSessionWithRecordingFileDirectory(HttpServletRequest request,Session session) throws ControllerException{
		EntityManager em=getThreadEntityManager();
		boolean deletedDir=false;
			deleteRelated(request, session);
			Set<RecordingFile> rfs=session.getRecordingFiles();
			for(RecordingFile rf:rfs){
				securityManager.checkRemovePermission(request, rf);
				String fileURLStr=rf.getSignalFile();
				URL fileURL=null;
				try {
					fileURL = new URL(fileURLStr);
					if(fileURL.getProtocol().equalsIgnoreCase("file")){
						File recFile=new File(fileURL.getFile());
						recFile.delete();
					}
				} catch (MalformedURLException e) {
					e.printStackTrace();
				}

				em.remove(rf);
			}
			securityManager.checkRemovePermission(request, session);
			String storageDirURLStr=session.getStorageDirectoryURL();

			if(storageDirURLStr!=null){

				try {
					URL storageDirURL=new URL(storageDirURLStr);
					File storageDir=new File(storageDirURL.getFile());
					if(storageDir.exists()){
						File[] sessionFiles=storageDir.listFiles();
						for(File sf:sessionFiles){
							sf.delete();
						}
					}
					deletedDir=storageDir.delete();
				} catch (MalformedURLException e) {	
					e.printStackTrace();

				}
			}
			em.remove(session);
		
		return deletedDir;
	}
	
	/**
	 * Deletes complete recording session if command is 'delete'.
	 * Deletes all files in the session directory and the session directory itself.
	 * Removes the recording file entries in the database and the session entry.
	 * @return true if all files could be deleted false if there are remaining files.
	 * @throws ControllerException 
	 */
	public boolean deleteSessionWithRecordingFileDirectory(HttpServletRequest request) throws ControllerException{
		clear();
		String command=processCommand(request);
		createBeanModel(request);
		EntityManager em=getThreadEntityManager();
		//Session s=em.find(Session.class, sessionId);
		Session s =(Session)getBeanModel().getBean();
		beanModel=new BeanModel<Session>(s);
		
		boolean deletedDir=false;
		if(CMD_DELETE.equals(command)){
			deleteSessionWithRecordingFileDirectory(request, s);
			processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
		}else if(CMD_CANCEL.equals(command)){
			processResult=new ProcessResult(ProcessResult.Type.CANCELLED);
		}
		return deletedDir;
	}
	
	
	public File[] getFileList() throws ControllerException{
		Session s=getSession();
		File[] files=null;
		String dirURLStr=s.getStorageDirectoryURL();
		if(dirURLStr!=null){
			try {
				URL dirURL=new URL(dirURLStr);
				if("file".equalsIgnoreCase(dirURL.getProtocol())){
					File dir=new File(dirURL.getFile());
					File[] dirList=new File[0];
					files=new File[0];
					if(dir.exists()){
						dirList=dir.listFiles();
						files=new File[dirList.length+1];
						files[0]=dir;
						for(int i=0;i<dirList.length;i++){
							files[i+1]=dirList[i];
						}
					}
					
				}
			} catch (MalformedURLException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			}
			
		}
		return files;
	}
	
	
	
	
	// TODO
	// storage servlet should store log file path to session
	public String  getLogFileContent() throws ControllerException{
		
		Session s=getSession();
		
		String dirURLStr=s.getStorageDirectoryURL();
		if(dirURLStr!=null){
			try {
				URL dirURL=new URL(dirURLStr);
				if("file".equalsIgnoreCase(dirURL.getProtocol())){
					File dir=new File(dirURL.getFile());
					DecimalFormat sessionIdFormat=new DecimalFormat(SessionStorageManager.DEF_SESSION_ID_FORMAT);
					String formattedSessionId=sessionIdFormat.format(s.getSessionId());
					String logFileName=s.getProject().getSessionCode()+formattedSessionId+"_log.log";
					String logFileNameNoCode=formattedSessionId+"_log.log";
					File logFile=new File(dir,logFileName);
					boolean found=logFile.exists();
					if(!found){
						logFile=new File(dir,logFileNameNoCode);
						found=logFile.exists();
					}
					if (found) {
						InputStream in = new FileInputStream(logFile);
						InputStreamReader logReader = new InputStreamReader(in,
								Charset.forName("ISO-8859-1"));

						StringWriter sw = new StringWriter();
						StreamCopy.copyChars(logReader, sw);
						return sw.toString();
					}
				}
			} catch (MalformedURLException e) {
				e.printStackTrace();
				throw new ControllerException(e);
			} catch (FileNotFoundException e) {
				return null;
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
		}
		return null;
	}
	
	
	
	public void exportSessionToZipStream(OutputStream outStream,String dirURLStr) throws IOException{
	
	if(dirURLStr!=null){
		try {
			URL dirURL=new URL(dirURLStr);
			if("file".equalsIgnoreCase(dirURL.getProtocol())){
				File dir=new File(dirURL.getFile());
				//res.setContentType("application/zip");
				ZipPacker zipPacker = new ZipPacker(outStream);
				zipPacker.packDirRecursive(dir);
				zipPacker.close();
//				File[] dirList=new File[0];
//				files=new File[0];
//				if(dir.exists()){
//					dirList=dir.listFiles();
//					files=new File[dirList.length+1];
//					files[0]=dir;
//					for(int i=0;i<dirList.length;i++){
//						files[i+1]=dirList[i];
//					}
//				}
				
			}
		} catch (MalformedURLException e) {
			e.printStackTrace();
			throw new IOException("Malformed URL directory path: "+dirURLStr);
		} 
	}
	}
	
	
	protected void setPropertiesOnCreate(HttpServletRequest request,EntityManager em,Object bean) {
		Session s=(Session)bean;
		if(request!=null && s!=null){
			HttpSession httpSess=request.getSession();
			if(httpSess!=null){
				String httpSessId=httpSess.getId();
				s.setHttpSessionId(httpSessId);
			}
		}
	}
	
	public boolean getWaitForCompleteUpload() throws ControllerException{
		Account acc=AccountController.getAccountByRequest(currentRequest, getThreadEntityManager());
		if(acc!=null){
			Organisation orga=acc.getOrganisation();
			if(orga!=null){ 
				Boolean wfcu=orga.getWaitForCompleteUpload();
				if(wfcu!=null){
					return wfcu;
				}
			}
		}
		return true;
	}
	public int getTransferRateLimit() throws ControllerException{
		int tl=UploadCache.UNLIMITED;
		Account acc=AccountController.getAccountByRequest(currentRequest, getThreadEntityManager());
		if(acc!=null){
			Organisation orga=acc.getOrganisation();
			if(orga!=null){ 
				Integer tlDb=orga.getTransferRateLimit();
				if(tlDb!=null){
					tl=tlDb;
				}
			}
		}
		return tl;
	}
	

	
	
}
