package ipsk.webapps.db.speech;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

import ipsk.beans.form.FormConfiguration;
import ipsk.beans.form.PropertyConfiguration;
import ipsk.db.speech.Speaker;

public class SpeakerFormConfigForceInformedConsent implements FormConfiguration {

	private FormConfiguration formConfiguration;
	private boolean paperForm;
	private PropertyConfiguration informedConsentPropertyConfiguration;
	private PropertyConfiguration informedBroadConsentPropertyConfiguration;
	private PropertyConfiguration informedConsentInPaperFormSignedPropertyConfiguration;
	
	private static String DEFAULT_DISPLAY_NAME="Force informed consent property from configuration";
	private static String DEFAULT_DESCRIPTION="Forces form to at least contain the required infromed consent property.";
	
	public SpeakerFormConfigForceInformedConsent(FormConfiguration formConfiguration) throws IntrospectionException {
		this(formConfiguration,false);
	}
	
	public SpeakerFormConfigForceInformedConsent(FormConfiguration formConfiguration,boolean paperForm) throws IntrospectionException {
		this.formConfiguration=formConfiguration;
		this.paperForm=paperForm;
		
		final PropertyDescriptor informedConsentPd=new PropertyDescriptor("informedConsentDelegate", Speaker.class);
		informedConsentPropertyConfiguration=new PropertyConfiguration() {
			
			@Override
			public boolean isShow() {
				return true;
			}
			
			@Override
			public boolean isRequired() {
				
				return true;
			}
			
			@Override
			public PropertyDescriptor getPropertyDescriptor() {
				return informedConsentPd;
			}
			
			@Override
			public Class<?> getBeanClass() {
				return this.getBeanClass();
			}
		};
		
		final PropertyDescriptor informedBroadConsentPd=new PropertyDescriptor("informedBroadConsentDelegate", Speaker.class);
		informedBroadConsentPropertyConfiguration=new PropertyConfiguration() {
			
			@Override
			public boolean isShow() {
				return true;
			}
			
			@Override
			public boolean isRequired() {
				
				return false;
			}
			
			@Override
			public PropertyDescriptor getPropertyDescriptor() {
				return informedBroadConsentPd;
			}
			
			@Override
			public Class<?> getBeanClass() {
				return this.getBeanClass();
			}
		};
		
		final PropertyDescriptor informedConsentInPaperFormSignedPd=new PropertyDescriptor("informedConsentInPaperFormSignedDelegate", Speaker.class);
		informedConsentInPaperFormSignedPropertyConfiguration=new PropertyConfiguration() {
			
			@Override
			public boolean isShow() {
				return true;
			}
			
			@Override
			public boolean isRequired() {
				
				return true;
			}
			
			@Override
			public PropertyDescriptor getPropertyDescriptor() {
				return informedConsentInPaperFormSignedPd;
			}
			
			@Override
			public Class<?> getBeanClass() {
				return this.getBeanClass();
			}
		};
		
	}
	
	public SpeakerFormConfigForceInformedConsent() throws IntrospectionException {
		this(null);
	}

	@Override
	public String getDisplayName() {
		if(formConfiguration==null){
			return DEFAULT_DISPLAY_NAME;
		}else{
			return formConfiguration.getDisplayName();
		}
	}

	@Override
	public String getDescription() {
		if(formConfiguration==null){
			return DEFAULT_DESCRIPTION;
		}else{
			return formConfiguration.getDescription();
		}
	}

	@Override
	public Class<?> getBeanClass() {
		if(formConfiguration==null){
			return Speaker.class;
		}else{
			return formConfiguration.getBeanClass();
		}
	}

//	@Override
//	public boolean isDefaultShow() {
//		if(formConfiguration==null){
//			return true;
//		}else{
//			return formConfiguration.isDefaultShow();
//		}
//	}

	@Override
	public List<PropertyConfiguration> getPropertyConfigurations() {
		List<PropertyConfiguration> propertyConfigurations=new ArrayList<>();

		if(formConfiguration!=null){
			for(PropertyConfiguration pc:formConfiguration.getPropertyConfigurations()){
				PropertyDescriptor pd=pc.getPropertyDescriptor();
				if(pd!=null) {
					if(paperForm){
						if(pd.equals(informedConsentInPaperFormSignedPropertyConfiguration.getPropertyDescriptor())){
							continue;
						}
					}else{
						if(pd.equals(informedConsentPropertyConfiguration.getPropertyDescriptor()) || 
								pd.equals(informedBroadConsentPropertyConfiguration.getPropertyDescriptor())){
							continue;
						}
					}
				}
				propertyConfigurations.add(pc);
			}
		}
		if(paperForm){
			propertyConfigurations.add(informedConsentInPaperFormSignedPropertyConfiguration);
		}else{
			propertyConfigurations.add(informedConsentPropertyConfiguration);
			propertyConfigurations.add(informedBroadConsentPropertyConfiguration);
		}
		return propertyConfigurations;
	}
//
//	@Override
//	public boolean isDefaultRequired() {
//		if(formConfiguration==null){
//			return false;
//		}else{
//			return formConfiguration.isDefaultRequired();
//		}
//	}

}
