package ipsk.webapps.db.speech.project;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ips.beans.PersistenceMapConverter;
import ipsk.beans.MapConverterException;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.project.MediaCaptureFormat;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.speech.BasicWikiSpeechController;

public class MediaCaptureFormatController extends BasicWikiSpeechController<MediaCaptureFormat> {
	
	public MediaCaptureFormatController() {
		super("WebSpeechDBPU",MediaCaptureFormat.class, "mediaCaptureFormat");
	}
	
	public void storeMediaFormat(HttpServletRequest req) throws ControllerException{
		
		createEmptyBeanTableModel(req);
		
		if (req.isUserInRole(UserRoleId.RoleName.ADMIN.name()) ||  req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			
			PersistenceMapConverter<MediaCaptureFormat> mapConverter = new PersistenceMapConverter<MediaCaptureFormat>();
			MediaCaptureFormat mcf=new MediaCaptureFormat();
			try {
				EntityManager em=getThreadEntityManager();
				mapConverter.createBeanModel(mcf, req.getParameterMap(), em,false, req, securityManager);
				Project prj=em.find(Project.class,mcf.getName());
				mcf.setProject(prj);
				MediaCaptureFormat existMcf=em.find(MediaCaptureFormat.class, mcf.getName());
				if(existMcf!=null) {
					securityManager.checkMergePermission(req, mcf);
					em.merge(mcf);
				}else {
					securityManager.checkPersistPermission(req,mcf);
					em.persist(mcf);
				}
				prj.setMediaCaptureFormat(mcf);
				em.merge(prj);
				processResult=new ProcessResult(ProcessResult.Type.SUCCESS);
			} catch (MapConverterException e) {
				
				e.printStackTrace();
				throw new ControllerException(e);
			}
		}
	}
	
}
