package ipsk.webapps.jsp.taglib;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;

import ipsk.text.Version;
import ua_parser.CachingParser;
import ua_parser.OS;
import ua_parser.UserAgent;

public class BrowserCheckTag extends BodyTagSupport {

	private String suitablevar;
	public String getSuitablevar() {
		return suitablevar;
	}

	public void setSuitablevar(String suitablevar) {
		this.suitablevar = suitablevar;
	}



	private String familyvar;
	
	public String getFamilyvar() {
		return familyvar;
	}

	public void setFamilyvar(String familyvar) {
		this.familyvar = familyvar;
	}
	
	private String versionvar;
	public String getVersionvar() {
		return versionvar;
	}

	public void setVersionvar(String versionvar) {
		this.versionvar = versionvar;
	}
	
	
	private String osfamilyvar;

	
	public String getOsfamilyvar() {
		return osfamilyvar;
	}

	public void setOsfamilyvar(String osfamilyvar) {
		this.osfamilyvar = osfamilyvar;
	}
	
	private String osversionvar;

	public String getOsversionvar() {
		return osversionvar;
	}

	public void setOsversionvar(String osversionvar) {
		this.osversionvar = osversionvar;
	}

	public void setPageContext(PageContext pageContext){
		super.setPageContext(pageContext);
		
	}
	public int doStartTag() throws JspException {
		ServletRequest req = pageContext.getRequest();

		// Default: unknown
		Boolean suitable=null;
		
		if(req instanceof HttpServletRequest) {
			HttpServletRequest request=(HttpServletRequest)req;

			String uaHeader=request.getHeader("User-Agent");
			if(uaHeader==null){
				// TODO how to handle this
			}else{
				
				// Check updated regexes.yaml in src/main/resources/ipsk.webapps.jsp.taglib/
				
				InputStream regexesSteam=BrowserCheckTag.class.getResourceAsStream("regexes.yaml");
				
				CachingParser uap;
				if(regexesSteam==null) {
					uap = new CachingParser();
				}else {
					System.out.println("Using updated regexes.yaml");
					uap = new CachingParser(regexesSteam);
				}
				UserAgent ua=uap.parseUserAgent(uaHeader);
				OS os=uap.parseOS(uaHeader);
				
				Integer majorVers=null;
				try{
					majorVers=Integer.parseInt(ua.major);
				}catch(NumberFormatException nfe){
					// Major version not avail
				}
				
				
				String osVersion="";
				boolean osVersionValid=true;
				List<Integer> osVersionIntsList=new ArrayList<>();
				if(os.major!=null) {
					osVersion=osVersion+os.major;
					if(osVersionValid) {
						try {
							osVersionIntsList.add(Integer.parseInt(os.major));
						}catch(NumberFormatException nfe) {
							osVersionValid=false;
						}
					}
				}
				if(os.minor!=null) {
					if(!osVersion.isBlank()) {
						osVersion=osVersion+".";
					}
					osVersion=osVersion+os.minor;
					if(osVersionValid) {
						try {
							osVersionIntsList.add(Integer.parseInt(os.minor));
						}catch(NumberFormatException nfe) {
							osVersionValid=false;
						}
					}
					
				}
				if(os.patch!=null) {
					if(!osVersion.isBlank()) {
						osVersion=osVersion+".";
					}
					osVersion=osVersion+os.patch;
					
					if(osVersionValid) {
						try {
							osVersionIntsList.add(Integer.parseInt(os.patch));
						}catch(NumberFormatException nfe) {
							osVersionValid=false;
						}
					}
				}
				if(os.patchMinor!=null) {
					if(!osVersion.isBlank()) {
						osVersion=osVersion+".";
					}
					osVersion=osVersion+os.patchMinor;
					
					if(osVersionValid) {
						try {
							osVersionIntsList.add(Integer.parseInt(os.patchMinor));
						}catch(NumberFormatException nfe) {
							osVersionValid=false;
						}
					}
				}
				
				int osVersionLen=osVersionIntsList.size();
				int[] osVersionInts=new int[osVersionLen];
				for(int i=0;i<osVersionLen;i++) {
					osVersionInts[i]=osVersionIntsList.get(i);
				}	
				Version osV=new Version(osVersionInts);
				
				if(osfamilyvar!=null) {
					pageContext.setAttribute(osfamilyvar, os.family,PageContext.REQUEST_SCOPE);
				}
				
				if(osversionvar!=null) {
					pageContext.setAttribute(osversionvar, osVersion,PageContext.REQUEST_SCOPE);
				}
				
				if(familyvar!=null) {
					pageContext.setAttribute(familyvar, ua.family,PageContext.REQUEST_SCOPE);
				}
				
				boolean brVersionValid=true;
				List<Integer> brVersionIntsList=new ArrayList<>();
				
				String version="";
				if(ua.major!=null) {
					version=version+ua.major;
					if(brVersionValid) {
						try {
							brVersionIntsList.add(Integer.parseInt(ua.major));
						}catch(NumberFormatException nfe) {
							brVersionValid=false;
						}
					}
				}
				if(ua.minor!=null) {
					if(!version.isBlank()) {
						version=version+".";
					}
					version=version+ua.minor;
					if(brVersionValid) {
						try {
							brVersionIntsList.add(Integer.parseInt(ua.minor));
						}catch(NumberFormatException nfe) {
							brVersionValid=false;
						}
					}
				}
				if(ua.patch!=null) {
					if(!version.isBlank()) {
						version=version+".";
					}
					version=version+ua.patch;
					if(brVersionValid) {
						try {
							brVersionIntsList.add(Integer.parseInt(ua.patch));
						}catch(NumberFormatException nfe) {
							brVersionValid=false;
						}
					}
				}
				
				int brVersionLen=brVersionIntsList.size();
				int[] brVersionInts=new int[brVersionLen];
				for(int i=0;i<brVersionLen;i++) {
					brVersionInts[i]=brVersionIntsList.get(i);
				}	
				Version brV=new Version(brVersionInts);
				
				
				if(versionvar!=null) {
					pageContext.setAttribute(versionvar,version,PageContext.REQUEST_SCOPE);
				}
				
				
				if(suitablevar!=null) {
					// Notes: 
					// MS Edge: Only Chromium based versions (>=80) supported
					// Chromium based browsers on Android do not support AGC (only when activating echo cancellation as well)
					// Safari does not support recording stereo
					
					// iPad 9th generation out of the box NOT supported: Distorted sound (many short outages)!					
					// iPad Info:
					// Softwareversion: 15.1
					
					// Browser check shows:
					// Mac OS X 10.15.6
					// Safari 15.1
					
					// After Update to iPadOS 15.3.1:
					
					// Browser check shows:
					// Mac OS X 10.15.6
					// Safari 15.3
					
					// Sound OK!
					
					
					// Mobile Safari: supported from 14.1
					Version safariMinMobileVers=new Version(new int[] {14,1});
					
					boolean suitableMobileSafari=false;
					if(ua.family.equalsIgnoreCase("mobile safari")) {
						int cp=safariMinMobileVers.compareTo(brV);
						suitableMobileSafari=(cp<=0);
					}
					
				suitable=(
						(ua.family.equalsIgnoreCase("chrome") && !"Android".equals(os.family) && majorVers!=null && majorVers>=66) || 
						(ua.family.equalsIgnoreCase("chrome mobile") && !"Android".equals(os.family) && majorVers!=null && majorVers>=66) ||
						(ua.family.equalsIgnoreCase("firefox") && majorVers!=null && majorVers>=60) || 
						(ua.family.equalsIgnoreCase("firefox mobile") && majorVers!=null && majorVers>=60) || 
						(ua.family.equalsIgnoreCase("edge") && !"Android".equals(os.family) && majorVers!=null && majorVers>=80) || 
						(ua.family.equalsIgnoreCase("edge mobile") && !"Android".equals(os.family) && majorVers!=null && majorVers>=80) || 
						(ua.family.equalsIgnoreCase("opera") && !"Android".equals(os.family)  && majorVers!=null && majorVers>=60) ||
						(ua.family.equalsIgnoreCase("opera mobile") && !"Android".equals(os.family)  && majorVers!=null && majorVers>=60) ||
						(ua.family.equalsIgnoreCase("safari") && majorVers!=null && majorVers>=13)||
						suitableMobileSafari
						
						);
					
				}
			}
		}
		pageContext.setAttribute(suitablevar, suitable,PageContext.REQUEST_SCOPE);
		
		return EVAL_BODY_INCLUDE;
	}

	public int doEndTag() throws JspException {
		
		return EVAL_PAGE;
	}


}
