<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ page isELIgnored="false" language="java" contentType="text/html; charset=UTF-8" session="true" import="java.util.*,java.text.*,ipsk.webapps.*,ipsk.webapps.db.speech.*,javax.servlet.jsp.jstl.fmt.LocaleSupport"  errorPage="/errorPage.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<fmt:setBundle basename="Messages" scope="session"/>
<jsp:useBean id="projectsDb" scope="session" class="ipsk.webapps.db.speech.ProjectController" />
<ips:ctrl_process controller="${projectsDb}" processMethod="getAssociatedProjects" var="assProjects">
<c:if test="${fn:length(assProjects) == 1}">
<c:set var="corpusmachine_project" scope="session" value="${assProjects[0].name}"/>
</c:if>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="login.confirm"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
<h2><fmt:message key="login.confirm"/></h2>
<jsp:useBean id="accCtrl" scope="session" class="ipsk.webapps.db.speech.AccountController" />
<ips:ctrl_process controller="${accCtrl}" processMethod="login">
<c:set var="inetOrgPerson" value="${accCtrl.inetOrgPersonPrincipal}"/>
<p><fmt:message key="welcome"/> <c:choose><c:when test="${not empty accCtrl.account.person.welcomeName}"><c:out value="${accCtrl.account.person.welcomeName}"/></c:when><c:otherwise><c:choose><c:when test="${inetOrgPerson != null}"><c:out value="${inetOrgPerson.attrGivenname}"/> <c:out value="${inetOrgPerson.attrSurname}"/></c:when><c:otherwise><c:out value="${accCtrl.account.organisation}"/></c:otherwise></c:choose></c:otherwise></c:choose>!</p>
<c:if test="${inetOrgPerson != null}">
	<c:if test="${accCtrl.account == null}">
	<!--  copy to SQL DB required -->
	<p>This seems to be your first login to WikiSpeech.</p>
	<p>In order to work with Wikispeech it is required to create an Wikispeech account from your login data.</p>
	
	<form action="/login/sync_inet_org_person.jsp"><input type="submit" value="OK"/></form>
	</c:if>
</c:if>
</ips:ctrl_process>

<c:set scope="request" var="selectable" value="${fn:length(assProjects) > 1}"/>
<fmt:message key="projects.account_associated"><fmt:param value="${fn:length(assProjects)}"/></fmt:message>
<c:if test="${fn:length(assProjects) > 0}">
<table>
<c:forEach items="${assProjects}" var="assProject">
<c:url value="/session/select_project.jsp" var="projectSelectURL" scope="request">
<c:param name="select_project" value="${assProject.name}"/>
</c:url>
<tr><td><b><c:out value="${assProject.name}"/></b></td><td><c:if test="${not empty assProject.contextPath}"><a href="<c:url value="/${assProject.contextPath}/"/>">[<fmt:message key="information"/>]</a> </c:if><c:if test="${selectable}"><a href="<c:out value="${projectSelectURL}"/>">[<fmt:message key="select"/>]</a></c:if></td></tr>
</c:forEach>
</table>
</c:if>
<c:if test="${selectable}"><p><fmt:message key="request.select.from_list"/></p></c:if>


<!--  Directly display links to start a session for non admin users -->
<%  if( !(request.isUserInRole(ipsk.db.speech.UserRoleId.RoleName.ORGANISATION.name()) || 
		request.isUserInRole(ipsk.db.speech.UserRoleId.RoleName.PROJECT_ADMIN.name()) ||
		request.isUserInRole(ipsk.db.speech.UserRoleId.RoleName.ADMIN.name())))
    {
%>	
<!-- Only display if user has exactly one associated project -->
<!-- ( otherwise the user is member of multiple projects he has to select a project first )-->
<c:if test="${fn:length(assProjects) == 1}">
<c:if test="${projectsDb.selfRecordingSessionAllowed}">
<!-- is allowed to record  -->
<c:choose>
<c:when test="${projectsDb.speakerDataAvailable}">
<!--  some speaker data already available -->
<c:choose>
<c:when test="${projectsDb.subjectHasInformedConsentForSelectedProject and projectsDb.speakerDataComplete}">

<!--  Speaker data already complete, start session -->
<c:url var="newSessionURLWP" value="/session/db/session/SessionNew.jsp">
<c:param name="_cmd" value="new"/>
<c:param name="project.name" value="${projectsDb.selectedProject.name}"/>
<c:param name="type" value="NORM"/>
<c:param name="code" value="${projectsDb.selectedProject.sessionCode}"/>
<c:param name="speakers.personId" value="${projectsDb.speakerId}"/>
</c:url>

<form method="post" action="<c:out value="${newSessionURLWP}"/>">
<input type="submit" name="submit" value="<fmt:message key="session.new"/> &gt;&gt;"/>
</form>

</c:when>

<c:otherwise>
<!--  Speaker data not complete, show speaker editor to request completion -->
<c:url var="editSpeakerURLWP" value="/session/db/speaker/SpeakerEdit.jsp">
<c:param name="_cmd" value="edit"/>
<c:param name="personId" value="${projectsDb.speakerId}"/>
</c:url>
<form method="post" action="<c:out value="${editSpeakerURLWP}"/>">
<input type="submit" name="submit" value="<fmt:message key="session.new"/> &gt;&gt;"/>
</form>

</c:otherwise>
</c:choose>
</c:when>

<c:otherwise>
<!--  No speaker data available, show new speaker form -->
<form method="post" action="<c:url value="/session/db/speaker/SpeakerNew?_cmd=new"/>">
<input type="submit" name="submit" value="<fmt:message key="speaker.new"/> &gt;&gt;"/>
</form>

</c:otherwise>
</c:choose>
</c:if>
</c:if>
<%  }  %>
 
</td></tr>
</table>

</body>
</html>
</ips:ctrl_process>
