<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>

<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" import="ipsk.db.speech.SpeechRecorderClient" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="session.new"/></title>
<script type="text/javascript">

function checkEnvironmentHints(){
	
	var lcUserAgent=navigator.userAgent.toLowerCase();
	var isSafari=lcUserAgent.indexOf('safari/') > -1;
	var ac='';
	if(isSafari){
		//ac='';
	}
	var webstartHintsElement=document.getElementById('webstartHints');
	if(webstartHintsElement){
		webstartHintsElement.innerHTML=ac;
	}
}
</script>
</head>

<body onload="checkEnvironmentHints()">
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><fmt:message key="session.new"/></h2>		 
 
<jsp:useBean id="sessCtrl" scope="session" class="ipsk.webapps.db.speech.SessionController" />
<ips:ctrl_process controller="${sessCtrl}">
<ips:ctrl_div>

<form method="POST" action="<c:url value="/session/db/session/SessionNew.jsp"/>" accept-charset="UTF-8" enctype="application/x-www-form-urlencoded;charset=utf-8">

<ips:bedit actionCommand="add" props="project,speakers,comment">

</ips:bedit>
<c:set var="accOrganisation" scope="request" value="${sessCtrl.sessionAccount.organisation}"/>
<c:if test="${accOrganisation != null}">
<input type="hidden" name="organisation.organisationId" value="${accOrganisation.organisationId}">
</c:if>
<input type="hidden" name="uuid" value="${sessCtrl.item.uuid}">
<input type="hidden" name="code" value="${sessCtrl.item.code}">
<input type="hidden" name="type" value="${sessCtrl.item.type}">

<c:pedit name="script" href="/CorpusMachine/WebContent/session/db/script/ScriptSelect.jsp"/>
<input type="submit" name="_add" value="<fmt:message key="save"/> &gt;&gt;"/>
</form>
<p><fmt:message key="session.add.request"/></p>
<p><fmt:message key="comment.optional"/></p>

</ips:ctrl_div>
<ips:ctrl_div result="success">
<p><fmt:message key="session.add.confirm"><fmt:param value="${sessCtrl.item.sessionId}"/></fmt:message></p>
<c:url value="Webrecorder.jnlp" var="webrecorderURL">
<c:param name="_cmd" value="store"/>
<c:param name="sessionId" value="${sessCtrl.item.sessionId}"/>
<c:param name="status" value="STARTED"/>
</c:url>

 
<c:url value="/lib/ng" var="webrecorderHtml5AngularURL">
<c:param name="sessionId" value="${sessCtrl.item.sessionId}"/>
</c:url>
<c:url value="webspeechrecorder/index.jsp" var="webrecorderHtml5URL">
<c:param name="sessionId" value="${sessCtrl.item.sessionId}"/>
</c:url>

<c:if test="${fn:length(sessCtrl.item.project.allowedSpeechRecorderClients) gt 1 }">
<p><fmt:message key="speechrecorder.select_client"/></p>
</c:if>

<div style="padding:5px;margin:5px">
<c:forEach items="${sessCtrl.item.project.allowedSpeechRecorderClients}" var="sprClient">
<c:if test="${sprClient eq 'SINGLE_SESSION_WEBSTART'}">
<div style="border: 2px solid;border-radius: 5px;padding:5px">
<h2>SpeechRecorder Java WebStart</h2>
<form method="post" action="<c:out value="${webrecorderURL}"/>">
<input type="submit" name="submit" value="<fmt:message key="cmd.start_session"/> &gt;&gt;"/>
</form>
<p><fmt:message key="speechrecorder.webstart"/></p>
<p id="webstartHints"></p>
</div>
</c:if>

<c:if test="${sprClient eq 'HTML5_ANGULAR'}">
<div style="border: 2px solid;border-radius: 5px;padding:5px">
<h2>HTML5 Angular WebSpeechrecorder</h2>
<form method="post" action="<c:out value="${webrecorderHtml5AngularURL}"/>">
<input type="submit" name="submit" value="<fmt:message key="cmd.start_session"/> &gt;&gt;"/>
</form>
</div>
</c:if>

</c:forEach>
</div>

</ips:ctrl_div>
<ips:ctrl_div result="cancel">
<fmt:message key="cancelled"/>
</ips:ctrl_div>
</ips:ctrl_process>




</td></tr>
</table>
</body>
</html>
