package ipsk.webapps.audio;

import ipsk.audio.ThreadSafeAudioSystem;

import java.io.File;
import java.io.IOException;

import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class DecoderTest extends Thread{

	private File audioFile;
	public DecoderTest(File audioFile){
		super();
		this.audioFile=audioFile;
		
		
	}
	
	public void run(){
//		try {
//			Thread.sleep((long)(Math.random()*21));
//		} catch (InterruptedException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		}
		AudioFileFormat aff;
		try {
			//aff = AudioSystemWrapper.getAudioFileFormat(audioFile);
			aff = AudioSystem.getAudioFileFormat(audioFile);
		} catch (UnsupportedAudioFileException e) {
			e.printStackTrace();
			return;
		} catch (IOException e) {
			e.printStackTrace();
			return;
		}
		System.out.println(aff);
		AudioInputStream ais=null;
		try {
			
			ais=AudioSystem.getAudioInputStream(audioFile);
			//ais=AudioSystemWrapper.getAudioInputStream(audioFile);
			
			// the method getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais) seems to be thread safe
//			AudioInputStream decAis=AudioSystemWrapper.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
			AudioInputStream decAis=ThreadSafeAudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
			File testFile=File.createTempFile("test", "wav");
			testFile.deleteOnExit();
			AudioSystem.write(decAis, AudioFileFormat.Type.WAVE, testFile);
			testFile.delete();
			System.out.println("Decoded successfully.");
		} catch (UnsupportedAudioFileException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		
	}
	
}
