package ipsk.webapps.db.speech;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.PropertyValidationResult.Type;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.account.InvitationRequest;
import ipsk.net.SendMail;
import ipsk.net.SendMailException;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.speech.Invitation.Realisation;

public class BasicSpeakerInvitationController<T extends AbstractInvitation> extends BasicInvitationController<T> {

	public static final int DEFAULT_SPEAKER_INVITATION_VALID_TIME_MS=1000*60*60*24*5;  // 5 days
	
	
	public BasicSpeakerInvitationController(String persistenceUnit, Class<T> queryType) {
		super(persistenceUnit, queryType);
		setInvitationValidTimeMs(DEFAULT_SPEAKER_INVITATION_VALID_TIME_MS);
	}
	
	/**
	 * Invite a WikiSpeech subject user by E-Mail.
	 * Expires invalid account request from the database, checks the E-Mail address, stores an invitation request to the database and sends the invitation E-Mail.
	 * @param em the entity manager required to persist the invitation account  request
	 * @param req current HTTP request
	 * @param inv invitation data
	 * @param userRoleIds user roles to apply to the new user
	 * @throws ControllerException thrown on errors
	 */
	@Override
	public void invite(EntityManager em,HttpServletRequest req,Invitation inv,UserRoleId.RoleName[] userRoleIds)
			throws ControllerException {
			SendMail sm=new SendMail();
			ipsk.db.speech.account.InvitationRequest prr=invitationRequest(em,sm, req, inv, userRoleIds);
			if(prr==null) {
				throw new ControllerException("Invitation failed");
			}else {
				String homeUrl=invitationUtils.homeLink(req);
				String url=invitationUtils.invitationLink(req, prr.getUuid());
				
				String invEmail=inv.getEmail();
				String inputEmail=invEmail.trim();
				String invLocaleStr=inv.getLocale();
				Locale invLocale=new Locale(invLocaleStr);
				ResourceBundle rb=ResourceBundle.getBundle("Messages",invLocale);

				String subject=rb.getString("account.create.by_invitation.subject");
				//						
				// build mail content
				StringBuffer cb=new StringBuffer();
				String wikispeechSaluTation=rb.getString("wikispeech.salutation");
				cb.append(wikispeechSaluTation);
				cb.append(',');
				cb.append("\n\n");
				String invitationContent=rb.getString("account.create.by_invitation.message.content");
				cb.append(invitationContent);
				cb.append("\n\n");
				cb.append(url);
				cb.append("\n\n");
				String invitationValidUntil=rb.getString("account.create.by_invitation.message.link_valid_until");
				cb.append(invitationValidUntil);
				DateFormat df=DateFormat.getDateTimeInstance(DateFormat.DEFAULT, DateFormat.DEFAULT, invLocale);
				String fmtValidUntilDateStr=df.format(prr.getValidUntil());
				String fmtTimeZoneStr=df.getTimeZone().getDisplayName(invLocale);
				cb.append(fmtValidUntilDateStr);
				cb.append(" ");
				cb.append("("+fmtTimeZoneStr+")");
				cb.append("\n\n");
				String participateInProjectPatt=rb.getString("account.participate.in.project");
				String participateInProject=MessageFormat.format(participateInProjectPatt,projectName);
				cb.append(participateInProject);
				cb.append("\n");
				String loginOn=rb.getString("account.login.on");
				cb.append(loginOn);
				cb.append("\n\n");
				cb.append(homeUrl);
				cb.append("\n\n\n");
				String greeting=rb.getString("greeting");
				cb.append(greeting);
				cb.append("\n");
				String content=cb.toString();
				String wikiSpeechEmail=servletContext.getInitParameter("wikispeech.email_address");
				if(wikiSpeechEmail==null){
					String errMsg="Could not get WikiSpeech e-mail (sender) address (\"wikispeech.email_address\" in web.xml)";
					servletContext.log(errMsg);
					throw new ControllerException(errMsg);
				}
				try {
					sm.send(wikiSpeechEmail, inputEmail,subject, content);
					servletContext.log("Sent invitation E-Mail from "+wikiSpeechEmail+" to "+inputEmail);
				} catch (SendMailException e) {
					// TODO should this throw a controller exception ?
					servletContext.log("Could not send invitation E-Mail",e);
					return;
				}

			}
	}

}
