package ipsk.webapps.db.speech;

import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.beans.MapConverter;
import ipsk.beans.MapConverterException;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.utils.ProjectExportConfiguration;
import ipsk.db.speech.utils.ProjectExporter;
import ipsk.jsp.fmt.LocaleSupport;
import ipsk.jsp.taglib.ajax.update.Attribute;
import ipsk.jsp.taglib.ajax.update.Page;
import ipsk.jsp.taglib.ajax.update.Update;
import ipsk.persistence.EntityManagerProvider;
import ipsk.webapps.ControllerException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.ProcessResult;
import ipsk.xml.DOMConverter;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;

import org.w3c.dom.Document;


/**
 * Session bean to control the export thread
 * @author klausj
 *
 */
public class ProjectExportController extends BasicExportController implements HttpSessionBindingListener, EntityManagerProvider{
	
	private WikiSpeechSecurityManager securityManager;
	private String projectName=null;
	private String baseDirName=null;
	private Project project;
	private ProjectExportConfiguration configuration;
	private volatile ProjectExporter projectExporter;
	private DOMCodec dc;
	private DOMConverter dcv;
	private boolean enableAjax=true;
	
	
	
	//private String exportArchiveWorkPath;
	
	
	private int uniqueCount=0;
	//private ProgressStatus progressStatus=null;
	
	public static String[] SUBMIT_COMMANDS={CMD_START,CMD_CANCEL,CMD_UPDATE_VIEW};
	
	
	public ProjectExportController(){
		super();
		securityManager=new WikiSpeechSecurityManager(this);
		try {
			dc=new DOMCodec(Page.class.getPackage(),false);
			dcv=new DOMConverter();
		} catch (DOMCodecException e) {
			e.printStackTrace();
			enableAjax=false;
		}
		configuration=new ProjectExportConfiguration();
		EntityManagerFactory emf=EntityManagerFactoryInitializer.getEntityManagerFactory();
		projectExporter=new ProjectExporter(emf,configuration);
		worker=projectExporter;
	
	}
	
	
	
	public ProcessResult process(HttpServletRequest request,HttpServletResponse response,Servlet servlet)
			throws ControllerException {
		currentRequest=request;
		HttpSession session=request.getSession();
		boolean hasValidSession=(session !=null);
		String cmd=processCommand(request,SUBMIT_COMMANDS);
		//String cmd=request.getParameter(KEY_CMD);
		String projectNameParam=request.getParameter("name");
		if(projectNameParam!=null){
			if(!projectNameParam.equals(projectName) && !getBusy()){
				// close previous export work
				try {
					projectExporter.close();
					// ... and reset messages
					projectExporter.reset();
				} catch (WorkerException e1) {
					e1.printStackTrace();
					throw new ControllerException(e1);
				}
				projectName=projectNameParam;
				exportDir=null;
				//projectExporter.reset();
			}
		}
		if(projectName!=null) {
			// Check session access permission
			EntityManager em=getThreadEntityManager();
			Project pr=em.find(Project.class, projectName);
			securityManager.checkReadPermission(request, pr);

			// Only ADMIN users can export permanently to the export directory
			// for all others (project administrators) a ZIP archive is created for download and deleted if the HTTP session gets invalid 
			boolean exportIsTemporary=(!request.isUserInRole(UserRoleId.RoleName.ADMIN.name()));

			//		String baseDirNameParam=request.getParameter("_export_base_dir");
			//		if(baseDirNameParam!=null){
			//			
			//			baseDirName=baseDirNameParam;
			//		}
			Worker.State status=projectExporter.getStatus();
			if(CMD_START.equals(cmd)){
				MapConverter mapConverter=new MapConverter();
				try {
					@SuppressWarnings("unchecked")
					Map<String,String[]> pMap=request.getParameterMap();
					mapConverter.setBeanProperties(configuration,pMap );
				} catch (MapConverterException e) {
					throw new ControllerException(e);
				}

				synchronized(status){
					if(! (status.isActive())){

						File baseDir=ipsk.webapps.db.servlets.FileServer.getBaseDir();
						String tmpSessPath=null;
						if(!exportIsTemporary){
							// use explicit file path for wikispeech administrators
							exportBaseDir=new File(baseDir,ipsk.webapps.db.servlets.FileServer.EXPORT_DIR);
						}else{
							// use temporary for others (project administrators)
							if(sessionTempDir==null){
								sessionTempDir=ipsk.webapps.db.servlets.FileServer.getTempSessionDirectory(request);
								exportBaseDir=sessionTempDir;
								exportBaseDir.mkdirs();
							}
							tmpSessPath=ipsk.webapps.db.servlets.FileServer.getTempSessionServerPath(request);
							// we need an archive for download
							configuration.setCreateProjectZIPArchive(true);
						}
						//File exportBaseDir=new File(request.getParameter("_output_dir"));
						SimpleDateFormat dateFormat=new SimpleDateFormat("yyyy-MM-dd_HHmmss");
						// It is problematic to use time stamps for file/directory names, because they contain colons (Windows FS does not allow colons) 
						//dateFormat.setTemporalType(TemporalType.DATE);
						String dateStr=dateFormat.format(new Date());
						//					String dateDirName=dateFormat.format(new Date());

						//exportDir=new File(exportBaseDir,dateDirName);
						exportArchivePath=null;
						String uniqueStr="";
						do{
							String exportDirName="wikispeech-export-project-"+projectName+"_"+dateStr+uniqueStr;
							String exportFileName=exportDirName+".zip";
							if(exportIsTemporary){
								exportArchivePath=tmpSessPath+"/"+exportFileName;
							}else{
								exportArchivePath="/"+ipsk.webapps.db.servlets.FileServer.EXPORT_DIR+"/"+exportFileName;
							}
							exportDir=new File(exportBaseDir,exportDirName);
							exportArchiveFile=new File(exportBaseDir,exportFileName);
							uniqueStr="_"+Integer.toString(uniqueCount++);
						}while(exportDir.exists() || exportArchiveFile.exists());

						//					try {
						//						exportDir=FileUtils.createTempDir(getClass().getName(), exportBaseDir);
						//					} catch (IOException e2) {
						//						e2.printStackTrace();
						//						throw new ControllerException(e2);
						//					}
						try {
							projectExporter.close();
						} catch (WorkerException e1) {
							e1.printStackTrace();
							throw new ControllerException(e1);
						}
						projectExporter.reset();
						projectExporter.setOutputBaseDir(exportDir);
						projectExporter.setProjectName(projectName);

						//projectExporter.reset();


						if(configuration.isCreateProjectZIPArchive()){
							projectExporter.setExportArchiveFile(exportArchiveFile);
						}


						try {
							projectExporter.open();
						} catch (WorkerException e) {
							e.printStackTrace();
							throw new ControllerException(e);
						}
						projectExporter.start();
					}

				}
			}else if(CMD_CANCEL.equals(cmd)){
				synchronized(status){
					if(status.equals(Worker.State.RUNNING) || status.equals(Worker.State.STARTED)){
						projectExporter.cancel();
					}
				}
			}else if(CMD_UPDATE_VIEW_AJAX.equals(cmd)){
				if(enableAjax && hasValidSession){
					// TODO wrong place for this code, this should go to the view (but where is the view in an AJAX response?)
					JspFactory jspFactory = JspFactory.getDefaultFactory();
					ajaxPageContext = jspFactory.getPageContext(servlet, request,
							response, "/error.jsp", true, 0, true);
					Page page=new Page();
					ArrayList<Update> updateList=new ArrayList<Update>();

					Update upd=new Update("status");
					upd.setContent(getStatusMessage());
					updateList.add(upd);

					Update aUpd=new Update("actionButton");
					String aCmd=getCommand();
					Attribute aCmdName=new Attribute();
					aCmdName.setName("name");
					aCmdName.setValue("_"+aCmd);
					aUpd.setAttribute(aCmdName);
					updateList.add(aUpd);

					Update updCmdVal=new Update("actionButton");
					Attribute aCmdVal=new Attribute();
					aCmdVal.setName("value");
					String aCmdValVal=aCmd;
					// Code below does not work !!

					//				if(ajaxPageContext!=null){
					//					//Object locCtxtObj=ajaxPageContext.getAttribute("javax.servlet.jsp.jstl.fmt.LocalizationContext");
					//					//Object locCtxtObj = Config.find(ajaxPageContext,Config.FMT_LOCALIZATION_CONTEXT);
					//					Object locCtxtObj=Config.find(ajaxPageContext, Config.FMT_LOCALIZATION_CONTEXT);
					//					//aCmdValVal=LocaleSupport.getLocalizedMessage(ajaxPageContext,"Messages", aCmd);
					//					System.out.println("Bla");
					//				}
					//				
					//				Object locCtxtObj=request.getAttribute("javax.servlet.jsp.jstl.fmt.LocalizationContext");
					//				if(locCtxtObj instanceof javax.servlet.jsp.jstl.fmt.LocalizationContext){
					//				javax.servlet.jsp.jstl.fmt.LocalizationContext locCtxt=(LocalizationContext)locCtxtObj;
					//				ResourceBundle rb=locCtxt.getResourceBundle();
					//				if(rb!=null){
					//				aCmdValVal=rb.getString(aCmd);
					//				}
					//				}



					if (ajaxPageContext != null) {
						String locVal = LocaleSupport.getLocalizedMessage(ajaxPageContext, aCmd);
						if (locVal != null) {
							aCmdValVal = locVal;
						}
						aCmdVal.setValue(aCmdValVal);
						updCmdVal.setAttribute(aCmdVal);
						updateList.add(updCmdVal);

						if (configuration.isCreateProjectZIPArchive()) {
							Update updArchive = new Update("archive_link");
							Attribute archEnableAttr = new Attribute();
							archEnableAttr.setName("disabled");
							if (isDone() && exportArchivePath != null) {
								archEnableAttr.setValue(null);
								// updArchive.setContent("<a href=\""+encodedArchiveURL+"\">ZIP-Archive</a>");
							} else {
								archEnableAttr.setValue("disabled");

							}
							updArchive.setAttribute(archEnableAttr);
							updateList.add(updArchive);
						}
						page.setUpdate(updateList.toArray(new Update[0]));
						Document d;
						try {
							d = dc.createDocument(page);
							// if(encodedArchiveURL!=null){
							// Element updE=d.createElement("update");
							// updE.setAttribute("elementId", "archive_link");
							// Element anch=d.createElement("a");
							// anch.setAttribute("href", encodedArchiveURL);
							// anch.setTextContent("ZIP-Archive");
							// updE.appendChild(anch);
							// NodeList nl=d.getElementsByTagName("page");
							// Node pNode=nl.item(0);
							// ((Element)pNode).appendChild(updE);
							// }
							response.setContentType("text/xml");
							PrintWriter resWriter = response.getWriter();
							dcv.writeXML(d, resWriter);
						} catch (Exception e) {

							e.printStackTrace();
							throw new ControllerException(e);
						}
						jspFactory.releasePageContext(ajaxPageContext);
					}
				}

				return new ProcessResult(ProcessResult.Type.DONE);
			}else{

			}
		}
		return new ProcessResult(ProcessResult.Type.SUCCESS);
	}

	
	
	
		

	
	public void cancel() {
		//super.cancel();
		if(projectExporter!=null){
		projectExporter.cancel();
		}
	}
	
//	public void close() {
//		//super.cancel();
//		if(projectExporter!=null){
//			try {
//				projectExporter.close();
//			} catch (WorkerException e) {
//				e.printStackTrace();
//			}
//		}
//	}
	
//	public String getStatusMessage(){
//		//return status.toString()+message;
//		Locale loc=LocaleSupport.getLocale(ajaxPageContext);
////		ResourceBundle rb;
////		if(currentRequest!=null){
////			loc=currentRequest.getLocale();
//////			rb=ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, loc);
////		}else{
//////			rb=ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME);
////		}
//		StringBuffer msg=new StringBuffer();
//		ProgressStatus ps=projectExporter.getProgressStatus();
//		Worker.State status=projectExporter.getStatus();
//		
//		
//		if(status.equals(Worker.State.CANCEL)){
//			msg.append(ps.getPercentProgress());
//			msg.append(" %");
//			msg.append(LocaleSupport.getLocalizedMessage(ajaxPageContext, "canceling"));
//			msg.append("...");
//		}else if(status.equals(Worker.State.ERROR)){
//			String progressMessage=ps.getMessage().localize(loc);
//
//			if(progressMessage!=null){
//				msg.append("ERROR: ");
//				msg.append(progressMessage);
//			}else{
//				msg.append("ERROR.");
//			}
//		}else if(status.equals(Worker.State.CANCELLED)){
//			String s=LocaleSupport.getLocalizedMessage(ajaxPageContext, "canceled");
//			msg.append(s);
//			msg.append(". ");
//		}else{
//			msg.append(ps.getPercentProgress());
//			msg.append(" %");
//			LocalizableMessage progressMessage=ps.getMessage();
//			if(progressMessage!=null){
//				msg.append(", ");
//				msg.append(progressMessage.localize(loc));
//			}
//		}
//		Long elapsedTime =ps.elapsedTimeMillis();
//		if(elapsedTime!=null){
//			String s=LocaleSupport.getLocalizedMessage(ajaxPageContext, "time.elapsed");
//			msg.append(", "+s+": ");
//			msg.append(elapsedTimeFormat.format(elapsedTime*1000*1000));
//		}
//		Date estimatedFinishTime =ps.estimatedFinishTime();
//		if(estimatedFinishTime!=null){
//			DateFormat df;
//			if(loc!=null){
//				df=DateFormat.getTimeInstance(DateFormat.MEDIUM,loc);
//			}else{
//				df=DateFormat.getTimeInstance(DateFormat.MEDIUM);
//			}
//			msg.append(", ");
//			String s=LocaleSupport.getLocalizedMessage(ajaxPageContext, "time.finish.estimated");
//			msg.append(s);
//			msg.append(": ");
//			msg.append(df.format(estimatedFinishTime));
//		}
//		return msg.toString();
//	}
	
	public boolean isDownloadAvailable(){
		return(isDone() && exportArchivePath!=null);
	}

//	public void run() {
//		status=State.RUNNING;
//		EntityManager em=getEntityManager();
//		// TODO
//		// this is an extra thread. The project object will be detached if the thread terminates
//		project=(Project)em.find(Project.class,projectName);
////		for(Session s:project.getSessions()){
////			message=message.concat(" "+s.getSessionId());
////		try {
////			Thread.sleep(1000);
////		} catch (InterruptedException e) {
////			e.printStackTrace();
////		}
////		}
//		
//		projectExporter.setConfiguration(configuration);
//		boolean complete=false;
//		
//		try {
//			complete=projectExporter.exportProjectToDir(project, exportDir);
//			if(complete && status.equals(State.RUNNING)){
//			FileOutputStream exportArchivestream=new FileOutputStream(exportArchiveFile);
//			ZipPacker zipPacker = new ZipPacker(exportArchivestream);
//			zipPacker.packDirRecursive(exportDir);
//			zipPacker.close();
//			}
//		} catch (Throwable e) {
//			e.printStackTrace();
//			status=State.ERROR;
//		} finally{
//			em.close();
//			synchronized(status){
//				
//				if(status.equals(State.RUNNING)){
//					if(complete){
//						status=State.IDLE;
//					}else{
//						status=State.ERROR;
//					}
//				}else if(status.equals(State.CANCEL)){
//					if(complete){
//						status=State.IDLE;
//					}else{
//						status=State.CANCELLED;
//					}
//				}
//				cancel=false;
//			}
//		}
//		
//	}


	public Project getProject() {
		return project;
	}
	
	public Object getItem(){
		return project;
	}


	public void setProject(Project project) {
		this.project = project;
	}



	public String getProjectName() {
		return projectName;
	}



	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}


	@Override
	public void processRequest(HttpServletRequest request)
			throws ControllerException {
		process(request,null,null);
		
	}


	public PageContext getAjaxPageContext() {
		return ajaxPageContext;
	}


	public void setAjaxPageContext(PageContext ajaxPageContext) {
		this.ajaxPageContext = ajaxPageContext;
	}


	public ProjectExportConfiguration getConfiguration() {
		return configuration;
	}


	public void setConfiguration(ProjectExportConfiguration configuration) {
		this.configuration = configuration;
	}

	
}