package ipsk.webapps.db.speech;

import java.util.HashMap;
import java.util.Map;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.PropertyValidationResult.Type;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.account.InvitationRequest;
import ipsk.util.LocalizableMessage;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.speech.Invitation.Realisation;

public class SpeakerInvitationController extends BasicSpeakerInvitationController<SpeakerInvitation> {

	public static final int DEFAULT_SPEAKER_INVITATION_VALID_TIME_MS=1000*60*60*24*5;  // 5 days
	
	
	public SpeakerInvitationController() {
		super("WebSpeechDBPU",SpeakerInvitation.class);
		setInvitationValidTimeMs(DEFAULT_SPEAKER_INVITATION_VALID_TIME_MS);
	}
	
	public void inviteSpeaker(HttpServletRequest req)
			throws ControllerException {
		invitationLink=null;
		invitationMailToUri=null;
		processResult=null;
		//SpeakerInvitation invModel=new SpeakerInvitation();
		String cmd=processCommand(req,new String[]{"invite","cancel"});
		Map<String,String[]> paramMap=req.getParameterMap();
		String[] projectNames=paramMap.get("project.name");

		Project pr=null;
		if(projectNames!=null && projectNames.length==1){
			projectName=projectNames[0];
		}
		if("invite".equals(cmd)){
			secureRequestTokenProvider.checkSecureRequestToken(req);
			EntityManager em = getThreadEntityManager();
			ValidationResult vr=new ValidationResult();

			pr=em.find(Project.class,projectName);
			if(pr==null){
				throw new ControllerException("Cannot find project.");
			}
			PersistenceMapConverter<SpeakerInvitation> mc=new PersistenceMapConverter<SpeakerInvitation>();
			SpeakerInvitation spkInvitdata=new SpeakerInvitation();
			
			try {
				InternetAddress ias=null;
				mc.setBeanProperties(spkInvitdata,paramMap);
				mc.validateAndSetBeanProperties(spkInvitdata, paramMap, true);
				//PropertyValidationResult emailPvr=checkEmailAddress(em, spkInvitdata);
				PropertyValidationResult emailPvr=null;
				String inputEmailAddress=spkInvitdata.getEmail();
				String inputEmailAddressTrimmed=inputEmailAddress.trim();
				if(inputEmailAddressTrimmed.isBlank()) {
					emailPvr=new PropertyValidationResult(Type.ERROR);
					emailPvr.setValidationMessage(new LocalizableMessage("Blank E-Mail address"));
					
				}else {
					InternetAddress[] iass;
					try {
						iass = InternetAddress.parse(inputEmailAddressTrimmed);
						if(iass==null || iass.length!=1){
							emailPvr=new PropertyValidationResult(Type.ERROR);
						}else{
							ias=iass[0];
							ias.validate();
						}

					} catch (AddressException e1) {
						emailPvr=new PropertyValidationResult(Type.ERROR, e1);
						emailPvr.setValidationMessage(new LocalizableMessage("Error checking E-Mail address \""+inputEmailAddressTrimmed+"\": "+e1.getMessage()));
					}
				}
				if(ias!=null && emailPvr==null){
					String emailUsername=ias.getAddress();
					if(AccountUtils.accountExists(em, emailUsername,true)){
						emailPvr=new PropertyValidationResult(Type.ERROR, new LocalizableMessage("Account with this address already exists!"));
					}
				}
				beanModel=new BeanModel<SpeakerInvitation>(spkInvitdata);
				if(emailPvr==null){
					UserRoleId.RoleName[] roles=new UserRoleId.RoleName[] {UserRoleId.RoleName.SUBJECT};
					if(Realisation.PROVIDE_LINK.equals(spkInvitdata.getRealisation())){
						// Only persist account request
						InvitationRequest ir=invitationRequest(em, null, req, spkInvitdata, roles);
						
						// set controller values for JSP page
						invitationLink=invitationUtils.invitationLink(req,ir.getUuid());
						
						invitationValidUntil=ir.getValidUntil();
//						EditableURI edInvMailToUri=new EditableURI("mailto:"+inputEmailAddressTrimmed);
//						try {
//							// TODO spaces appear as '+'
//							// See https://stackoverflow.com/questions/4737841/urlencoder-not-able-to-translate-space-character
//							// TODO Format valid until
//							edInvMailToUri.appendQuery("subject","WikiSpeech Invitation");
//							edInvMailToUri.appendQuery("body","\n\n\n"+invitationLink+"\n"+invitationValidUntil);
//							
//							//URI mtiuri=new URI("mailto",);
//							
//							
//							invitationMailToUri=URI.create(edInvMailToUri.getUri());
//						} catch (UnsupportedEncodingException e) {
//							e.printStackTrace();
//							// The mailto URI  is then not set
//						}
						
					}else {
						// Persist account request and send email 
						invite(em, req, spkInvitdata,roles );
					}
				}else{
					HashMap<String, String[]> fps=new HashMap<String,String[]>();
					fps.put("email",new String[]{inputEmailAddress});
					emailPvr.setFailedProperties(fps);
					vr.putPropertyValidationResult("email",emailPvr);
					vr.setType(ValidationResult.Type.ERRORS);
					
					beanModel.setValidationResult(vr);
				}
			} catch (MapConverterException e) {
				throw new ControllerException(e);
			}
			processResult=new ProcessResult(vr);
		}else if("cancel".equals(cmd)){
			super.processRequest(req);
		}else{
			beanModel=new BeanModel<SpeakerInvitation>(new SpeakerInvitation());
		}
	}

	public boolean isRealisationProvideLink() {
		boolean isRpl=false;
		SpeakerInvitation si=beanModel.getBean();
		isRpl=(Realisation.PROVIDE_LINK.equals(si.getRealisation()));
		return isRpl;
	}
	
	public void processRequest(HttpServletRequest req){
		Map<String, String[]> paramMap=req.getParameterMap();
		String[] projectNames=(String[]) paramMap.get("project.name");
		
		if(projectNames!=null && projectNames.length==1){
			projectName=projectNames[0];
		}
		beanModel=new BeanModel<SpeakerInvitation>(new SpeakerInvitation());
		processResult=null;
	}
	

}
