package ipsk.webapps.db.speech.project.resources;

import java.io.File;
import java.nio.file.Path;

import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;

import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.db.servlets.FileServer;
import ipsk.webapps.db.speech.BasicResourceFilesystemController;


@WebListener
@MultipartConfig
public class ProjectResourceFilesystemController extends BasicResourceFilesystemController implements ServletContextListener{
	public final static boolean DEBUG=true;
	
	private String currentProjectName=null;

	public void setCurrentProjectName(String currentProjectName) {
		this.currentProjectName = currentProjectName;
	}

	public String getCurrentProjectName() {
		return currentProjectName;
	}

	public ProjectResourceFilesystemController() {
		super();
	}
	
	public void contextInitialized(ServletContextEvent sce) {
		ServletContext servletContext=sce.getServletContext();
		setServletContext(servletContext);
		String baseDirPath = servletContext.getInitParameter(FileServer.BASE_DIR_PARAMETER_KEY);
		if(baseDirPath!=null){
			baseDir=new File(baseDirPath);
			servletContext.log("Base directory set on context initialize: "+baseDir);
//			Path resourcesDir=baseDir.toPath().resolve(FileServer.RESOURCES_DIR);
//			if(!Files.exists(resourcesDir)){
//				try {
//					Files.createDirectory(resourcesDir);
//					
//				} catch (IOException e) {
//					sce.getServletContext().log("ERROR: Could not create resources directory: "+resourcesDir+": "+e.getMessage());
//					return;
//				}
//			}
//			//applicationResourcesDir=resourcesDir;
//			sce.getServletContext().log("Application resource directory set: "+resourcesDir);
		}
	}


	public void contextDestroyed(ServletContextEvent sce) {
		
	}

	protected Path resourcesDirPath(HttpServletRequest req) {
		Path resDir=null;
		if(currentProjectName!=null) {
			Path projectsPath=baseDir.toPath().resolve(FileServer.PROJECTS_DIR);
			Path projectPath=projectsPath.resolve(currentProjectName);
			resDir=projectPath.resolve(FileServer.RESOURCES_DIR);
		}
		return resDir;
	}
	
	protected void applyProjectForProjectAdmin(HttpServletRequest req) throws PermissionDeniedException {
		
		// try to intercept owning project
		Account acc = getAccountByRequest(req);
		if (acc != null && req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			String prjNm=req.getParameter("project.name");
			if(prjNm!=null) {
				EntityManager em=getThreadEntityManager();
				Project prj=em.find(Project.class,prjNm);
				if(prj!=null) {
					securityManager.checkMergePermission(req, prj);
					setCurrentProjectName(prj.getName());
				}else {
					throw new PermissionDeniedException();
				}
			}
		}
		
		
	}
	
	public void processRequest(HttpServletRequest req) throws ControllerException {
		
		applyProjectForProjectAdmin(req);
		super.processRequest(req);
	}
	

	

}
