<!DOCTYPE html>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/ips" prefix="ips"%>
<%@ taglib uri="/wsp" prefix="wsp"%>
<%@ page isELIgnored="false" contentType="text/html; charset=UTF-8"
	session="true" errorPage="/errorPage.jsp"
	import="ipsk.jsp.taglib.*,ipsk.webapps.db.speech.ApplicationResourceFilesystemController"%>
<fmt:setBundle basename="Messages" scope="request" />

<%@page import="ipsk.webapps.EntityManagerFactoryInitializer"%>
<%@page import="ipsk.util.LocalizableMessage"%><html>
<head>
<script src="Resources.js"></script>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle /> - <fmt:message key="project.resources" /></title>
</head>

<body>
	<table class="page">
		<tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
		<tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
		<tr><td class="menu"><%@ include file="/menu.jsp" %></td>
			<td class="content">
				<h2>
					<fmt:message key="project.resources" />
				</h2> 
				<jsp:useBean id="resourcesCtrl" scope="session"
					class="ipsk.webapps.db.speech.project.resources.ProjectResourceFilesystemController" />
				<ips:ctrl_process controller="${resourcesCtrl}" checkSecureRequestToken="true">
				<c:choose>

						<c:when test="${empty resourcesCtrl.currentURIDirPath}">
							<c:set var="currPath" value="" />
						</c:when>

						<c:otherwise>
							<c:set var="currPath" value="${resourcesCtrl.currentURIDirPath}" />
						</c:otherwise>
					</c:choose>
					<table border="0px">
						<tr>
							<form
								action="<c:url value="/prjdb/project/resources/Resources.jsp"/>"
								method="post" enctype="application/x-www-form-urlencoded">
								<ips:psecuretoken/>
								<input type="hidden" name="_cmd" value="mkdir"> <input
									type="hidden" name="_path" value="<c:out value="${currPath}"/>">
								<c:if test="${param['project.name'] != null }">
									<input type="hidden" name="project.name"
										value="<c:out value="${param['project.name']}"/>">
								</c:if>
								<td><i class="material-icons">add_box</i> Name of new
									directory:</td>
								<td><input id="newDirNameField" type="text" name="dirname" oninput="ips_resources_enable_mkdir()"></td>
								<td><input id="mkdirButt" type="submit" name="_mkdir" value="Create directory" disabled="disabled"></td>
							</form>
						</tr>
						<tr>
							<h4>Resources filesystem for project <c:out value="${resourcesCtrl.currentProjectName}"/></h4>
							<form
								action="<c:url value="/prjdb/project/resources/Resources.jsp"/>"
								method="post" enctype="multipart/form-data">
								<ips:psecuretoken/>
								<input type="hidden" name="_cmd" value="upload"> 
								<input type="hidden" name="_path" value="<c:out value="${currPath}"/>">
								<c:if test="${param['project.name'] != null }">
									<input type="hidden" name="project.name"
										value="<c:out value="${param['project.name']}"/>">
								</c:if>
								<td><i class="material-icons">cloud_upload</i> Upload media
									resource file to current directory:</td>
								<td><input id="uploadFile" type="file" name="file" onchange="ips_resources_enable_upload()"></td>
								<td><input id="uploadButt" type="submit" name="_upload" value="Upload" disabled="disabled"></td>
							</form>
						</tr>
					</table>

					
					<p>Current path:  <code><c:out value="resources/${currPath}${resourcesCtrl.currentFilename}" /></code></p>
					
					<form id="vFileSystemSelectForm"
								action="<c:url value="/prjdb/project/resources/Resources.jsp"/>"
								method="post" enctype="application/x-www-form-urlencoded">
							<ips:psecuretoken/>
					<table border="0px" style="margin-bottom: 3em">
						<c:url value="/prjdb/project/resources/Resources.jsp"
							var="resUpURL">
							<c:if test="${param['project.name'] != null }">
									<input type="hidden" name="project.name"
										value="<c:out value="${param['project.name']}"/>">
							</c:if>
							<c:param name="_path" value="${currPath}.." />
						</c:url>
						<c:if test="${resourcesCtrl.upDirPossible}">
							<tr>
								<td><a href="${resUpURL}"><i class="material-icons">folder</i></a></td>
								<td><a href="${resUpURL}">..</a></td>
							</tr>
						</c:if>
						<c:forEach items="${resourcesCtrl.fileItems}" var="fileItem">
							<c:url value="/prjdb/project/resources/Resources.jsp"
								var="resURL">
								<c:if test="${param['project.name'] != null }">
									<input type="hidden" name="project.name"
										value="<c:out value="${param['project.name']}"/>">
								</c:if>
								<c:param name="_path" value="${currPath}${fileItem.file.name}" />
								<c:param name="_action" value="${param._action}" />
							</c:url>
							<c:url value="${param._action}" var="fileURL">
								<c:param name="_path" value="${currPath}${fileItem.file.name}" />
							</c:url>
							<tr>
								<td>
									<c:choose>
									<c:when test="${resourcesCtrl.deleteSelectedRequest or !fileItem.fileOrEmptyDir}">
										<c:if test="${fileItem.selected}">
											<input type="hidden" name="_select" value="${fileItem.file.name}" value="${fileItem.file.name}"/>
										</c:if>
										<input type="checkbox" name="_select_dummy" value="${fileItem.file.name}"<c:if test="${fileItem.selected}"> checked="checked"</c:if> disabled="disabled"/>
									</c:when>
									<c:otherwise>
										<input onchange="ips_resources_enableDeleteButton()"  type="checkbox" name="_select" value="${fileItem.file.name}"<c:if test="${fileItem.selected}"> checked="checked"</c:if><c:if test="${resourcesCtrl.deleteSelectedRequest or !fileItem.fileOrEmptyDir}"> readonly="readonly"</c:if>/>
									</c:otherwise>
									</c:choose>
								<td>
								<td><c:if test="${fileItem.file.directory}">
										<a href="${resURL}"><c:if test="${fileItem.selected}"><span style="color:red"></c:if><i class="material-icons">folder</i><c:if test="${fileItem.selected}"></span></c:if></a>
									</c:if>
								</td>
								<td ><c:if test="${fileItem.file.directory}">
										<a href="${resURL}"><c:if test="${fileItem.selected}"><span style="color:red"></c:if><c:out value="${fileItem.file.name}"/><c:if test="${fileItem.selected}"></span></c:if></a>
									</c:if>
									<c:if test="${!fileItem.file.directory}">
										<c:if test="${fileItem.selected}"><span style="color:red"></c:if><c:out value="${fileItem.file.name}" /><c:if test="${fileItem.selected}"></span></c:if>
									</c:if></td>
							</tr>
						</c:forEach>
					</table>

					<c:choose>
					 <c:when test="${resourcesCtrl.deleteSelectedRequest}">
					 	<p class="warn"><fmt:message key="deletion.cannot.be.undone"/></p>
					   <input style="background-color:red" type="submit" name="_delete" value="Delete selected"/> <input type="submit" name="_cancel" value="Cancel"/>
					 </c:when>
					 <c:otherwise>
						<input id="deleteRequestButton" type="submit" name="_delete_request" value="Delete selected..." style="visibility:hidden" disabled="disabled"/>
					 </c:otherwise>
					 </c:choose>
					</form>
				</ips:ctrl_process>
	</table>
</body>
</html>
