<!DOCTYPE html>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>

<%@ page  isELIgnored="false" contentType="text/html; charset=UTF-8" session="true" errorPage="/errorPage.jsp" import="ipsk.db.speech.SpeechRecorderClient" %>
<fmt:setBundle basename="Messages" scope="request"/>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <c:choose><c:when test="${param._test_session == 'true'}"><fmt:message key="session.test.new"/></c:when><c:otherwise><fmt:message key="session.new"/></c:otherwise></c:choose></title>

</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
 <h2><c:choose><c:when test="${param._test_session == 'true'}"><fmt:message key="session.test.new"/></c:when><c:otherwise><fmt:message key="session.new"/></c:otherwise></c:choose></h2>		 

<jsp:useBean id="sessCtrl" scope="session" class="ipsk.webapps.db.speech.SessionController" />

<p><fmt:message key="session.add.confirm"><fmt:param value="${sessCtrl.item.sessionId}"/></fmt:message></p>
<c:url value="Webrecorder.jnlp" var="webrecorderURL">
<c:param name="_cmd" value="store"/>
<c:param name="sessionId" value="${sessCtrl.item.sessionId}"/>
<c:param name="status" value="STARTED"/>
</c:url>

<c:choose>
 <c:when test="${empty sessCtrl.item.script}">
 <c:url value="/lib/ng/recorder" var="webrecorderHtml5AngularURL">
<c:param name="sessionId" value="${sessCtrl.item.sessionId}"/>
</c:url>
</c:when>
<c:otherwise>
 <c:url value="/lib/ng" var="webrecorderHtml5AngularURL">
<c:param name="sessionId" value="${sessCtrl.item.sessionId}"/>
</c:url>
</c:otherwise>
</c:choose>

<c:url value="webspeechrecorder/index.jsp" var="webrecorderHtml5URL">
<c:param name="sessionId" value="${sessCtrl.item.sessionId}"/>
</c:url>
<c:if test="${fn:length(sessCtrl.selectedProject.allowedSpeechRecorderClients)>1}">
<p>SpeechRecorder: <c:out value="${sessCtrl.item.speechRecorderClient}"/></p>
</c:if>
<c:if test="${sessCtrl.item.speechRecorderClient eq 'SINGLE_SESSION_WEBSTART'}">
<form method="post" action="<c:out value="${webrecorderURL}"/>">
<input type="submit" name="submit" value="<fmt:message key="cmd.start_session"/> &gt;&gt;"/>
</form>
<p><fmt:message key="speechrecorder.webstart"/></p>
<p id="webstartHints"></p>
</c:if>

<c:if test="${sessCtrl.item.speechRecorderClient eq 'HTML5_ANGULAR'}"> 
<form method="post" action="<c:out value="${webrecorderHtml5AngularURL}"/>">
<input type="submit" name="submit" value="<fmt:message key="cmd.start_session"/> &gt;&gt;"/>
</form>
</c:if>

</td></tr>
</table>
</body>
</html>
