package ipsk.webapps.db.servlets;

import ipsk.apps.speechrecorder.storage.net.HTTPStorageProtocol;
import ipsk.db.speech.Session;
import ipsk.webapps.db.speech.SessionController;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class SessionAuthenticator {
	private HttpServletRequest req;

	public SessionAuthenticator(HttpServletRequest req) {
		this.req = req;
	}

	public Session checkSessionAuthentication(SessionController sessCtrl) {

		boolean recSessionAuthenticated = false;
		Cookie[] cookies = req.getCookies();
		for (Cookie cookie : cookies) {

			String cookieName = cookie.getName();
			String cookieValue = cookie.getValue();
			// if (DEBUG)
			// log("Check cookie for authentication: " +
			// cookieName+": "+cookieValue+"; Path: "+cookie.getPath());
			if (HTTPStorageProtocol.SESSION_INSTANCE_ID_KEY.equals(cookieName)) {
				int sessionInstanceId;
				try {
					sessionInstanceId = Integer.parseInt(cookieValue);
				} catch (NumberFormatException nfe) {
					// log("cannot parse session instance ID as number: "+cookieValue);
					continue;
				}
				Session sess = sessCtrl.getById(sessionInstanceId);
				String sessJSessionId = sess.getHttpSessionId();
				if (sessJSessionId != null) {
					for (Cookie jSessionIdcookie : cookies) {
						String cookieName2 = jSessionIdcookie.getName();
						if ("JSESSIONID".equalsIgnoreCase(cookieName2)) {
							String jsessionId = jSessionIdcookie.getValue();
							if (sessJSessionId.equals(jsessionId)) {
								recSessionAuthenticated = true;
								break;
							}
						}
					}
				}
				if (recSessionAuthenticated)
					return sess;
			}
		}
		return null;
	}
}
