package ipsk.webapps.db.speech;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

import ipsk.db.speech.UserRoleId;
import ipsk.io.StreamCopy;
import ipsk.jsp.Controller;
import ipsk.text.StringTokenizer;
import ipsk.text.quoting.QuoteParser;
import ipsk.text.quoting.TextPart;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.ProcessResult.Type;
import ipsk.webapps.db.servlets.FileServer;



@WebListener
@MultipartConfig
public class ApplicationResourceFilesystemController extends BasicResourceFilesystemController implements ServletContextListener{

	
	//private Path applicationResourcesDir=null;
	
	public ApplicationResourceFilesystemController() {
		super();
	}
	
	
	public void contextInitialized(ServletContextEvent sce) {
		String baseDirPath = sce.getServletContext().getInitParameter(FileServer.BASE_DIR_PARAMETER_KEY);
		if(baseDirPath!=null){
			baseDir=new File(baseDirPath);
			sce.getServletContext().log("Base directory set on context initialize: "+baseDir);
//			Path resourcesDir=baseDir.toPath().resolve(FileServer.RESOURCES_DIR);
//			if(!Files.exists(resourcesDir)){
//				try {
//					Files.createDirectory(resourcesDir);
//					
//				} catch (IOException e) {
//					sce.getServletContext().log("ERROR: Could not create resources directory: "+resourcesDir+": "+e.getMessage());
//					return;
//				}
//			}
//			//applicationResourcesDir=resourcesDir;
//			sce.getServletContext().log("Application resource directory set: "+resourcesDir);
		}
	}


	public void contextDestroyed(ServletContextEvent sce) {
		
	}

	@Override
	protected Path resourcesDirPath(HttpServletRequest req) {
		Path resourcesDir=baseDir.toPath().resolve(FileServer.RESOURCES_DIR);
		return resourcesDir;
	}

}
