package ipsk.webapps.db.speech;

import java.util.Set;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import ipsk.beans.validation.ValidationException;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Account;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.SpeechRecorderClient;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.UserRoleId.RoleName;
import ipsk.webapps.BasicPersistenceBeanController;

public class BasicWikiSpeechController<T> extends BasicPersistenceBeanController<T> {
	
	public final static String ATTR_KEY_SELECTED_PROJECT="corpusmachine_project";
	
	public BasicWikiSpeechController(String persistenceUnit, Class<T> queryType) {
		super(persistenceUnit, queryType);
		securityManager=new WikiSpeechSecurityManager(this);
	}

	public BasicWikiSpeechController(String persistenceUnit, Class<T> queryType,
			String jsfIdentifier) {
		super(persistenceUnit, queryType, jsfIdentifier);
		securityManager=new WikiSpeechSecurityManager(this);
	}
	public Account getSessionAccount(){
		return getAccountByRequest(currentRequest);
	}
	public Account getAccountByRequest(HttpServletRequest req){
		currentRequest=req;
		EntityManager em=getThreadEntityManager();
		if(em!=null) {
			return AccountController.getAccountByRequest(req, em);
		}
		return null;
	}
	public String getSessionAccountLogin(){
		Account acc=getAccountByRequest(currentRequest);
		if(acc!=null){
			return acc.getLogin();
		}
		return null;
	}
	
	public Project getSelectedProject() {
		return getSelectedProject(currentRequest);
	}
	
	public static String selectedProjectName(HttpServletRequest req) {
		HttpSession sess=req.getSession();
		String selProjectName = null;
		if(sess!=null){
			Object selProjectNameObj=sess.getAttribute(ATTR_KEY_SELECTED_PROJECT);
			if(selProjectNameObj instanceof String){
				selProjectName=(String)selProjectNameObj;
			}
		}
		return selProjectName;
	}
	
	public Project getSelectedProject(HttpServletRequest req) {
		currentRequest=req;
		HttpSession sess=req.getSession();
		EntityManager em = getThreadEntityManager();
		Project selProject=null;
		
		String selProjectName=selectedProjectName(req);
		if(selProjectName!=null){
			selProject=em.find(Project.class, selProjectName);
		}

		if (selProject == null) {
			
			Account acc = getAccountByRequest(req);
			if(acc!=null){
				if (req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN
						.name())) {
					Set<Project> admProjs = acc.getAdminOfProjects();
					if (admProjs.size() == 1) {
						selProject = admProjs.toArray(new Project[0])[0];
					}
				} else if (req.isUserInRole(UserRoleId.RoleName.ORGANISATION.name())) {
					Organisation accOrga = acc.getOrganisation();
					if (accOrga != null) {
						Set<Project> accProjs = accOrga.getProjects();
						if (accProjs.size() == 1) {
							selProject = accProjs.toArray(new Project[0])[0];
						}
					}
				}
			}
		}else{
			// refresh
			//selProject=(Project)em.find(Project.class,selProject.getName());
			//if(selProject!=null){
			//em.refresh(selProject);
			//}
			
			sess.setAttribute(ATTR_KEY_SELECTED_PROJECT,selProject.getName());
		}
		if(selProject!=null) {
			em.refresh(selProject);
		}
		return selProject;
	}
	public int getSpeakerId(){
		Speaker sp=null;
		Account acc = getAccountByRequest(currentRequest);
		sp=getSpeaker(acc);
		return sp.getPersonId();
	}
	
	public Speaker getSpeakerDataForSelectedProject(Account acc){
		Project selProject=getSelectedProject();
		if(selProject!=null) {
		Set<Speaker> spkDatas=acc.getSpeakerData();
		for(Speaker spkData:spkDatas) {
			Project spkDataPrj=spkData.getProject();
			if(selProject.equals(spkDataPrj)) {
				return spkData;
			}
		}
		}
		return null;
	}
	
	public Speaker getSpeaker(Account acc){
		if(acc!=null) {
			Speaker spkPrjData=getSpeakerDataForSelectedProject(acc);
			if(spkPrjData!=null) {
				return spkPrjData;
			}
			Person p=acc.getPerson();
			if(p instanceof Speaker){
				return (Speaker)p;
			}
		}
		return null;
	}
	
	public boolean getSpeakerDataAvailable(HttpServletRequest req){
		Account acc = getAccountByRequest(req);
		Speaker spk=null;
		spk= getSpeaker(acc);
		return (spk!=null);
	}
	
	
	
	public boolean getSpeakerDataAvailable(){
		return getSpeakerDataAvailable(currentRequest);
	}
	
	public boolean getSpeakerDataComplete(){
		boolean compl=false;
		
		Account acc = getAccountByRequest(currentRequest);
		Speaker sp=getSpeaker(acc);
		if(sp!=null) {
			compl=speakerDataComplete(sp);
		}
		return compl;
	}
	
	public boolean speakerDataComplete(Speaker sp) {
		SpeakerController spkCtrl=new SpeakerController();
		spkCtrl.setCurrentRequest(currentRequest);
		spkCtrl.setFormConfigurationFromProject(true);
		spkCtrl.setSpeaker(sp);
		ValidationResult vr;
		try {
			vr = spkCtrl.validate(sp, null);
		} catch (ValidationException e) {
			return false;
		}
		if(vr==null){
			return true;
		}else{
			return vr.isValid();
		}
		
	}
	
	
	public boolean getSelfRecordingSessionAllowed(){
		boolean allowed=false;
		Account acc = getAccountByRequest(currentRequest);
		if(acc!=null){
			
			if(currentRequest.isUserInRole(RoleName.SUBJECT.getName())){
				Project selProject=getSelectedProject(currentRequest);
				if(selProject!=null){
					Organisation accOrga=acc.getOrganisation();
					Set<Organisation> prjOrgas=selProject.getOrganisations();
					Set<Project> accProjs=acc.getProjects();
					Set<Project> accAdmProjs=acc.getAdminOfProjects();
					allowed=(accProjs!=null && accProjs.contains(selProject)) ||
							(accAdmProjs!=null && accAdmProjs.contains(selProject)) ||
							(prjOrgas!=null && prjOrgas.contains(accOrga));


				}
			}
		}
		return allowed;
	}
	
	public boolean getUsesJavaWebStart(){
		
		Account acc = getAccountByRequest(currentRequest);
		if(acc!=null){
			
			if(currentRequest.isUserInRole(RoleName.SUBJECT.getName())){
				Project selProject=getSelectedProject(currentRequest);
				if(selProject!=null){
					return(selProject.getAllowedSpeechRecorderClients().contains(SpeechRecorderClient.SINGLE_SESSION_WEBSTART));
				}
			}
		}
		return false;
	}
	
	public static String getATTR_KEY_SELECTED_PROJECT() {
		return ATTR_KEY_SELECTED_PROJECT;
	}
	
	
	
	
}
