package ipsk.webapps.db.speech;

import java.util.Locale;

import ipsk.db.speech.FormConfiguration;
import ipsk.db.speech.LocalizableMessage;
import ipsk.db.speech.LocalizedMessage;
import ipsk.db.speech.Speaker;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;

public class FormConfigurationController extends BasicPersistenceBeanController<FormConfiguration> {

	
	public FormConfigurationController() {
		super("WebSpeechDBPU",FormConfiguration.class, "form_configuration");
		securityManager=new WikiSpeechSecurityManager(this);
	}
	public FormConfigurationController(String persistenceUnit, String jsfIdentifier) {
		super(persistenceUnit, FormConfiguration.class, jsfIdentifier);
		securityManager=new WikiSpeechSecurityManager(this);
	}
	
	
	String[] getISOLanguageCodeList(){
		return Locale.getISOLanguages();
		
	}
	
	public String getSpeakerFormClassId() {
		return FormDefinitions.SPEAKER_FORM_CLASS_ID;
	}
	
	public String getFormTypeNameResourceKey() {
		FormConfiguration fc;
		try {
			fc = getItem();
			return formTypeNameResourceKey(fc);
		} catch (ControllerException e) {
			// return null
		}
		
		return null;
	}
	
	public String formTypeNameResourceKey(FormConfiguration fc) {
		
		if(fc!=null) {
			String propClassId=fc.getPropertyClassId();
			return FormDefinitions.formTypeNameResourceKey(propClassId);
		}
		return null;
	}
}
