package ipsk.webapps.db.speech;

import java.util.Map;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ips.beans.PersistenceMapConverter;
import ipsk.beans.BeanModel;
import ipsk.beans.MapConverterException;
import ipsk.beans.PropertyValidationResult;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.account.InvitationRequest;
import ipsk.webapps.ControllerException;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.db.speech.Invitation.Realisation;

public class ProjectAdminInvitationController extends BasicInvitationController<ProjectAdminInvitation> {

	public ProjectAdminInvitationController() {
		super("WebSpeechDBPU",ProjectAdminInvitation.class);
		
	}

	public void inviteProjectAdmin(HttpServletRequest req)
			throws ControllerException {
		invitationLink=null;
		invitationMailToUri=null;
		processResult=null;
		String cmd=processCommand(req,new String[]{"invite","cancel"});
		Map<String,String[]> paramMap=req.getParameterMap();
		String[] projectNames=paramMap.get("project.name");

		Project pr=null;
		if(projectNames!=null && projectNames.length==1){
			projectName=projectNames[0];
		}
		
		if("invite".equals(cmd)){
			secureRequestTokenProvider.checkSecureRequestToken(req);
			EntityManager em = getThreadEntityManager();
			ValidationResult vr=new ValidationResult();

			pr=em.find(Project.class,projectName);
			if(pr==null){
				throw new ControllerException("Cannot find project.");
			}
			PersistenceMapConverter<ProjectAdminInvitation> mc=new PersistenceMapConverter<ProjectAdminInvitation>();
			ProjectAdminInvitation paInvitdata=new ProjectAdminInvitation();
			try {
				mc.setBeanProperties(paInvitdata,paramMap);
				mc.validateAndSetBeanProperties(paInvitdata, paramMap, true);
				PropertyValidationResult emailPvr=checkEmailAddress(em, paInvitdata);
				beanModel=new BeanModel<ProjectAdminInvitation>(paInvitdata);
				if(emailPvr==null){
					UserRoleId.RoleName[] roles=new UserRoleId.RoleName[] {UserRoleId.RoleName.PROJECT_ADMIN};
					if(Realisation.PROVIDE_LINK.equals(paInvitdata.getRealisation())){
						// Only persist account request
						InvitationRequest ir=invitationRequest(em, null, req, paInvitdata, roles);
						
						// set controller values for JSP page
						invitationLink=invitationUtils.invitationLink(req,ir.getUuid());
						
						invitationValidUntil=ir.getValidUntil();
						
					}else {
						invite(em, req, paInvitdata,roles );
					}
				}else{
					vr.putPropertyValidationResult("email",emailPvr);
					vr.setType(ValidationResult.Type.ERRORS);
					if(beanModel==null){
						beanModel=new BeanModel<ProjectAdminInvitation>(new ProjectAdminInvitation());
					}
					beanModel.setValidationResult(vr);
				}
			} catch (MapConverterException e) {
				vr.setType(ValidationResult.Type.ERRORS);
			}
			processResult=new ProcessResult(vr);
		}else{
			beanModel=new BeanModel<ProjectAdminInvitation>(new ProjectAdminInvitation());
		}
	}
	
	public boolean isRealisationProvideLink() {
		boolean isRpl=false;
		ProjectAdminInvitation si=beanModel.getBean();
		isRpl=(Realisation.PROVIDE_LINK.equals(si.getRealisation()));
		return isRpl;
	}
	
	public void processRequest(HttpServletRequest req){
		Map<String, String[]> paramMap=req.getParameterMap();
		String[] projectNames=(String[]) paramMap.get("project.name");
		
		Project pr=null;
		if(projectNames!=null && projectNames.length==1){
			projectName=projectNames[0];
		}
		beanModel=new BeanModel<ProjectAdminInvitation>(new ProjectAdminInvitation());
		processResult=null;
	}

}
