package ipsk.webapps.db.speech;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import javax.management.relation.RoleNotFoundException;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ipsk.db.speech.Account;
import ipsk.db.speech.UserRole;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.UserRoleId.RoleName;
import ipsk.persistence.ParameterizedQuery;
import ipsk.persistence.QueryParam;
import ipsk.webapps.BasicPersistenceBeanController;
import ipsk.webapps.ControllerException;
import ipsk.webapps.PermissionDeniedException;

public class UserRoleController extends BasicPersistenceBeanController<UserRole> {
	
	
	public UserRoleController() {
		super("WebSpeechDBPU",UserRole.class, "user_role");
		securityManager=new WikiSpeechSecurityManager(this);
	}
//	public UserRoleController(String persistenceUnit, Class queryType, String jsfIdentifier) {
//		super(persistenceUnit, queryType, jsfIdentifier);
//		securityManager=new WikiSpeechSecurityManager(this);
//		
//	}

	public RoleName[] getUserRoleNames(){
		return RoleName.values();
	}
	
//	public RoleName[] getAssignableUserRoleNames(HttpServletRequest req){
//		RoleName[] allValues=RoleName.values();
//		if(req.isUserInRole(UserRoleId.RoleName.ADMIN.name())){
//		return allValues;
//		}else if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())){
//			return new RoleName[] {UserRoleId.RoleName.ORGANISATION};
//		}else{
//			return new RoleName[0];
//		}
//	}
	
	public RoleName[] getAssignableUserRoleNames() throws ControllerException{
		HttpServletRequest req=currentRequest;
		RoleName[] allValues=RoleName.values();
		ArrayList<RoleName> retValues=new ArrayList<RoleName>();
		HashSet<RoleName> alreadyAssignedRoleNames=new HashSet<RoleName>();
		UserRole userRole=null;
			userRole = (UserRole)getItem();
		
		if(userRole!=null){
			Account urAcc=userRole.getAccount();
			if(urAcc!=null){
		for(UserRole ur:urAcc.getUserRoles()){
			alreadyAssignedRoleNames.add(ur.getId().getRoleName());
		}
			}
		}
		if(req.isUserInRole(UserRoleId.RoleName.ADMIN.name())){
			for(RoleName rn:allValues){
				if(!alreadyAssignedRoleNames.contains(rn)){
					retValues.add(rn);
				}
			}
		}else if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())){
			if(!alreadyAssignedRoleNames.contains(UserRoleId.RoleName.ORGANISATION)){
			retValues.add(UserRoleId.RoleName.ORGANISATION);
			}
		}
		
		return retValues.toArray(new RoleName[0]);
		
	}
	
	public void userRolesOfAccount(HttpServletRequest req,Account acc) throws ControllerException{
		EntityManager em=getThreadEntityManager();
			ParameterizedQuery pq = new ParameterizedQuery(queryType);
			String jse = ParameterizedQuery.JPQL_SELECT_EXPRESSION;
			pq.setWhereClause(jse +".account = :account");

			pq.setQueryParams(new QueryParam[] { new QueryParam("account", acc) });
			setParameterizedQuery(pq);
			processListRequest(req);
		
	}
	
	
	


}
