package ipsk.webapps.db.speech.ws;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.SessionDTO;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.script.Script;
import ipsk.persistence.EntityManagerProvider;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.db.speech.AccountController;
import ipsk.webapps.db.speech.WikiSpeechSecurityManager;

@Path("/session")
public class SessionResource extends WikispeechBasicResource<Session>{

	private WikispeechBasicResource<Speaker> relSpeakerRes=new WikispeechBasicResource<Speaker>(Speaker.class);
	
	public SessionResource() {
		super(Session.class);
	}


//	// TODO duplicate code in SpeakerResource
//	private Speaker byUUID(EntityManager em,UUID speakerUUID){
//		CriteriaBuilder cb = em.getCriteriaBuilder();
//		CriteriaQuery<Speaker> cq = cb.createQuery(Speaker.class);
//		Root<Speaker> rt = cq.from(Speaker.class);
//		cq.select(rt);
//		cq.where(cb.equal(rt.get("uuid"), speakerUUID.toString()));
//
//		TypedQuery<Speaker> q = em.createQuery(cq);
//		List<Speaker> spksList=q.getResultList();
//		if(spksList.isEmpty()){
//			return null;
//		}else{
//			return spksList.get(0);
//		}
//	
//	}

	
	@GET
	@Produces({MediaType.APPLICATION_JSON,MediaType.APPLICATION_XML})
	@Path("/{sessionId}")
	public Response getSession(@Context HttpServletRequest req,@PathParam("sessionId") String sessionIdStr){
		EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		try{	
			int sessionId=Integer.parseInt(sessionIdStr);
			Session s=em.find(Session.class, sessionId);
			WikiSpeechSecurityManager securityManager = new WikiSpeechSecurityManager(new EntityManagerProvider() {
				@Override
				public EntityManager getThreadEntityManager() {
					return em;
				}
			});
			if(!securityManager.getReadPermission(req, s)){
				return Response.status(Status.FORBIDDEN).build();
			}
			return Response.ok(s).build();
		}finally{
			em.close();
		}
	}
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/{sessionUUID}")
	public Response storeSession(@Context HttpServletRequest req,@PathParam("sessionUUID") String sessionUUIDStr,SessionDTO sessionDto){
		EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
		WikiSpeechSecurityManager securityManager = new WikiSpeechSecurityManager(new EntityManagerProvider() {
			@Override
			public EntityManager getThreadEntityManager() {
				return em;
			}
		});

		String sessionDtoUuid=sessionDto.getUuid();
		
		UUID sessionUUID=null;
		
		try{
		// try to get from path
		if(sessionUUIDStr!=null){
			sessionUUID=UUID.fromString(sessionUUIDStr);
			// if UUID is given in data object as well the UUIDs must match
			if(sessionDtoUuid!=null && !sessionDtoUuid.equals(sessionUUID.toString())){
				// Mismatch of UUIDs 
				return Response.status(Status.BAD_REQUEST).build();
			}
		}else{
			if(sessionDtoUuid!=null){
				// try to get from DTO
				sessionUUID=UUID.fromString(sessionDtoUuid);
			}else{
				// no UUID transmitted, create one
				sessionUUID=UUID.randomUUID();
			}
		}
		}catch(IllegalArgumentException iae){
			// UUID string could not be parsed
			return Response.status(Status.BAD_REQUEST).build();
		}
		
		if(sessionDtoUuid==null){
			// set UUID to object
			sessionDto.setUuid(sessionUUID.toString());
		}
		
		try{
			Session existingSess=entityByUUID(em, sessionUUID);
			if(existingSess!=null){
				return Response.status(Status.CONFLICT).build();
			}
			Session session=sessionDto.toSession();
			
			
			EntityTransaction tr=em.getTransaction();
			tr.begin();
			if(!securityManager.getPersistPermission(req, session)){
				return Response.status(Status.FORBIDDEN).build();
			}
			em.persist(session);
			
			Project p=em.find(Project.class,sessionDto.getProject());
			session.setProject(p);
			
			Account acc=AccountController.getAccountByRequest(req, em);
			if(p!=null) {
				if(!(p.getAccounts().contains(acc) || p.getAdminAccounts().contains(acc))) {
					tr.rollback();
					em.close();
					return Response.status(Status.FORBIDDEN).build();
				}
			}
			
			em.merge(p);
			
			int scriptId=Integer.parseInt(sessionDto.getScript());
			Script sc=em.find(Script.class, scriptId);
			
			if(sc!=null) {
				Set<Project> scriptowningProjs=sc.getProjects();
				if(scriptowningProjs.size()>0) {
					boolean owned=false;
					for(Project sop:scriptowningProjs) {
						if(sop.getAccounts().contains(acc) || sop.getAdminAccounts().contains(acc)) {
							owned=true;
							break;
						}
					}
					if(!owned) {
						return Response.status(Status.FORBIDDEN).build();
					}
				}
			}
	
			session.setScript(sc);
			em.merge(sc);

			for(String spkIdStr:sessionDto.getSpeakers()){
				Speaker spk=null;
				try{
					UUID speakerUUID=UUID.fromString(spkIdStr);
//					spk=byUUID(em, speakerUUID);
					spk=relSpeakerRes.entityByUUID(em,speakerUUID);
					if(spk==null){
						tr.rollback();
						return Response.status(Status.BAD_REQUEST).build();
					}
				}catch(IllegalArgumentException iae){
					try{
					int spkId=Integer.parseInt(spkIdStr);
						spk=em.find(Speaker.class, spkId);
					}catch(NumberFormatException nfe){
						tr.rollback();
						return Response.status(Status.BAD_REQUEST).build();
					}
				}
			
				session.getSpeakers().add(spk);
				spk.getSessions().add(session);
				em.merge(spk);
			}
			
			em.merge(session);
			
			tr.commit();
			
			return Response.ok(session).build();
			
		}finally{
			em.close();
		}
	}
	
	
	@GET
	@Produces({MediaType.APPLICATION_JSON,MediaType.APPLICATION_XML})
	public Response allSessions(@Context HttpServletRequest req){
		if(req.isUserInRole(UserRoleId.RoleName.ADMIN.name())){
			EntityManager em=EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
			try{	
				CriteriaBuilder cb = em.getCriteriaBuilder();
				CriteriaQuery<Session> cq = cb.createQuery(Session.class);
				Root<Session> rt = cq.from(Session.class);
				cq.select(rt);
				TypedQuery<Session> q = em.createQuery(cq);
				List<Session> allSesss = q.getResultList();
				final GenericEntity<List<Session>> listEntity = new GenericEntity<List<Session>>(allSesss) {};
				return Response.ok(listEntity).header("X-Total-Count", allSesss.size()).build();

			}finally{
				em.close();
			}
		}else {
			return Response.status(Status.FORBIDDEN).build();
		}
	}
	
	
	/**
	 * Recording  file sub resource upload
	 * @param sc
	 * @param sec
	 * @param sessionIdStr
	 * @return
	 */
	@Path("/{sessionIdOrUUID}/recfile")
	public SessionRecfileResource postRecfile(@PathParam("sessionIdOrUUID") String sessionIdStr) {

		SessionRecfileResource refFileRs = new SessionRecfileResource(sessionIdStr);
		return refFileRs;

	}
	
}
