<!DOCTYPE html>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" session="true" import="java.util.*,java.text.*,ipsk.webapps.*,ipsk.webapps.db.speech.*,javax.servlet.jsp.jstl.fmt.LocaleSupport"  errorPage="/errorPage.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"  %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/ips" prefix="ips" %>
<%@ taglib uri="/wsp" prefix="wsp" %>
<fmt:setBundle basename="Messages" scope="session"/>

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<%@ include file="/stylesheets.jsp" %>
<title><wsp:appTitle/> - <fmt:message key="login"/></title>
</head>

<body>
 <table class="page">
 <tr><td colspan="2"><%@ include file="/logoTd.jsp" %></td></tr>
 <tr><td class="contentw" colspan="2"><%@ include file="/titletoolbar.jsp" %></td></tr>
 <tr><td class="menu"><%@ include file="/menu.jsp" %></td>
 <td class="content">
<h2><fmt:message key="login"/></h2>
<form name="loginform" action="login_check" method="POST" accept-charset="UTF-8">
   <table>
    <tr><td><fmt:message key="login"/>:</td><td><input id="username" type="text" name="j_username" value="${param.login}" <c:if test="${empty param.login}">autofocus</c:if>/></td></tr>
    <tr><td><fmt:message key="password"/>:</td><td><input id="password" type="password" name="j_password" <c:if test="${not empty param.login}">autofocus</c:if>/></td></tr> 
   </table>
   <button type="submit"><i class="fas fa-sign-in-alt"></i> <fmt:message key="login"/></button>
</form>
<c:if test="${param.status=='failed'}">
<div id="loginFailedDiv">
 <p><fmt:message key="user.name"/>: <c:out value="${param.j_username}"/></p>
 <c:choose>
   <c:when test="${param.failed_reason=='already_logged_in'}">
		<p><fmt:message key="login.already_logged_in"><fmt:param value="${pageContext.request.remoteUser}"/></fmt:message></p>
		<p><fmt:message key="login.already_logged_in.logout_advice"/></p>
   </c:when>
   <c:otherwise>
	<p><fmt:message key="login.error.invalid_credentials"/></p>
	<c:url var="pResetReqURL" value="/account/password_reset_request.jsp">
		<c:param name="login" value="${param.j_username}"/>
	</c:url>
    <p><a href="${pResetReqURL}" id="passwordRequestLink"><fmt:message key="password.forgotten.question"/></a></p>
    <p><a href="<c:url value="/account/login_form.jsp"/>"><fmt:message key="login.forgotten.question"/></a></p>
   </c:otherwise>
  </c:choose>
</div>
</c:if>

</td></tr>
</table>

</body>
</html>

