package ipsk.db.speech.utils;

import java.util.HashSet;
import java.util.Set;

import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Session;
import ipsk.db.speech.script.Recording;

public class RecordingFileUtils {

	public static Set<RecordingFile> latestSprRecordingFiles(Session session){
		Set<RecordingFile> recFiles = session.getRecordingFiles();
		Set<RecordingFile> resRecFiles=new HashSet<RecordingFile>();
		// latest versions only
		Set<Recording> rs=new HashSet<Recording>();
		for(RecordingFile recFile:recFiles) {
			Recording r=recFile.getRecording();
			if(r!=null) {
				rs.add(r);
			}
		}

		for(Recording r:rs) {
			Set<RecordingFile> rRfs=r.getRecordingFiles();

			RecordingFile latestRf=null;
			for(RecordingFile rRf:rRfs) {
				if(rRf.getSession().equals(session)) {
					int rRfVers=rRf.getVersion();
					if(latestRf==null) {
						latestRf=rRf;
					}else {
						if(rRfVers>latestRf.getVersion()) {
							latestRf=rRf;
						}
					}
				}
			}
			if(latestRf!=null) {
				resRecFiles.add(latestRf);
			}
		}

		return resRecFiles;
	}

}
