package ipsk.webapps.db.speech;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ipsk.beans.PropertyValidationResult;
import ipsk.beans.PropertyValidationResult.Type;
import ipsk.util.LocalizableMessage;

public class InvitationUtils{

	public static final int DEFAULT_INVITATION_VALID_TIME_MS=1000*60*60*24;  // 24 hours
	

	protected PropertyValidationResult checkEmailAddress(EntityManager em,Invitation inv) {
		InternetAddress ias=null;
		String emailAddressList=inv.getEmail();
		InternetAddress[] testIas;
		PropertyValidationResult emailPvr=null;
		try {
			testIas = InternetAddress.parse(emailAddressList);
			if(testIas==null || testIas.length!=1){
				emailPvr=new PropertyValidationResult(Type.ERROR);
			}else{
				ias=testIas[0];
				ias.validate();
			}

		} catch (AddressException e1) {
			emailPvr=new PropertyValidationResult(Type.ERROR, e1);
			emailPvr.setValidationMessage(new LocalizableMessage("Error checking E-Mail address \""+emailAddressList+"\": "+e1.getMessage()));
		}
		if(ias!=null && emailPvr==null){
			String emailUsername=ias.getAddress();
			if(AccountUtils.accountExists(em, emailUsername,true)){
				emailPvr=new PropertyValidationResult(Type.ERROR, new LocalizableMessage("Account with this address already exists!"));
				HashMap<String, String[]> fps=new HashMap<String,String[]>();
				fps.put("email",new String[]{emailUsername});
				emailPvr.setFailedProperties(fps);
			}
		}
		return emailPvr;
	}
	
	public String invitationLinkRelToContext(UUID invitationUuid) {
		return "/account/new_account_form.jsp?uuid="+invitationUuid.toString();
	}
	
	private String serverPortString(HttpServletRequest req,boolean emptyIfDefault) {
		String scheme=req.getScheme();
		int port=req.getServerPort();
		String serverPortPart=":"+req.getServerPort();
		if(emptyIfDefault) {
			if("HTTPS".equalsIgnoreCase(scheme) && port==443) {
				serverPortPart="";
			}
			if("HTTP".equalsIgnoreCase(scheme) && port==80) {
				serverPortPart="";
			}
		}
		return serverPortPart;
	}
	
	public String invitationLink(HttpServletRequest req,UUID invitationUuid) {
		String invLinkRelToCtx=invitationLinkRelToContext(invitationUuid);
		return req.getScheme()+"://"+req.getServerName()+":"+req.getServerPort()+req.getContextPath()+invLinkRelToCtx;
	}
	
	public String homeLink(HttpServletRequest req) {
		String serverPortPart=serverPortString(req, true);
		return req.getScheme()+"://"+req.getServerName()+serverPortPart+req.getContextPath();
	}
	
	public String invitationValidString(Locale invLocale,Date validUntil) {
		ResourceBundle rb=ResourceBundle.getBundle("Messages",invLocale);
		StringBuffer cb=new StringBuffer();
		String invitationValidUntil=rb.getString("account.create.by_invitation.message.link_valid_until");
		cb.append(invitationValidUntil);
		DateFormat df=DateFormat.getDateTimeInstance(DateFormat.DEFAULT, DateFormat.DEFAULT, invLocale);
		String fmtValidUntilDateStr=df.format(validUntil);
		String fmtTimeZoneStr=df.getTimeZone().getDisplayName(invLocale);
		cb.append(fmtValidUntilDateStr);
		cb.append(" ");
		cb.append("("+fmtTimeZoneStr+")");
		return cb.toString();
	}
	
}
