package ipsk.webapps.db.speech;

import ipsk.db.speech.SpeechDBInfo;
import ipsk.webapps.ControllerException;
import ipsk.webapps.EntityManagerFactoryInitializer;
import ipsk.webapps.db.speech.ws.SubRecordingfileResource;

import java.nio.file.Paths;

import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class SpeechDBInitializer implements ServletContextListener {

	private static EntityManagerFactory entityManagerFactory; 
	public void contextDestroyed(ServletContextEvent arg0) {
		
		if(entityManagerFactory!=null)entityManagerFactory.close();
		entityManagerFactory=null;
	}

	public void contextInitialized(ServletContextEvent event) {
		try{
			// TODO Precheck base dir as well
			
			// Check recsDir
			var ctx=event.getServletContext();
			String recsDirParam=ctx.getInitParameter(SubRecordingfileResource.RECS_DIR_PARAM_NAME);
			if(recsDirParam==null) {
				ctx.log("WARNING: Init parameter for storage directory ('"+SubRecordingfileResource.RECS_DIR_PARAM_NAME+"') not set !\nWARNING: Recordings cannot be stored!");
			}else {
				var recsDirPath=Paths.get(recsDirParam);
				if (!recsDirPath.isAbsolute()) {
					ctx.log("WARNING: Init parameter for storage directory ('"+SubRecordingfileResource.RECS_DIR_PARAM_NAME+"') is _NOT_ an absolute path! That might not be what you want! ");
				}
			}
			// Check Entity manager Factory
			EntityManagerFactory emf=EntityManagerFactoryInitializer.getEntityManagerFactory();
			if(emf==null){
				throw new ControllerException("Could not get entity manager factory!");
			}
			
			SpeechDBInfoController infoCtrl=new SpeechDBInfoController();
			infoCtrl.setServletContext(event.getServletContext());
			infoCtrl.open();
			infoCtrl.databaseChecks();
			infoCtrl.upgrade();
			
			SpeechDBInfo newInfo=infoCtrl.addDeploymentInfo();
			
			try {
				infoCtrl.commit();
			} catch (ControllerException e) {
				e.printStackTrace();
				throw e;
			}finally{
				infoCtrl.close();
			}
			AccountController accContr=new AccountController();
			accContr.open();
			accContr.initializeAdminAccount();
			accContr.digestPasswords();
			try{
				accContr.commit();
			}catch(ControllerException ce){
				throw ce;
			}finally{
				accContr.close();
			}
		}catch(Exception e){
			event.getServletContext().log("Could not initialize administration account ! Exception: "+e);

		}
	}


}
