package ipsk.webapps.db.speech.project;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import ipsk.db.speech.Account;
import ipsk.db.speech.Project;
import ipsk.db.speech.UserRole;
import ipsk.db.speech.UserRoleId;
import ipsk.webapps.db.speech.BasicProjectAdminController;

public class AccountController extends BasicProjectAdminController<Account> {

	public AccountController() {
		super("WebSpeechDBPU", Account.class, "account");
	}

	public List<Account> filterSubjectAccounts(List<Account> accounts) {
		return AccountController.filterSubjectAccounts(owningProject, accounts);
	}
	
	public static List<Account> filterSubjectAccounts(Project project,List<Account> accounts) {
		List<Account> filteredAccs=new ArrayList<>();
		for(Account acc:accounts) {
			boolean notProjectAdmin=acc.getAdminOfProjects().isEmpty();
			Set<Project> accPrjs=acc.getProjects();
			boolean onlyThisProject=accPrjs.size()==1 && accPrjs.contains(project);
			Set<UserRole> urs=acc.getUserRoles();
			boolean hasSubjectRoleOnly=!urs.isEmpty() && urs.stream().allMatch(ur->ur.getId().getRoleName().equals(UserRoleId.RoleName.SUBJECT));
			if(notProjectAdmin && onlyThisProject && hasSubjectRoleOnly) {
				filteredAccs.add(acc);
			}
		}
		return filteredAccs;
	}

	
}
