package ipsk.webapps.jsp.taglib;

import java.io.IOException;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;

import ipsk.text.html.HTMLTextEncoder;

public class AppTitleTag extends BodyTagSupport {

	public static final String APPLICATION_SHORT_NAME= "WikiSpeech";
	
	public void setPageContext(PageContext pageContext){
		super.setPageContext(pageContext);
		
	}
	public int doStartTag() throws JspException {
		JspWriter ow = pageContext.getOut();
		ServletRequest req = pageContext.getRequest();

		try {
			ow.print(APPLICATION_SHORT_NAME);
		} catch (IOException e) {
			throw new JspException(e);
		}
		if(req instanceof HttpServletRequest) {
			HttpServletRequest request=(HttpServletRequest)req;
			
			var httpSess=request.getSession(false);
			if(httpSess!=null) {
				Object prjNmObj=httpSess.getAttribute("corpusmachine_project");
				if(prjNmObj instanceof String) {
					String prjNm=(String)prjNmObj;
					String prjNmHtml=HTMLTextEncoder.encode(prjNm);
					try {
						ow.print(" - ");
						ow.print(prjNmHtml);
					} catch (IOException e) {
						throw new JspException(e);
					}
					
				}
			}
		}
				
		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {
		
		return EVAL_PAGE;
	}


}
