package ipsk.db.speech.utils;

import ipsk.audio.export.RecordingFileExportConfiguration;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;


@ResourceBundleName("ipsk.audio.Messages")
@PreferredDisplayOrder("includeOriginalRecordingFiles,includePCMConvertedFiles,includePCMPickedChannelFiles,createSessionZIPArchive")
public class SessionExportConfiguration extends RecordingFileExportConfiguration{
	public static final String SESSION_FILE_PREFIX="session_";
	public static final String SESSION_FILE_EXTENSION="xml";
	
	protected boolean createSessionZIPArchive=true;
	
	@ResourceBundleName("Messages")
	@ResourceKey("export.createZIPArchive")
	public boolean isCreateSessionZIPArchive() {
		return createSessionZIPArchive;
	}

	public void setCreateSessionZIPArchive(boolean createSessionZIPArchive) {
		this.createSessionZIPArchive = createSessionZIPArchive;
	}
	
}
