/*
 * Date  : 12.02.2004
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.webapps.db.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;



/**
 * Servlet for upload speed testing.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
public class UploadTestServlet extends HttpServlet {

	private final static boolean DEBUG = false;
	protected final static int DEFAULT_BUFSIZE = 2048;

	protected int bufSize = DEFAULT_BUFSIZE;
	protected byte[] buf = new byte[bufSize];
	protected InputStream is;
	protected OutputStream os;
	protected FileOutputStream fos;
	protected FileInputStream fis;

	protected synchronized void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {

		long startTime = System.currentTimeMillis();
		log("Upload started !");

		String relServletPath = req.getServletPath();
		ServletContext sc = getServletContext();
		if (DEBUG)
			log("ServletPath: " + relServletPath);
		if (DEBUG)
			log("Authentication: " + req.getAuthType());
		if (DEBUG)
			log("User: " + req.getRemoteUser());
		String recsDir = sc.getInitParameter("recsDir");
		if (DEBUG)
			log("recsDir: " + recsDir);
		Enumeration params = sc.getInitParameterNames();
		if (DEBUG)
			log("Params: " + params);
		String rPath = new String(recsDir + File.separator + relServletPath);
		File f = File.createTempFile("Phatt_Upload_test", "tmp");

		if (DEBUG)
			log("Saving:" + rPath);
		try {
			if (DEBUG)
				log("Path:" + f.getCanonicalPath());
		} catch (IOException e) {
			log("Cannot get canonical path.", e);
			throw e;
		}
		log("Type: " + req.getContentType());
		long length = req.getContentLength();
		is = req.getInputStream();
		fos = new FileOutputStream(f);
		int read = 0;
		try {
			do {
				read = is.read(buf, 0, bufSize);
				if (read > 0)
					fos.write(buf, 0, read);
			} while (read >= 0);
			log("File '" + f.getAbsolutePath() + "' written.");
		} catch (IOException e) {
			throw e;
		} finally {
			if (fos != null)
				fos.close();
		}

		long stopTime = System.currentTimeMillis();
		long transferTimeMS = (stopTime - startTime);
		float rate = (float) length / (float) transferTimeMS;
		log("Transfered " + length + " bytes in " + transferTimeMS / 1000 + " seconds  (" + rate + " kByte/s).");
		res.setContentType("text/plain");
		PrintWriter pw = res.getWriter();
		pw.println("Vielen dank !");
		pw.println("Folgende Daten wurden ermittelt:");
		pw.println("Transfered " + length + " bytes in " + transferTimeMS / 1000 + " seconds  (" + rate + " kByte/s).");

	}

	protected synchronized void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
		//ServletContext sc = getServletContext();
		int BUF_SIZE = 2048;
		int TEST_FILE_LENGTH = 1000000;
		byte[] buf = new byte[BUF_SIZE];
		

		try {
			os = res.getOutputStream();

			res.setContentType("application/octet-stream");

			int read = 0;
			do {
				for (int i = 0; i < BUF_SIZE; i++) {
					buf[i] = (byte) (Math.random() * 256);
				}
				read += BUF_SIZE;

				try {
					os.write(buf, 0, BUF_SIZE);
				} catch (IOException e) {
					if (DEBUG)
						log("Outstream closed !!", e);
				}

			} while (read < TEST_FILE_LENGTH);
		} catch (IOException e) {
			throw e;
		} finally {

		}
	}

}
