package ipsk.webapps.db.speech;

import java.beans.PropertyDescriptor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;

import ipsk.db.speech.Account;
import ipsk.db.speech.DialectRegion;
import ipsk.db.speech.FormConfiguration;
import ipsk.db.speech.InformedConsent;
import ipsk.db.speech.Message;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.PropertyConfiguration;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.RecordingTrack;
import ipsk.db.speech.Session;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.SpeechRecorderClient;
import ipsk.db.speech.UserRole;
import ipsk.db.speech.UserRoleId;
import ipsk.db.speech.UserRoleId.RoleName;
import ipsk.db.speech.account.InvitationRequest;
import ipsk.db.speech.project.AutoGainControlConfig;
import ipsk.db.speech.project.LocalizedDefaultPurposeText;
import ipsk.db.speech.project.LocalizedInformedConsentText;
import ipsk.db.speech.project.MediaCaptureFormat;
import ipsk.db.speech.project.MediaStorageFormat;
import ipsk.db.speech.project.MediaStreamConstraints;
import ipsk.db.speech.script.Group;
import ipsk.db.speech.script.Nonrecording;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.script.Section;
import ipsk.persistence.EntityManagerProvider;

public class WikiSpeechSecurityManager extends AdminSecurityManager {

	public static final boolean DEBUG=false;
	
	private EntityManagerProvider controller;
	
	public WikiSpeechSecurityManager(EntityManagerProvider controller){
		this.controller=controller;
	}
	
	
	private boolean accountPermission(Account acc,Account oAcc, boolean write) {

		
		if(DEBUG)System.out.print("Account securtity check: "+oAcc.getDisplayString());
		
		if(acc==null) {
			return false;
		}
		
		// own account
		if(acc.equals(oAcc)) {
			return true;
		}
		
		if(write) {
			// do not grant write access to other project admin account
			Set<Project> oAccPrjAdms=oAcc.getAdminOfProjects();
			if(oAccPrjAdms.size()>0)return false;
		}

		// project admin account has write permissions for project related accounts
		Set<Project> accAdmProjs=acc.getAdminOfProjects();
		for(Project accAdmProj:accAdmProjs){
			// check if current user is project admin of all projects the account participates
			Set<Project> oAccPrjs=oAcc.getProjects();
			
			// Do not grant access to accounts which are not associated to a project at all 
			if(oAccPrjs.size()>0) {
				boolean allPrjsAdm=true;
				for(Project oAccPrj:oAccPrjs) {
					if(accAdmProjs.contains(oAccPrj)) {
						// project admin is allowed to read all accounts of project
						if (!write) return true;
					}else {
						// write access only if project admin of _all_ account projects
						allPrjsAdm=false;
					}
				}
				if(allPrjsAdm)return true;
			}
			
			// Organisation accounts not bound to project
			Set<Organisation> pOrgs=accAdmProj.getOrganisations();
			for(Organisation pOrg:pOrgs){
				if(pOrg.getAccounts().contains(oAcc)){
					return true;
				}
			}
		}
		
		return false;
	}
				
	protected boolean getWritePermission(HttpServletRequest req,
			Object o,PropertyDescriptor propertyDescriptor) {
		
		// admin is allowed to modify everything
		if (req.isUserInRole(UserRoleId.RoleName.ADMIN.name())){
			return true;
		}
		
		EntityManager em = controller.getThreadEntityManager();
	
		Account acc=AccountController.getAccountByRequest(req,em);
		
		if(acc==null){
			return false;
		}
		
		// rules for authenticated user

		if (o instanceof Account) {
			Account oAcc = (Account) o;
			// self account
			if (acc.equals(oAcc))
				return true;

			// rule required to add (send) a message to an foreign account
			if (propertyDescriptor != null
					&& propertyDescriptor.getName()
							.equals("messagesForToLogin")) {
				return true;
			}

		} else if (o instanceof Message) {
			if (acc != null && acc.getMessagesForFromLogin().contains(o))
				return true;
		}
		Organisation accOrga = acc.getOrganisation();
		Set<Project> accProjs=acc.getProjects();
		// rules for project admins
		if (req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			
			if(o instanceof Project){

				Project p=(Project)o;
				Set<Account> adminAccs=p.getAdminAccounts();
				if(adminAccs.contains(acc)){
					return true;
				}
			}else if(o instanceof LocalizedDefaultPurposeText) {
				LocalizedDefaultPurposeText lt=(LocalizedDefaultPurposeText)o;
				Project p=lt.getProject();
				if(p==null ||  acc.getAdminOfProjects().contains(p)) {
					return true;
				}
			}else if(o instanceof LocalizedInformedConsentText) {
				LocalizedInformedConsentText lt=(LocalizedInformedConsentText)o;
				Project p=lt.getProject();
				if(p==null || acc.getAdminOfProjects().contains(p)) {
					return true;
				}
			}else if(o instanceof MediaCaptureFormat) {
				MediaCaptureFormat mcf=(MediaCaptureFormat)o;
				String mcfId=mcf.getName();
				for(Project p:acc.getAdminOfProjects()) {
					if(p.getName().equals(mcfId)){
						return true;
					}
				}
			}else if(o instanceof MediaStorageFormat) {
				MediaStorageFormat msf=(MediaStorageFormat)o;
				String msfId=msf.getName();
				for(Project p:acc.getAdminOfProjects()) {
					if(p.getName().equals(msfId)){
						return true;
					}
				}
			}else if(o instanceof AutoGainControlConfig) {
				AutoGainControlConfig agcc=(AutoGainControlConfig)o;
				Project pr=agcc.getProject();
				if(pr!=null) {
					String prNm=pr.getName();
					for(Project p:acc.getAdminOfProjects()) {
						if(p.getName().equals(prNm)){
							return true;
						}
					}
				}
			}else if(o instanceof Session){
				if(acc!=null){
					Session oSess=(Session)o;
					if(accOrga!=null){
						if(accOrga.equals(oSess.getOrganisation()))return true;
						Set<Project> orgaProjs=accOrga.getProjects();
						if(orgaProjs.contains(oSess.getProject()))return true;
						
					}
					if(accProjs!=null){
						if(accProjs.contains(oSess.getProject()))return true;
					}
					Set<Project> accAdmProjs=acc.getAdminOfProjects();
					if(accAdmProjs.contains(oSess.getProject())) return true;
				}
			}else if(o instanceof Script){

				Script s=(Script)o;
				Project owniPrj=s.getOwningProject();
				if(owniPrj!=null){
					Set<Account> adminAccsOPrj=owniPrj.getAdminAccounts();
					if(adminAccsOPrj.contains(acc)){
						return true;
					}
				}

				Set<Project> scrPrjs=s.getProjects();
				for(Project scrPrj:scrPrjs){
					Set<Account> adminAccs=scrPrj.getAdminAccounts();
					if(adminAccs.contains(acc)){
						return true;
					}
				}
			}else if (o instanceof Organisation) {

				Organisation organisation = (Organisation) o;
				Set<Project> orgaProjects = organisation.getProjects();
				for(Project p:orgaProjects){
					Set<Account> adminAccs=p.getAdminAccounts();
					if(adminAccs.contains(acc)){
						return true;
					}
				}
			}else if (o instanceof FormConfiguration) {

				FormConfiguration fc=(FormConfiguration)o;
				Project ownPrj=fc.getOwningProject();
				if(acc.getAdminOfProjects().contains(ownPrj)) {
					return true;
				}
				
			}else if (o instanceof PropertyConfiguration) {
				PropertyConfiguration pc=(PropertyConfiguration)o;
				FormConfiguration fc=pc.getFormConfiguration();
				Project ownPrj=fc.getOwningProject();
				if(acc.getAdminOfProjects().contains(ownPrj)) {
					return true;
				}
				
			}else if (o instanceof Account) {
				Account oAcc=(Account)o;
				return accountPermission(acc, oAcc, true);
				
			} else if (o instanceof UserRole) {
				UserRole userRole = (UserRole) o;
				Account urAcc = userRole.getAccount();
				UserRoleId urId=userRole.getId();
				if(urId!=null){
				RoleName rn=urId.getRoleName();
				if (UserRoleId.RoleName.ORGANISATION.equals(rn)) {
					if(urAcc==null)return true;
					if (urAcc.equals(acc))
						return true;
					Set<Project> projs = acc.getAdminOfProjects();
					for (Project p : projs) {
						Set<Organisation> pOrgs = p.getOrganisations();
						for (Organisation pOrg : pOrgs) {
							// if(pOrg.getAccounts().contains(oAcc))return true;
//							if (urAcc.equals(pOrg.getAccount()))
//								return true;
//							
							if(pOrg.getAccounts().contains(urAcc)){
								return true;
							}
						}
					}
				}
				}else{
					if(urAcc==null)return true;
				}
			}else if (o instanceof Speaker){
				Speaker oSpk=(Speaker)o;
				if(oSpk.equals(acc.getPerson())){
					return true;
				}
				Set<Speaker> spkDatas=acc.getSpeakerData();
				for(Speaker spkData:spkDatas) {
					if(oSpk.equals(spkData)) {
						return true;
					}
				}

				Set<Project> accAdmProjects=acc.getAdminOfProjects();
				for(Project accAdmProj:accAdmProjects){
					Set<Session> projSesss=accAdmProj.getSessions();
					for(Session projSess:projSesss){
						if(projSess.getSpeakers().contains(oSpk)){
							return true;
						}
					}
					Set<Account> accAdmPrjAccs=accAdmProj.getAccounts();
					for(Account accAdmPrjAcc:accAdmPrjAccs) {
						Person accAdmPrjAccPers=accAdmPrjAcc.getPerson();
						if(accAdmPrjAccPers!=null) {
							
							if(oSpk.equals(accAdmPrjAccPers)) {
								// Only allow for non administrator accounts 
								if(!(AccountController.accountHasUserRole(accAdmPrjAcc, UserRoleId.RoleName.ADMIN) ||
									 AccountController.accountHasUserRole(accAdmPrjAcc, UserRoleId.RoleName.PROJECT_ADMIN))){
									
									// project admins need to be able to remove speaker data of subject accounts
									return true;
								}
									
							}
						}
						Set<Speaker> accAdmPrjAccSpkDatas=accAdmPrjAcc.getSpeakerData();
						for(Speaker accAdmPrjAccSpkData:accAdmPrjAccSpkDatas) {
							
							if(oSpk.equals(accAdmPrjAccSpkData)) {
								// Only allow for non administrator accounts 
								if(!(AccountController.accountHasUserRole(accAdmPrjAcc, UserRoleId.RoleName.ADMIN) ||
									 AccountController.accountHasUserRole(accAdmPrjAcc, UserRoleId.RoleName.PROJECT_ADMIN))){
									
									// project admins need to be able to remove speaker data of subject accounts
									return true;
								}
									
							}
						}
					}
					
				}
				
				Set<Organisation> spkOrgs=oSpk.getOrganisations();
				for(Organisation spkOrg:spkOrgs){
					Set<Project> spkProjects=spkOrg.getProjects();
					
					for(Project accAdmProject:accAdmProjects){
						if(spkProjects.contains(accAdmProject))return true;
					}
				}
			}else if(o instanceof InformedConsent) {
				InformedConsent ic=(InformedConsent)o;
				Speaker icSpk=ic.getSpeaker();
				if(icSpk!=null) {
					boolean icSpkWrPerm=getWritePermission(req, icSpk,null);
					return icSpkWrPerm;
				}
			}else if(o instanceof RecordingFile) {
			
				RecordingFile oRf=(RecordingFile)o;
				Session rfS=oRf.getSession();
				Set<Project> accAdmProjects=acc.getAdminOfProjects();
				for(Project accAdmProj:accAdmProjects){
					Set<Session> projSesss=accAdmProj.getSessions();
					if(projSesss.contains(rfS)) {
						return true;
					}
				}
			}else if(o instanceof RecordingTrack) {
			
				RecordingTrack oRt=(RecordingTrack)o;
				RecordingFile oRf=oRt.getRecordingFile();
				boolean wp=getWritePermission(req, oRf,null);
				if(wp) {
					return true;
				}
				
			}
		}
		
		if(req.isUserInRole(UserRoleId.RoleName.SUBJECT.name()) || req.isUserInRole(UserRoleId.RoleName.ORGANISATION.name()) || req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			if(o instanceof Session){
				if(acc!=null){
					Session oSess=(Session)o;
					
					Person accPerson=acc.getPerson();
					if(accPerson!=null) {
						// compare IDs here since Person is base class of Speaker
						int accPersId=accPerson.getPersonId();
						Set<Speaker> sessSpks=oSess.getSpeakers();
						for(Speaker sessSpk:sessSpks) {
							int sessSpkId=sessSpk.getPersonId();
							if(accPersId==sessSpkId) {
								// Personal account and person/speaker is participant of this session
								// Is allowed to write to session.
								return true;
							}
						}
					}
					
					Set<Speaker> spkDatas=acc.getSpeakerData();
					for(Speaker spkData:spkDatas) {
						int spkDataPersId=spkData.getPersonId();
						Set<Speaker> sessSpks=oSess.getSpeakers();
						for(Speaker sessSpk:sessSpks) {
							int sessSpkId=sessSpk.getPersonId();
							if(spkDataPersId==sessSpkId) {
								// Personal account and person/speaker is participant of this session
								// Is allowed to write to session.
								return true;
							}
						}
					}
					
					if(accOrga!=null){
						// allow to read/write to "own" sessions
						if(accOrga.equals(oSess.getOrganisation()))return true;
					}
				}
			}else if(o instanceof Script){
				// allow subject to set script to session (and therefore to add to sessionsSet of script)
				
				if(propertyDescriptor!=null && "sessions".equals(propertyDescriptor.getName()))return true;
				
			}else if (o instanceof Speaker){
					Speaker oSpk=(Speaker)o;
					if(oSpk.equals(acc.getPerson())){
						return true;
					}
					Set<Speaker> accSpkDatas=acc.getSpeakerData();
					for(Speaker accSpkData:accSpkDatas) {
						if(oSpk.equals(accSpkData)) {
							return true;
						}
					}
					
					if(accOrga!=null){
						Set<Person> persons = accOrga.getPersons();
						if (persons.contains(oSpk)){
							return true;
						}
					}
					Account regAcc=oSpk.getRegisteredByAccount();
					if(acc.equals(regAcc)){
						return true;
					}
					
				}else if (o instanceof InformedConsent){
					InformedConsent ic=(InformedConsent)o;
					Speaker icSpk=ic.getSpeaker();
					if(icSpk!=null) {
						boolean icSpkWrPerm=getWritePermission(req, icSpk,null);
						return icSpkWrPerm;
					}
				}else if (o instanceof Organisation){
				
					Organisation oOrg=(Organisation)o;
					if (oOrg.equals(acc.getOrganisation()) && propertyDescriptor != null){
						if("persons".equals(propertyDescriptor.getName()))return true;
						if("sessions".equals(propertyDescriptor.getName()))return true;
					}
					
				}else if (o instanceof Project){
					Project oProj=(Project)o;
					if(accOrga!=null){
						Set<Project> accOrgaProjs=accOrga.getProjects();
						if(accOrgaProjs.contains(oProj) && propertyDescriptor != null && "sessions".equals(propertyDescriptor.getName()))return true;
					}
					if(accProjs!=null){
						if(accProjs.contains(oProj) && propertyDescriptor != null && "sessions".equals(propertyDescriptor.getName()))return true;
					}
				}else if (o instanceof DialectRegion){
					DialectRegion oDR=(DialectRegion)o;
					if(accOrga!=null){
						Set<Project> accOrgaProjs=accOrga.getProjects();
						Set<Project> accAdmProjs=acc.getAdminOfProjects();
						HashSet<Project> assProjects=new HashSet<Project>();
						assProjects.addAll(accOrgaProjs);
						assProjects.addAll(accAdmProjs);
						for(Project aPrj:assProjects){
							String aPrkName=aPrj.getName();
						}
						for(Project drPr:oDR.getProjects()){
//							if(accProjs.contains(drPr)){
							if(assProjects.contains(drPr)){
								if(propertyDescriptor !=null && propertyDescriptor.getName().equals("speakers")){
									return true;
								}
							}
						}
					}
				}
		}
		
		
		return false;
	}

	public boolean getRemovePermission(HttpServletRequest req,
			Object o) {
		if(o instanceof Account) {
			Account oAcc=(Account)o;
			Account acc=AccountController.getAccountByRequest(req, controller.getThreadEntityManager());
			
			// user should be able to delete his own account
			if(oAcc.equals(acc)) {
				return true;
			}
		}
		return getWritePermission(req, o,null);
	}

	public boolean getReadPermission(HttpServletRequest req, Object o) {
		if(getWritePermission(req, o,null))return true;
		Account acc=AccountController.getAccountByRequest(req, controller.getThreadEntityManager());
		
		if(req.isUserInRole(UserRoleId.RoleName.PROJECT_ANNOTATOR.name())) {
			// allow project annotator to read
			if(o instanceof Session){
				if(acc!=null){
					Session oSess=(Session)o;
					Set<Project> accProjs=acc.getProjects();
					if(accProjs.contains(oSess.getProject())) return true;
				}
			}
		}
		
		if(o instanceof Project){
			Project project=(Project)o;
			if(acc!=null) {
				if(project.getAdminAccounts().contains(acc))return true;

				if(project.getAccounts().contains(acc))return true;

				Organisation accOrga=acc.getOrganisation();
				if(accOrga!=null) {
					Set<Organisation> prjOrgas=project.getOrganisations();
					if(prjOrgas.contains(accOrga)) {
						return true;
					}
				}
			}
		}else if (o instanceof InvitationRequest) {
			InvitationRequest ir=(InvitationRequest)o;
			List<Project> irPrjs=ir.getProjects();
			for(Project irPrj:irPrjs){
				Set<Account> adminAccs=irPrj.getAdminAccounts();
				if(adminAccs.contains(acc)){
					return true;
				}
			}
			Organisation orga=ir.getOrganisation();
			if(orga!=null) {
				Set<Project> orgaPrjs=orga.getProjects();
				for(Project orgaPrj:orgaPrjs) {
					Set<Account> adminAccs=orgaPrj.getAdminAccounts();
					if(adminAccs.contains(acc)){
						return true;
					}
				}
			}
		}else if (o instanceof Account) {
			Account oAcc=(Account)o;
			return accountPermission(acc, oAcc, false);
			
		}else if(o instanceof Message && acc!=null){
			if(acc!=null && acc.getMessagesForToLogin().contains(o))return true;
		}else if(o instanceof Session){
			Session oSess=(Session)o;
			// Project admins are allowed
			if(oSess.getProject().getAdminAccounts().contains(acc))return true;
			
			Organisation accOrga=acc.getOrganisation();
			if(accOrga!=null) {
				// rganisation account
				Organisation sessOrga=oSess.getOrganisation();
				if(accOrga.equals(sessOrga)){
					// Organisation is creator of session
					return true;
				}
			}
			
		}else if(o instanceof RecordingFile){
			RecordingFile oRf=(RecordingFile)o;
			Session rfSess=oRf.getSession();
			if(rfSess!=null){
				
				Project rfPrj=rfSess.getProject();
				if(rfPrj!=null){
					// project admins are allowed
					if(rfPrj.getAdminAccounts().contains(acc)){
						return true;
					}
				}
				Person accPers=acc.getPerson();
				if(accPers!=null){
					Set<Speaker> rfSpks=rfSess.getSpeakers();
					// allow speakers to access their recording files
					for(Speaker rfSpk:rfSpks){
						if(rfSpk.equals(accPers)){
							return true;
						}
					}
				}
				Set<Speaker> accSpkDatas=acc.getSpeakerData();
				for(Speaker accSpkData:accSpkDatas){
					Set<Speaker> rfSpks=rfSess.getSpeakers();
					// allow speakers (data) to access their recording files
					for(Speaker rfSpk:rfSpks){
						if(rfSpk.equals(accSpkData)){
							return true;
						}
					}
				}
				
				Organisation accOrga=acc.getOrganisation();
				if(accOrga!=null) {
					Set<Speaker> rfSpks=rfSess.getSpeakers();
					Set<Person> orgaPersons=accOrga.getPersons();
					// allow organisations to access the recording files of their speakers
					for(Speaker rfSpk:rfSpks){
						for(Person orgaPers:orgaPersons) {
							if(rfSpk.equals(orgaPers)){
								return true;
							}
						}
					}
				}
			}
		}else if(o instanceof Organisation){
			Organisation oOrg=(Organisation)o;
			if(acc!=null){
				Organisation accOrga=acc.getOrganisation();
				if(oOrg.equals(accOrga))return true;
			}
		}else if(o instanceof Recording){
			Recording r=(Recording)o;
			Group g=r.getGroup();
			if(g!=null){
				return getReadPermission(req, g);
			}
		}else if(o instanceof Nonrecording){
			Nonrecording nr=(Nonrecording)o;
			Group g=nr.getGroup();
			if(g!=null){
				return getReadPermission(req, g);
			}
		}else if(o instanceof Group){
			Group g=(Group)o;
			Section s=g.getSection();
			if(s!=null){
				return getReadPermission(req, s);
			}
		}else if(o instanceof Section){
			
			Section s=(Section)o;
			Script sc=s.getScript();
			if(sc!=null)return getReadPermission(req, sc);
		}else if(o instanceof Script){
			
			Script sc=(Script)o;
			
			Person pe=acc.getPerson();
			// TODO
			//acc.getSpeakerData();
			if(pe instanceof Speaker){
				Speaker spk=(Speaker)pe;
				Set<Session> sesss=spk.getSessions();
				for(Session sess:sesss){
					if(sc.equals(sess.getScript())){
						return true;
					}
				}
			}
			Set<Speaker> spkDatas=acc.getSpeakerData();
			for(Speaker spkData:spkDatas) {
				Set<Session> sesss=spkData.getSessions();
				for(Session sess:sesss){
					if(sc.equals(sess.getScript())){
						return true;
					}
				}
			}
			Set<Project> prjS=sc.getProjects();
			for(Project p:prjS){
				for(Account admAcc:p.getAdminAccounts()){
					if(admAcc.equals(acc))return true;
				}
				if(p.getAccounts().contains(acc)){
					return true;
				}
				Organisation orga=acc.getOrganisation();
				if(orga!=null){
					if(orga.getProjects().contains(p)){
						return true;
					}
				}
			}
			
			// WSP-0067 2022-02-14 Fixed 2022-02-14 2.34.3 
			// "Permission denied viewing a recording script as project-admin if script is in application scope and not in the set of activated scripts."
			Set<Session> scriptSessions=sc.getSessions();
			for(Session scSess:scriptSessions) {
				Project scrSessPrj=scSess.getProject();
				if(scrSessPrj!=null && scrSessPrj.getAdminAccounts().contains(acc)){
					return true;
				}
			}
			
		}else if (o instanceof SpeechRecorderClient){
			// Speechrecorder client enumeration readable for all
			return true;
		}else if (o instanceof Speaker){
			Speaker oSpk=(Speaker)o;
		
			Set<Project> accAdmProjects=acc.getAdminOfProjects();
			for(Project accAdmProj:accAdmProjects){
				
				Set<Account> accAdmPrjAccs=accAdmProj.getAccounts();
				for(Account accAdmPrjAcc:accAdmPrjAccs) {
					Person accAdmPrjAccPers=accAdmPrjAcc.getPerson();
					if(accAdmPrjAccPers!=null) {
						
						if(oSpk.equals(accAdmPrjAccPers)) {
								// project admins need to be able to view speaker data of all members
								return true;
								
						}
					}
					Set<Speaker> accAdmPrjAccSpkDatas=accAdmPrjAcc.getSpeakerData();
					for(Speaker accAdmPrjAccSpkData:accAdmPrjAccSpkDatas) {
						if(oSpk.equals(accAdmPrjAccSpkData)) {
							return true;
						}
					}
					
				}
				Set<Speaker> spkDataOfProject=accAdmProj.getSpeakers();
				if(spkDataOfProject.contains(oSpk)) {
					return true;
				}
			}
		}
		
		return false;
	}

	@Override
	public boolean getMergePermission(HttpServletRequest req,
			Object o,PropertyDescriptor propertyDescriptor) {

		// admin is allowed to modify everything
		if (req.isUserInRole(UserRoleId.RoleName.ADMIN.name()))
			return true;
		if(getWritePermission(req, o, propertyDescriptor))return true;

		EntityManager em = controller.getThreadEntityManager();
		Account acc=AccountController.getAccountByRequest(req,em);
		if (acc == null) {
			return false;
		}

		if (o instanceof Account) {
			//  rule required to add (send) a message to an foreign account
			if(propertyDescriptor!=null && propertyDescriptor.getName().equals("messagesForToLogin")){
				return true;
			}
		}
		if (req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {

			if (o instanceof Project) {
				Project p = (Project) o;
				Set<Account> adminAccs = p.getAdminAccounts();
				if (adminAccs.contains(acc)) {
					return true;
				}
			} else if (o instanceof Organisation) {
				Organisation organisation = (Organisation) o;
				Set<Project> orgaProjects = organisation.getProjects();
				for(Project p:orgaProjects){
					Set<Account> adminAccs=p.getAdminAccounts();
					if(adminAccs.contains(acc)){
						return true;
					}
				}
			} else if(o instanceof Session){
				Session oSess=(Session)o;
				Project sessPrj=oSess.getProject();
				if(acc.getAdminOfProjects().contains(sessPrj)) {
					return true;
				}
				if(acc.getProjects().contains(sessPrj)) {
					return true;
				}
			}
		 
		}
		
		if (req.isUserInRole(UserRoleId.RoleName.SUBJECT.name())) {
			 if(o instanceof Session){
					Session oSess=(Session)o;
					Project sessPrj=oSess.getProject();
					if(acc.getProjects().contains(sessPrj)) {
						return true;
					}
				}
			if (o instanceof InformedConsent) {
				// TODO
				return true;
			} 
		}
		
		return false;
	}

	@Override
	public boolean getPersistPermission(HttpServletRequest req,
			Object o) {
		if (req.isUserInRole(UserRoleId.RoleName.ADMIN.name())){
			return true;
		}

		EntityManager em = controller.getThreadEntityManager();
		Account acc=AccountController.getAccountByRequest(req,em);
		if (acc == null) {
			return false;
		}

		// authenticated user
		if(o instanceof Message){
			Message msg=(Message)o;
			if(msg.getAccountByFromLogin()==null && msg.getAccountByToLogin()==null)return true;
		}else if(o instanceof Speaker){
			Speaker oSpk=(Speaker)o;
			Account oSpkAcc=oSpk.getAccount();
			Account oSpkDataAcc=oSpk.getSpeakerDataAccount();
			Set<Organisation> oSpkOrgs=oSpk.getOrganisations();
			Set<Session> oSpkSess=oSpk.getSessions();
			if(oSpkAcc==null && oSpkDataAcc==null && oSpkOrgs.size()==0 && oSpkSess.size()==0)return true;
		}
		
		// project admins
		if (req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			if (o instanceof Organisation) {
				Organisation organisation = (Organisation) o;
				// on persist no project is set
				Set<Project> orgaProjects = organisation.getProjects();
				if (orgaProjects != null && orgaProjects.size() > 0) {
					return false;
				}
				return true;
			}else if( o instanceof Account){
				Account newAcc=(Account)o;
				if(newAcc.getOrganisation()==null && newAcc.getPerson()==null && newAcc.getSpeakerData().size()==0 && newAcc.getUserRoles().size()==0){
					return true;
				}
			}else if(o instanceof UserRole){
				if(getWritePermission(req, o, null))return true;
			}else if(o instanceof InformedConsent) {
				 return true;
			}else if(o instanceof FormConfiguration) {
				
				 return true;
			}else if(o instanceof PropertyConfiguration) {
				PropertyConfiguration pc=(PropertyConfiguration)o;
				FormConfiguration fc=pc.getFormConfiguration();
				//if(acc.getAdminOfProjects().contains(fc.getOwningProject())) {
				 return true;
				//}
			}else if(o instanceof LocalizedDefaultPurposeText || 
					o instanceof LocalizedInformedConsentText  || 
					o instanceof MediaStreamConstraints ||
					o instanceof AutoGainControlConfig) {
				return true;
				
			}else if(o instanceof MediaCaptureFormat) {
				MediaCaptureFormat mcf=(MediaCaptureFormat)o;
				String mcfId=mcf.getName();
				for(Project p:acc.getAdminOfProjects()) {
					if(p.getName().equals(mcfId)){
						return true;
					}
				}
			}else if(o instanceof MediaStorageFormat) {
				MediaStorageFormat msf=(MediaStorageFormat)o;
				String msfId=msf.getName();
				for(Project p:acc.getAdminOfProjects()) {
					if(p.getName().equals(msfId)){
						return true;
					}
				}
			}
		}
		
		if(req.isUserInRole(UserRoleId.RoleName.SUBJECT.name()) || req.isUserInRole(UserRoleId.RoleName.ORGANISATION.name()) || req.isUserInRole(UserRoleId.RoleName.PROJECT_ADMIN.name())) {
			 if(o instanceof Session){
					Session oSess=(Session)o;
					if(oSess.getProject()==null)return true;
				
			 }else if(o instanceof InformedConsent) {
				 return true;
			 }
		}
		return false;
	}
	
}
